load 'spillvsfreq';


figure;
hold on;
x1_bin=floor(x1_tot/50);


xs=[];
ys=[];
yes=[]
for i=0:6

    xs=[xs (i+0.5)*50];
    
    xrng=x1_bin(x1_bin==i);
    yrng=100*(y1_tot( (x1_bin==i) & (y1_tot>0) & (y1_tot<1.5)));
    ymn=mean(yrng);
    ystd=std(yrng)./sqrt(8);
    %(i,yrng,'ro');
    
    ys=[ys ymn];
    yes=[yes ystd];
    
end;

plot(xs,ys,'r');
errorbar(xs,ys,yes,'ro');

ylabel('Phasic (% of total current)');
xlabel('Frequency of events');
ylim([40 100]);
xlim([0 350]);

axe=gca;

set(gcf, 'PaperPositionMode', 'auto');

set(axe,'FontName','arial')
set(axe,'fontsize',14)
set(gca,'TickDir','out');
set(gca,'Box','off');
set(gca,'TickLength',[0.02 0.025]);
%set(gca,'XTick',[1 2])
%set(gca,'XTickLabel',{'Long time';'short time'})
set(gcf,'position',[100, 200, 500, 400])
print('-depsc','-r400','figs/spillvsfreq.eps')



figure;
hold on;

I=randperm(length(x2_tot));
x=x2_tot(I);
y=y2_tot(I);
%m2_tot=m2_tot(I);


    
for i=1:length(x)
    col='b';
    plot(x(i),y(i),'ko','Color',col,'MarkerFaceColor',col);

%     ag_plot_little_circles(x(i), y(i), 4,col, 0.4);
%     pause(0.001);
end
