load 'spillvsfreq';


figure;
hold on;
x1_bin=floor(x1_tot/50);


xs=[];
ys=[];
yes=[]
for i=0:6

    xs=[xs (i+0.5)*50];
    
    
    ind=(x1_bin==i) & ~isnan(fast_charges);
    xrng=x1_bin(ind);
    
    yrng=(-fast_charges(ind) + spill_charges(ind));
    
    ymn=mean(yrng);
    ystd=std(yrng)./sqrt(8);
    %(i,yrng,'ro');
    
    ys=[ys ymn];
    yes=[yes ystd];
    
end;

plot(xs,ys*1e9,'r');
plot(xs(1),ys(1)*1e9,'b');
legend('with spillover','without spillover', 'Location', 'NorthWest');
plot(xs(1),ys(1)*1e9,'r');
errorbar(xs,ys*1e9,yes*1e9,'ro');


xs=[];
ys=[];
yes=[]
for i=0:6

    xs=[xs (i+0.5)*50];
    
    
    ind=(x1_bin==i) & ~isnan(fast_charges);
    xrng=x1_bin(ind);
    
    yrng=(-fast_charges(ind));
    
    ymn=mean(yrng);
    ystd=std(yrng)./sqrt(8);
    %(i,yrng,'ro');
    
    ys=[ys ymn];
    yes=[yes ystd];
    
end;

plot(xs,ys*1e9,'b');
errorbar(xs,ys*1e9,yes*1e9,'bo');



ylabel('charge transfer (nC)');
xlabel('Frequency of events');

xlim([0 350]);
ylim([0 10]);

axe=gca;

set(gcf, 'PaperPositionMode', 'auto');

set(axe,'FontName','arial')
set(axe,'fontsize',14)
set(gca,'TickDir','out');
set(gca,'Box','off');
set(gca,'TickLength',[0.02 0.025]);
%set(gca,'XTick',[1 2])
%set(gca,'XTickLabel',{'Long time';'short time'})
set(gcf,'position',[100, 200, 500, 400])
print('-dmeta','-r400','figs/spillgain.emf')



figure;
hold on;

I=randperm(length(x2_tot));
x=x2_tot(I);
y=y2_tot(I);
%m2_tot=m2_tot(I);


    
for i=1:length(x)
    col='b';
    plot(x(i),y(i),'ko','Color',col,'MarkerFaceColor',col);

%     ag_plot_little_circles(x(i), y(i), 4,col, 0.4);
%     pause(0.001);
end
