function [analysis]=spillspikeanalysis(recording,thresh,figname,sampInt,fastfit,slowfit)




slowfit=slowfit';
recording=recording';
spikevec=1.0*(recording>thresh);

spikevec=[(diff(spikevec)>0) 0]&(spikevec==0);


%f1=figure;
%plot(recording);

%hold on;


spikeIs=find(spikevec)+2;

analysis.bursts=[];

if length(spikeIs)==0
    'nada!'
    
%    pause;
    return;
end;

bursts=cell(0);
numburst=0;

burst=[];
maxISI=50e-3;


%maxISI=50e-3;


%spikeIs
%pause;

lastSpike=spikeIs(1);
for i=2:length(spikeIs)
    
    
    
    currSpike=spikeIs(i);
    ISI=currSpike-lastSpike;
    ISI=ISI.*sampInt;
    
   
    
    
    if ( (i==length(spikeIs)) || (ISI>maxISI) & i>2)
    
        numburst=numburst+1;
        bursts{numburst}=burst;
        burst=[];
        
        
    end;
    
    burst=[burst currSpike];
    
    
    lastSpike=currSpike;
end;

%size(bursts)

%for i=1:length(bursts)
%    bursts{i}
%   
%end;


%figure(f1);
%hold on;
%plot(spikeIs,recording(spikeIs),'ro');

for i=1:length(bursts)
    currburst=bursts{i};
    
  %  h=line([currburst(1) (currburst(length(currburst))+100)] ,[50 50],'LineWidth',4,'Color',[.8 .8 .8]);
    
end;





%figure;
%hold on;
%plot(datmat','k');
%plot(mean(datmat),'r');

winsize=floor(0.2/sampInt); %%%dude 0.2

datmat=[];
emat=[];
depolmat=[];


slowmat=[];
fastmat=[];


for i=1:length(bursts)

    b=bursts{i};
    
    if length(b)<4
        continue
    end;
    
    currSpike=b(1);
    
    
    startind=currSpike-winsize;
    endind=currSpike+winsize;
    
    blsize=floor(20e-3/sampInt);
    depolstart=floor(1e-3/sampInt);
    depolend=floor(6e-3/sampInt);
    
    bl_ind=1:(winsize-blsize);
    depol_ind=(winsize+depolstart:winsize+depolend);
    
    if startind>1 & endind<length(recording)
        win=recording(startind:endind);
        
        depol=mean(win(depol_ind))-mean(win(bl_ind));
        
        
        
        slowwin=slowfit(ceil(startind/2):ceil(endind/2));
        fastwin=fastfit(ceil(startind/2):ceil(endind/2));
        
        depolmat=[depolmat; depol];
        slowmat=[slowmat; slowwin];
        fastmat=[fastmat; fastwin'];
        
        [r]=getEPSPs(win,1);
        
        et=0.*win;
        et(r)=1;
        emat=[emat;et];
        
        
        
        datmat=[datmat; win];
    end;
    
end;

%save('datm','datmat');
%pause;

figure;
hold on;


ts=1000*sampInt.*(1:size(datmat,2));

rate=mean(emat)./sampInt;
t=0:100;
lambda=0.01;
kernel=exp(-t.*lambda);
kernel=fliplr(kernel);
kernel=kernel./sum(kernel);
rate=conv(rate,kernel,'same');

subplot(211);
plot(ts,datmat','k');
hold on;



if size(ts,2)>0

plot(ts,mean(datmat),'r','LineWidth',0.8);

title('mean burst Vm')
axe=gca;
set(axe,'FontName','arial')
set(axe,'fontsize',14)
set(gca,'TickDir','out');
set(gca,'Box','off');
set(gca,'TickLength',[0.02 0.025]);
set(gcf, 'PaperPositionMode', 'auto');
xlim([0 400]);


subplot(212);
hold on;
ts2=1000*(sampInt*2).*(1:size(slowmat,2));
plot(ts2,slowmat,'k');
plot(ts2,mean(slowmat),'r');
title('slow current')
ylabel('pA');
xlabel('time (ms)');
xlim([0 400]);


axe=gca;
set(axe,'FontName','arial')
set(axe,'fontsize',14)
set(gca,'TickDir','out');
set(gca,'Box','off');
set(gca,'TickLength',[0.02 0.025]);
set(gcf, 'PaperPositionMode', 'auto');
print('-depsc','-r400',figname);



end;

analysis.bursts=bursts;
analysis.depolmat=depolmat;
analysis.fastmat=fastmat;
analysis.slowmat=slowmat;
analysis.datmat=datmat;

