close all;
clear;

load('spillspikefreqdata');

cols={'ro','go','bo','mo','co','r*','g*','b*','m*'};



figure;
hold on;


%plot(freq_depol,freq_f,'ro');


for i=1:length(freq_depol)
    freq_cell(i)
    plot(freq_depol(i),freq_f(i),cols{freq_cell(i)});
end;



 [R,P]=corrcoef(freq_depol,freq_f);

 R
 P
 PO = polyfit(freq_depol,freq_f,1);
 
 
 x=-5:1:30;
 size(freq_f)
 
 plot(x,polyval(PO,x),'k');
 
ylabel('Burst frequency (Hz)');
xlabel('Burst depolarization (mV)');
axe=gca;
set(gcf, 'PaperPositionMode', 'auto');

set(axe,'FontName','arial')
set(axe,'fontsize',14)
set(gca,'TickDir','out');
set(gca,'Box','off');
set(gca,'TickLength',[0.02 0.025]);

print('-depsc','-r400','figs/model_burstfreqdepol.eps')


%freq_n=[];
%freq_cell=[];
%freq_T=[];

figure
hold on;
for i=1:length(freq_depol)
    freq_cell(i)
    plot(freq_depol(i),freq_n(i),cols{freq_cell(i)});
end;
ylabel('Number of spikes in burst');
xlabel('Burst depolarization (mV)');
print('-depsc','-r400','figs/model_burstnumdepol.eps')

figure
hold on;
for i=1:length(freq_depol)
    freq_cell(i)
    plot(freq_depol(i),freq_T(i),cols{freq_cell(i)});
end;
ylabel('duration of burst (seconds)');
xlabel('Burst depolarization (mV)');
print('-depsc','-r400','figs/model_burstdurationdepol.eps')


dt=2.5000e-05;
ts1=dt*(1:size(datmats,2));
ts2=2*dt*(1:size(slowmats,2));

figure;
subplot(311);
hold on;
plot(ts1,datmats','k');
plot(ts1,mean(datmats),'r');
xlim([0 0.4]);
ylabel('voltage (mv)');
xlabel('time (seconds');

subplot(312);
hold on;
%plot(slowmats','k');


for i=1:size(slowmats,1)
    slowmats(i,:)=slowmats(i,:)-mean(slowmats(i,:));
end;

alexerrorbar(ts2,mean(slowmats),std(slowmats)./sqrt(size(slowmats,1)-1),'r',0);
xlim([0 0.4]);
ylabel('slow current (pA)');

subplot(313);
hold on;
%plot(fastmats','k');
%plot(mean(fastmats),'r');
for i=1:size(fastmats,1)
    fastmats(i,:)=fastmats(i,:)-mean(fastmats(i,:));
end;
alexerrorbar(ts2,mean(fastmats),std(fastmats)./sqrt(size(fastmats,1)-1),[1 0 0]',0);
xlim([0 0.4]);
ylabel('fast current (pA)');
print('-depsc','-r400','figs/model_bursttrigerredcurrents.eps')
