load 'spillvsfreq';




binsize=50;
numbins=6;
numcells=9;

figure;
hold on;
x2_bin=floor(x2_tot/binsize);


xs=[];
ys=[];
yes=[]
ys2=[];
yes2=[];
mtns=[];


figure;

cols={'r','g','b','k','c','m','y'};




mtcorrected=mtxs_tot;

for i=1:numcells;
    mtcorrected(cells_tot==i)=mtcorrected(cells_tot==i)./max(mtcorrected(cells_tot==i));
end;
mtxs_tot=mtcorrected;



for i=0:numbins

    xs=[xs (i+0.5)*binsize];
    
    xrng=x2_bin(x2_bin==i);
    yrng=(y2_tot( (x2_bin==i) ));
    ymn=mean(yrng);
    ystd=std(yrng)./sqrt(8);
    %(i,yrng,'ro');
    
    ys=[ys ymn];
    yes=[yes ystd];
    
    
    
    
    yrng=(y3_tot( (x2_bin==i) ));
    ymn=mean(yrng);
    ystd=std(yrng)./sqrt(8);
    %(i,yrng,'ro');
    
    ys2=[ys2 ymn];
    yes2=[yes2 ystd];
    
    
    
    mtnrng=(mtxs_tot( (x2_bin==i) ));
    
    
    
    cellsrng=(cells_tot( (x2_bin==i) ));
    
   
%    plot(cellsrng,mtnrng,'bo');
%    xlim([0 10]);
%    ylim([0 1]);
%    pause;

    
    mtnmn=mean(mtnrng);
    %(i,yrng,'ro');
    
    mtns=[mtns mtnmn];
   
    
end;


divs=100;
c_mp=flipud(autumn(divs));


colormap(c_mp);


hold on;

xlim([0 400]);


axe=gca;

set(gcf, 'PaperPositionMode', 'auto');

set(axe,'FontName','arial')
set(axe,'fontsize',14)
set(gca,'TickDir','out');
set(gca,'Box','off');
set(gca,'TickLength',[0.02 0.025]);
%set(gca,'XTick',[1 2])
%set(gca,'XTickLabel',{'Long time';'short time'})
set(gcf,'position',[100, 200, 500, 400])


cols={};
for i=0:numbins

    
    max_mt=max(mtns);
    min_mt=min(mtns);
    
    cind=floor( ((mtns(i+1)-min_mt)/(max_mt-min_mt))*divs)+1;
    cind=cind;
    cind=min(cind,divs-1);
    col=c_mp(cind,:);

    cols{i+1}=col;
    xlim([0 400]);
    
    %bar(xs(i+1),ys(i+1),50,'facecolor',col);
    alexerrorbar(xs(i+1),ys(i+1),yes(i+1),col,5);
    plot(xs(i+1),ys(i+1),'ko','Color',col,'MarkerFaceColor',col);
    
    
    %shading flat;

end;
plot(xs,ys,'k--');


xs
ys

    

    
%for i=0:numbins
 %   set(h(i+1),'facecolor',cols{i+1});
 %   shading flat;
%end;



%plot(xs,ys2,'b');
%legend('spillover','phasic');
%errorbar(xs,ys,yes,'ro');

%errorbar(xs,ys2,yes2,'bo');

ylabel('Spillover current (pA)');
xlabel('Frequency (Hz) of phasic events');
%ylim([55 100]);
xlim([0 350]);
ylim([0 35]);

axe=gca;

colorbar;
set(gcf, 'PaperPositionMode', 'auto');

set(axe,'FontName','arial')
set(axe,'fontsize',14)
set(gca,'TickDir','out');
set(gca,'Box','off');
set(gca,'TickLength',[0.02 0.025]);
set(gca,'XTick',[0 50 100 150 200 250 300 350])
%set(gca,'XTickLabel',{'Long time';'short time'})
%set(gcf,'position',[100, 200, 500, 400])
print('-depsc','-r400','figs/spillvsfreq.eps')


