
close all; clear; pack;


errs=zeros(0,2);
shuffled_errs_mean=zeros(0,2);
shuffled_errs_sd=zeros(0,2);
errs_z_score=zeros(0,2);
cvs=zeros(0,2);
oss=zeros(0,2);

numshuffle=10;

shuffled_oss_mean=zeros(0,2);
shuffled_oss_sd=zeros(0,2);
oss_z_score=zeros(0,2);
syntherrs=[];


dopred=1;

for cellind=1:9
    
%pause;

    
switch cellind
    case 1
        load 'analyzed/EPSCs/110106cell6EPSCldat29.mat';
        load 'analyzed/EPSCs/110106cell6EPSCbins29.mat';
    case 2
        load 'analyzed/EPSCs/10910cell1EPSCldat16.mat'
        load 'analyzed/EPSCs/10910cell1EPSCbins16.mat'
    case 3
        load 'analyzed/EPSCs/110106cell1EPSCldat11.mat'
        load 'analyzed/EPSCs/110106cell1EPSCbins11.mat'

    case 4
        load 'analyzed/EPSCs/10519cell1EPSCldat03.mat'
        load 'analyzed/EPSCs/10519cell1EPSCbins03.mat'

    case 5
        load 'analyzed/EPSCs/110111cell1EPSCldat00.mat'
        load 'analyzed/EPSCs/110111cell1EPSCbins00.mat'
    case 6
        load 'analyzed/EPSCs/110112cell4EPSCldat41.mat'
        load 'analyzed/EPSCs/110112cell4EPSCbins41.mat'
    case 7
        load 'analyzed/EPSCs/090111cell1EPSCldat00.mat'
        load 'analyzed/EPSCs/090111cell1EPSCbins00.mat' 
    case 8
        load 'analyzed/EPSCs/110111cell2EPSCldat015.mat'
        load 'analyzed/EPSCs/110111cell2EPSCbins015.mat'
    case 9
        load 'analyzed/EPSCs/120111cell1EPSCldat02.mat'
        load 'analyzed/EPSCs/120111cell1EPSCbins02.mat'        
end

leftfore=ldat(:,1);
rightfore=ldat(:,2);


epsize=40;
eppre=15;


%shuffletrials as control?


%t=-100:100;
%ef=exp(-t.^2/1.5);
%ef=ef./sum(ef);
%bins=conv(bins,ef,'same');



for limbind=1:2

    
f1=figure;
bins_eps=[];
stance_eps=[];

dat=ldat(:,limbind);


currstate=dat(1);


length(dat)
length(bins)

%plot(bins)

%pause;

for i=2:min(length(bins),length(dat))
    
    nextstate=dat(i);
    if currstate~=nextstate;

    
        if nextstate==1 %starting swing
            
             starti=i-eppre;
            
            if ( starti>0 && (starti+epsize)<min(length(bins),length(dat))) 
                
                stance_eps=[stance_eps; dat(starti:(starti+epsize-1))'];
                bins_eps=[bins_eps; bins(starti:(starti+epsize-1))'];
            end
        end;
    end;
    
    currstate=nextstate;
    
end;




tinc=33.4;
%%%plot(tinc*((1:size(stance_eps,2))-1),mean(stance_eps),'b');




md=mean(bins_eps);
sd=std(bins_eps)./sqrt(size(bins_eps,1)-1);

size(md)
md1=md(10:30);




[cv]=circularvariance(md1);

cvs(cellind,limbind)=cv;

[os]=orientation_selectivity(md);

oss(cellind,limbind)=os;

oss
%size(md)

%pause;

figure(f1);
hold on;
fo=mean(md(1:eppre/2));
%%%plot(tinc*((1:size(stance_eps,2))-1),(md-fo)./fo,'r');

freqfac=1e3/tinc;
ts=tinc*((1:size(stance_eps,2))-1);
errorbar(ts,md,sd,'ro');
plot(ts,md,'r');


%save(strcat('filt/',num2str(cellind),'_',num2str(limbind)),'md','ts');
%continue;



%plot(30*((1:size(stance_eps,2))-1),m_dat-sm_dat,'k-.');
%plot(30*((1:size(stance_eps,2))-1),m_dat+sm_dat,'k-.');

%text(tinc*eppre,1.2,'string') 
text((eppre-1)*tinc,1.2,'Swing phase') 
line([(eppre-1) (eppre+5)]*tinc,[1.1 1.1],'LineWidth',3,'Color',[.2 .2 .2])

%%%legend('limb swing','events');
xlabel('time (ms)');

if limbind==1
    title('Left forelimb');
else
    title('Right forelimb');
end;
axe=gca;
set(axe,'FontName','arial')
set(axe,'fontsize',14)
set(gca,'TickDir','out');
set(gca,'Box','off');
set(gca,'TickLength',[0.02 0.025]);

%%%ylim([-0.9 1.3]);

ylim([0 250]);
set(gcf,'position',[450, 200, 400, 200]);

print('-depsc','-r400',strcat('analyzed/EPSCs/figs/stance_cell',num2str(cellind),'_limb',num2str(limbind),'.eps'));


if dopred==1


%entropy
a=bins(1:min(length(bins),length(dat)));
b=dat(1:min(length(bins),length(dat)));

len=1400;

epsmall=10;
chopA=[];
chopB=[];
for i=1:len
    curra=a(i:(i+epsmall-1));
    currb=b(i:(i+epsmall-1));
    
    chopA=[chopA;curra'];
    chopB=[chopB;currb'];
end;

errmat=[];
evmat=[];




for kkk=1:numshuffle
[err,syntherr,ev]=gethmmpredictionerror(ldat,bins,4,1,12);



errmat=[errmat;err];
evmat=[evmat;ev];
errmat
end;
errs(cellind,limbind)=mean(errmat(:,limbind));
evs{cellind,limbind}=evmat;
%%%%%%%syntherrs=[syntherr;syntherrs];



shuff_oss=zeros(numshuffle,1);
shuff_errs=zeros(numshuffle,1);
shuff_evs=[];
%%%%%%%% OSSS


size(stance_eps)



for ooo=1:numshuffle
    
    
    tmpbin=[];
    
    for uuu=1:size(stance_eps,1)
    ind=1+randi(length(bins)-epsize-1);
    tmpbin=[tmpbin; bins(ind:ind+epsize)'];
    
    md=mean(tmpbin);
    [os]=orientation_selectivity(md);

    
    end;
    shuff_oss(ooo)=os;
    
end;


for mmm=1:numshuffle
    shuff_bins=bins(randperm(length(bins)));
 
     lambda=sum(bins)./length(bins);
  
    [err,syntherr,ev]=gethmmpredictionerror(ldat,shuff_bins,4,1,12);
    
    shuff_errs(mmm)=err(:,limbind);
  
    shuff_evs=[shuff_evs;ev];
    
end;

shuffled_oss_mean(cellind,limbind)=mean(shuff_oss);
shuffled_oss_sd(cellind,limbind)=std(shuff_oss); 
oss_z_score(cellind,limbind)=(oss(cellind,limbind)-shuffled_oss_mean(cellind,limbind))./shuffled_oss_sd(cellind,limbind)

    
  shuffled_errs_mean(cellind,limbind)=mean(shuff_errs);
  shuffled_errs_sd(cellind,limbind)=std(shuff_errs);
  errs_z_score(cellind,limbind)=(errs(cellind,limbind)-shuffled_errs_mean(cellind,limbind))./shuffled_errs_sd(cellind,limbind)

  shuff_evs_tot{cellind,limbind}=shuff_evs; 
  
  shuffled_errs{cellind,limbind}=shuff_errs;
  shuffled_oss{cellind,limbind}=shuff_oss;
end;


save('EPSCerrs','errs','evs','errs_z_score','cvs','oss','oss_z_score','shuff_evs_tot','shuffled_errs','shuffled_oss');

end;
end;
