
close all; clear; pack;


errs=[];

syntherrs=[];
for cellind=1:2
    

    
switch cellind
    case 1
        load 'analyzed/EPSCs_IPSCs/ldat.mat';
        load 'analyzed/EPSCs_IPSCs/EPSCSbins1.mat';
    case 2
        load 'analyzed/EPSCs_IPSCs/ldat.mat'
        load 'analyzed/EPSCs_IPSCs/IPSCbins1.mat'

end

leftfore=ldat(:,1);
rightfore=ldat(:,2);


epsize=35;
eppre=10;


for limbind=1:2

    
figure;
bins_eps=[];
stance_eps=[];

dat=ldat(:,limbind);


currstate=dat(1);


length(dat)
length(bins)
%pause;

for i=2:min(length(bins),length(dat))
    
    nextstate=dat(i);
    if currstate~=nextstate;

    
        if nextstate==1 %starting swing
            
             starti=i-eppre;
            
            if ( starti>0 && (starti+epsize)<min(length(bins),length(dat)))
                
                
               
                
                stance_eps=[stance_eps; dat(starti:(starti+epsize-1))'];
                bins_eps=[bins_eps; bins(starti:(starti+epsize-1))'];
            end
        end;
    end;
    
    currstate=nextstate;
    
end;


tinc=33.4;
plot(tinc*((1:size(stance_eps,2))-1),mean(stance_eps),'b');
hold on;

md=mean(bins_eps);
fo=mean(md(1:eppre/2));
plot(tinc*((1:size(stance_eps,2))-1),(md-fo)./fo,'r');

%plot(30*((1:size(stance_eps,2))-1),m_dat-sm_dat,'k-.');
%plot(30*((1:size(stance_eps,2))-1),m_dat+sm_dat,'k-.');

%text(tinc*eppre,1.2,'string') 
text((eppre-1)*tinc,1.2,'Swing phase') 
line([(eppre-1) (eppre+5)]*tinc,[1.1 1.1],'LineWidth',3,'Color',[.2 .2 .2])

legend('limb swing','events');
xlabel('time (ms)');

if limbind==1
    title('Left forelimb');
else
    title('Right forelimb');
end;
axe=gca;
set(axe,'FontName','arial')
set(axe,'fontsize',14)
set(gca,'TickDir','out');
set(gca,'Box','off');
set(gca,'TickLength',[0.02 0.025]);
ylim([-0.9 1.3]);

print('-depsc','-r400',strcat('analyzed/EPSCs_IPSCs/figs/stance_cell',num2str(cellind),'_limb',num2str(limbind),'.eps'));
%pause;
close;


end;

bins


[err,syntherr]=gethmmpredictionerror(ldat,bins,4,2,20);
errs=[err;errs];
syntherrs=[syntherr;syntherrs];
end;

