
close all; clear; pack;



%%%%%build filter



tinc=33.4;


t=0:tinc:1000;
risetime=50;
decaytime=100;
a=1/risetime;
b=1/decaytime;
f=exp(-b*t)-exp(-a*t);
f=f./sum(f);
f=fliplr(f);

plot(t,fliplr(f));
width=400;
height=400;
set(gca,'FontName','arial')
set(gca,'fontsize',14)
ylabel('time');
set(gca,'TickDir','out');
set(gca,'Box','off');
set(gca,'TickLength',[0.02 0.025]);
xlabel('Time (ms)');
set(gcf,'position',[450, 200, width, height]);
set(gcf, 'PaperPositionMode', 'auto');
print('-dmeta','-r400',strcat('figs/lateralization/kernel.emf'));


for cellind=1:9
    
%pause;

    
switch cellind
    case 1
        
        load ../spillover/spill110106030
           
        load 'analyzed/EPSCs/110106cell6EPSCldat29.mat';
        load 'analyzed/EPSCs/110106cell6EPSCbins29.mat';
    case 2
        load ../spillover/spill10910007
        
        load 'analyzed/EPSCs/10910cell1EPSCldat16.mat'
        load 'analyzed/EPSCs/10910cell1EPSCbins16.mat'
    case 3
         load ../spillover/spill110106002
        
        load 'analyzed/EPSCs/110106cell1EPSCldat11.mat'
        load 'analyzed/EPSCs/110106cell1EPSCbins11.mat'

    case 4
        load '../spillover/spill10519000';
        
        load 'analyzed/EPSCs/10519cell1EPSCldat03.mat'
        load 'analyzed/EPSCs/10519cell1EPSCbins03.mat'

    case 5
        load ../spillover/spill110111000;
        
        load 'analyzed/EPSCs/110111cell1EPSCldat00.mat'
        load 'analyzed/EPSCs/110111cell1EPSCbins00.mat'
    case 6
        load ../spillover/spill110112040
        
        load 'analyzed/EPSCs/110112cell4EPSCldat41.mat'
        load 'analyzed/EPSCs/110112cell4EPSCbins41.mat'
    case 7
        load ../spillover/spill090111cell1EPSCs00.mat 
        
        load 'analyzed/EPSCs/090111cell1EPSCldat00.mat'
        load 'analyzed/EPSCs/090111cell1EPSCbins00.mat' 
    case 8
        load ../spillover/spill110111cell2EPSC015.mat
         
        load 'analyzed/EPSCs/110111cell2EPSCldat015.mat'
        load 'analyzed/EPSCs/110111cell2EPSCbins015.mat'
    case 9
        load '../spillover/spill120111cell1EPSC02.mat' 
        
        load 'analyzed/EPSCs/120111cell1EPSCldat02.mat'
        load 'analyzed/EPSCs/120111cell1EPSCbins02.mat'        
end

leftfore=ldat(:,1);
rightfore=ldat(:,2);


epsize=40;
eppre=15;


%shuffletrials as control?


%t=-100:100;
%ef=exp(-t.^2/1.5);
%ef=ef./sum(ef);
%bins=conv(bins,ef,'same');



for limbind=1:2

    
%f1=figure;
bins_eps=[];
filtbins_eps=[];
spillbins_eps=[];

stance_eps=[];

dat=ldat(:,limbind);


currstate=dat(1);


[spillbins,valbins]=convspill(spillmat);

filtsignal=conv(bins,f,'valid');



%filter signal

bins=bins(1:length(filtsignal));



figure;

plot((1:length(bins)) *tinc/1000, bins);
set(gca,'FontName','arial')
set(gca,'fontsize',14)
ylabel('time');
set(gca,'TickDir','out');
set(gca,'Box','off');
set(gca,'TickLength',[0.02 0.025]);
xlabel('Time (s)');
ylabel('EPSC rate');
xlim([0 length(bins)].*tinc/1000);
set(gcf,'position',[450, 200, width, height]);
set(gcf, 'PaperPositionMode', 'auto');
print('-dmeta','-r400',strcat('figs/lateralization/bins_',num2str(cellind),'_',num2str(limbind),'.emf'));


figure;

plot((1:length(bins)) *tinc/1000, filtsignal);
set(gca,'FontName','arial')
set(gca,'fontsize',14)
ylabel('time');
set(gca,'TickDir','out');
set(gca,'Box','off');
set(gca,'TickLength',[0.02 0.025]);
xlabel('Time (s)');
ylabel('Diltered signal');
xlim([0 length(bins)].*tinc/1000);
set(gcf,'position',[450, 200, width, height]);
set(gcf, 'PaperPositionMode', 'auto');
print('-dmeta','-r400',strcat('figs/lateralization/filtbins_',num2str(cellind),'_',num2str(limbind),'.emf'));




%plot(bins)
%hold on;
%plot(filtsignal,'r');


%xcorrelation


sumdat=filtxcorr(bins,filtsignal,'dude',tinc)


for i=2:min(length(bins),length(dat))
    
    nextstate=dat(i);
    if currstate~=nextstate;

    
        if nextstate==1 %starting swing
            
             starti=i-eppre;
            
            if ( starti>0 && (starti+epsize)<min(length(bins),length(dat))) 
                
                stance_eps=[stance_eps; dat(starti:(starti+epsize-1))'];
                bins_eps=[bins_eps; bins(starti:(starti+epsize-1))'];
                filtbins_eps=[filtbins_eps; filtsignal(starti:(starti+epsize-1))'];
            end
        end;
    end;
    
    currstate=nextstate;
    
end;





%%%plot(tinc*((1:size(stance_eps,2))-1),mean(stance_eps),'b');




md=mean(bins_eps);
sd=std(bins_eps)./sqrt(size(bins_eps,1)-1);


filt_md=mean(filtbins_eps);

size(md)
md1=md(10:30);




[cv]=circularvariance(md1);

[os]=orientation_selectivity(md);
[filt_os]=orientation_selectivity(filt_md);

os
filt_os


oss(cellind,limbind)=os;
filtoss(cellind,limbind)=filt_os;

sumdats{cellind,limbind}=sumdat;



end;
end;


close all;

%%%%%summary

width=350;
height=400;



%%%filtered versus real
figure;
hold on;
title('Modulation')
ylabel('Modulation index');


tot=[];
filttot=[];
for i=1:size(oss,1)
    for j=1:size(oss,2)
        plot(1,oss(i,j),'ro');
        plot(2,filtoss(i,j),'ro');
        plot([1 2],[oss(i,j) filtoss(i,j)],'r');
        
        tot=[tot; oss(i,j)];
        filttot=[filttot; filtoss(i,j)];
    end
end;

    plot(1,mean(tot),'kx');
    sm=std(tot)./sqrt(length(tot));
    plot([1 1],mean(tot)+[-sm sm],'k','linewidth',2);

    
    plot(2,mean(filttot),'kx');
    sm=std(filttot)./sqrt(length(filttot));
    plot([2 2],mean(filttot)+[-sm sm],'k','linewidth',2);

    
'MEAN'
mean(tot)
std(tot)./sqrt(length(tot))

'FILT MEAN'
mean(filttot)
std(filttot)./sqrt(length(filttot))

[H,P]=ttest2(tot,filttot)


pause;

axe=gca;
ylim([0 1]);
xlim([0.5 2.5]);
set(axe,'FontName','arial')
set(axe,'fontsize',14)
set(gca,'TickDir','out');
set(gca,'Box','off');
set(gca,'TickLength',[0.02 0.025]);
set(gca,'XTick',[1 2]);
set(gca,'XTickLabel',{'EPSCs','filtered data'});
set(gcf,'position',[450, 200, width, height]);
set(gcf, 'PaperPositionMode', 'auto');

print('-dmeta','-r400','figs/filt_vs_real_oss.emf');


%%%filtered xcorr


corr_mat=[];

lags=0;
for i=1:size(oss,1)
    for j=1:size(oss,2)
      corr_mat=[corr_mat;sumdats{i,j}.xc];  
      lags=sumdats{i,j}.lags./1000;
      
    end;
end;

figure;

hold on;

sm_dat=std(corr_mat)./sqrt(size(corr_mat,1));
m_dat=mean(corr_mat);

'DUDE'
m_dat

[maxval,maxind]=max(m_dat);
[minval,minind]=min(m_dat);


plot(tinc*lags,m_dat-sm_dat,'k-.');
plot(tinc*lags,m_dat+sm_dat,'k-.');
plot(tinc*lags,m_dat,'r','LineWidth',1.5);
plot([0 0],[ (min(m_dat)-0.05) (max(m_dat)+0.05)],'k--','LineWidth',1.5);
%h=errorbar(tinc*lags1,mean(corr_mat),std(corr_mat)./sqrt(size(corr_mat,1)-1),'bo','MarkerFaceColor',[1 1 1]);

%plot(tinc*lags1,bdu3,'b');
%plot(tinc*lags1,bdl3,'b');

%set(h,'MarkerFaceColor','red');

axe=gca;
set(axe,'FontName','arial')
set(axe,'fontsize',14)
set(gca,'TickDir','out');
set(gca,'Box','off');
set(gca,'TickLength',[0.02 0.025]);
title('Crosscorrelation of EPSCs versus filtered')
%ylim([-0.2 0.3]);
%ylim([-0.3 1.1]);

xlabel('time (seconds)');
ylabel('crosscorrelation coefficient');
print('-dmeta','-r400',strcat('figs/filtxcorr.emf'));

%figure;
%plot(m_spikes,m_mtn,'ro');
