
close all; clear; pack;


errs=zeros(0,2);
shuffled_errs_mean=zeros(0,2);
shuffled_errs_sd=zeros(0,2);
errs_z_score=zeros(0,2);
cvs=zeros(0,2);
oss=zeros(0,2);

numshuffle=10;

shuffled_oss_mean=zeros(0,2);
shuffled_oss_sd=zeros(0,2);
oss_z_score=zeros(0,2);
syntherrs=[];
evs={};



for cellind=1:7

    
% pause;

    
switch cellind
    case 1
        load 'analyzed/GC_spikes/06_01_2011_Cell6ldat0014.mat';
        load 'analyzed/GC_spikes/06_01_2011_Cell6bins0014.mat';
    case 2
        load 'analyzed/GC_spikes/10520cell2ldat10520_009-015.mat';
        load 'analyzed/GC_spikes/10520cell2bins10520_009-015.mat';
    case 3
        load 'analyzed/GC_spikes/110111cell2ldatCIMG0005.mat';
        load 'analyzed/GC_spikes/110111cell2binsCIMG0005.mat';

    case 4
        load 'analyzed/GC_spikes/110106cell3ldatCIMG0006.mat';
        load 'analyzed/GC_spikes/110106cell3binsCIMG0006.mat';

    case 5
        load 'analyzed/GC_spikes/100112cell4ldat29CIMG0008';
        load 'analyzed/GC_spikes/10112cell4binsCIMG0008.mat';
    case 6
        load 'analyzed/GC_spikes/060111cell4ldat018.mat';
        load 'analyzed/GC_spikes/060111cell4bins018.mat';    
    case 7
        load 'analyzed/GC_spikes/060111cell5ldat025.mat';
        load 'analyzed/GC_spikes/060111cell5bins025.mat';    
end

leftfore=ldat(:,1);
rightfore=ldat(:,2);



epsize=40;
eppre=15;

ds=2;
t=-50:50;
ef=(1/sqrt(2*pi*ds.^2))*exp(-t.^2./(2*ds.^2));
ef=ef./sum(ef);

bins=conv(bins,ef,'same');


for limbind=1:2

    
f1=figure;
bins_eps=[];
stance_eps=[];

dat=ldat(:,limbind);


currstate=dat(1);


length(dat)
length(bins)
%pause;

for i=2:min(length(bins),length(dat))
    
    nextstate=dat(i);
    if currstate~=nextstate;

    
        if nextstate==1 %starting swing
            
             starti=i-eppre;
            
            if ( starti>0 && (starti+epsize)<min(length(bins),length(dat)))
                
                
               
                
                stance_eps=[stance_eps; dat(starti:(starti+epsize-1))'];
                bins_eps=[bins_eps; bins(starti:(starti+epsize-1))'];
            end
        end;
    end;
    
    currstate=nextstate;
    
end;


tinc=33.4;
%plot(tinc*((1:size(stance_eps,2))-1),mean(stance_eps),'b');

figure(f1)
hold on;

md=mean(bins_eps);
sd=std(bins_eps)./sqrt(size(bins_eps,1)-1);
ts=tinc*((1:size(stance_eps,2))-1);
errorbar(ts,md,sd,'ro');
fo=mean(md(1:eppre/2));

plot(tinc*((1:size(stance_eps,2))-1),md,'r');

md=mean(bins_eps);


%save(strcat('filt/GCSpikes_',num2str(cellind),'_',num2str(limbind)),'md','ts');
%continue;



size(md)
md1=md(10:30);

[cv]=circularvariance(md1);

cvs(cellind,limbind)=cv;


[os]=orientation_selectivity(md);
oss(cellind,limbind)=os;

'UUUUUUUUU'
oss

%figure

%plot(tinc*((1:size(stance_eps,2))-1),md,'r');

%plot(30*((1:size(stance_eps,2))-1),m_dat-sm_dat,'k-.');
%plot(30*((1:size(stance_eps,2))-1),m_dat+sm_dat,'k-.');

%text(tinc*eppre,1.2,'string') 
text((eppre-1)*tinc,1.2,'Swing phase') 
line([(eppre-1) (eppre+5)]*tinc,[1.1 1.1],'LineWidth',3,'Color',[.2 .2 .2])

%legend('limb swing','events');
xlabel('time (ms)');

if limbind==1
    title('Left forelimb');
else
    title('Right forelimb');
end;
axe=gca;
set(axe,'FontName','arial')
set(axe,'fontsize',14)
set(gca,'TickDir','out');
set(gca,'Box','off');
set(gca,'TickLength',[0.02 0.025]);
%ylim([-1.5 3.5]);

ylim([0 50]);
set(gcf,'position',[450, 200, 400, 200]);


print('-depsc','-r400',strcat('analyzed/GC_spikes/figs/stance_cell',num2str(cellind),'_limb',num2str(limbind),'.eps'));

%pause;
%close;
errmat=[];
evmat=[];

kkk=1;

while kkk<=numshuffle
  
[err,syntherr,ev]=gethmmpredictionerror(ldat,bins,4,2,12);
errmat=[errmat;err];
if (size(ev,2)==2)
  evmat=[evmat;ev];
  errmat
  kkk=kkk+1;
end;


end;
errs(cellind,limbind)=mean(errmat(:,limbind));
evs{cellind,limbind}=evmat;
%syntherrs=[syntherr;syntherrs];



shuff_oss=zeros(numshuffle,1);
shuff_errs=zeros(numshuffle,1);
shuff_evs=[];

for ooo=1:numshuffle
    
    
    tmpbin=[];
    
    for uuu=1:size(stance_eps,1)
    ind=1+randi(length(bins)-epsize-1);
    tmpbin=[tmpbin; bins(ind:ind+epsize)'];
    
    md=mean(tmpbin);
    [os]=orientation_selectivity(md);

    
    end;
    shuff_oss(ooo)=os;
    
end;


for mmm=1:numshuffle
    shuff_bins=bins(randperm(length(bins)));
 
     lambda=sum(bins)./length(bins);
    
    
    
    [err,syntherr,ev]=gethmmpredictionerror(ldat,shuff_bins,4,2,12);
    
    shuff_errs(mmm)=err(:,limbind);
    shuff_evs=[shuff_evs;ev];
    
end;

    shuffled_oss_mean(cellind,limbind)=mean(shuff_oss);
    shuffled_oss_sd(cellind,limbind)=std(shuff_oss); 
    
    oss_z_score(cellind,limbind)=(oss(cellind,limbind)-shuffled_oss_mean(cellind,limbind))./shuffled_oss_sd(cellind,limbind)

    
    
    shuffled_errs_mean(cellind,limbind)=mean(shuff_errs);
    shuffled_errs_sd(cellind,limbind)=std(shuff_errs);
    errs_z_score(cellind,limbind)=(errs(cellind,limbind)-shuffled_errs_mean(cellind,limbind))./shuffled_errs_sd(cellind,limbind)

   shuff_evs_tot{cellind,limbind}=shuff_evs; 
    
end;


save('spikeserrs','errs','evs','errs_z_score','cvs','oss','oss_z_score','shuff_evs_tot');

end;


