close all;

clear;
load('../stance_analysis/filt/EPSCs_1_1.mat')



%%%%%build filter
origtinc=floor(ts(2)-ts(1));
tinc=1;

md=resample(md,origtinc,tinc);



t=0:tinc:1000;
risetime=50;
decaytime=500;
a=1/risetime;
b=1/decaytime;
f=exp(-b*t)-exp(-a*t);
f=f./sum(f);
f=fliplr(f);

plot(t,f);

pause;

%%%%%%%%%%%%%%%%%%%%%%%%%
%build signal
numsteps=50;


%lastval=md(length(md));
%pad=100;
%md=[md repmat(lastval,1,pad)+std(md)*rand(1,pad)];

artisignal=repmat(md,1,numsteps);
artisignal=artisignal+rand(1,length(artisignal))*std(artisignal);

%artisignal=rand(1,10000);

%filter it;
filtsignal=conv(artisignal,f,'valid');


plot(artisignal,'b');
hold on;
plot(filtsignal,'r');



%xcorr
figure;
filtsignal=filtsignal-mean(filtsignal);
artisignal=artisignal-mean(artisignal);
artisignal=artisignal(1:length(filtsignal));
[xc,lags]=xcorr(filtsignal,artisignal,'coeff');
plot(lags*tinc,xc);
xlim([-2000 2000]);