function [bins,valbins]=convspill(spillanal)


valid=1-spillanal(2,:);
spillover=spillanal(1,:);



%get rid of test pulse artefact
dval=diff(valid);

d_inds=find(dval==1);
if ~isempty(d_inds)
    e_inds=find(dval==-1);
    arte_width=(e_inds(1)-d_inds(1))+40;

    for i=1:length(d_inds)
        currx=d_inds(i)-20;
        curry=spillover(currx);
        endy=curry;
        if (currx+arte_width)<=length(spillover)
            endy=spillover(currx+arte_width);
        end
        plot(currx,curry,'ro');
        plot(currx+arte_width,endy,'rx');
        
        for j=currx:(min(currx+arte_width,length(spillover)))
            spillover(j)=(j-currx)*((endy-curry)/arte_width)+curry;
        end
    end;

end;

ind=find(1-valid);


%figure;
%plot(spillover(ind));
%pause;

binsize=0.0334;
numseconds=50;

bins=zeros(ceil(numseconds/binsize),1);
valbins=zeros(ceil(numseconds/binsize),1);


freqac=20e3;


for i=1:length(valbins)
    
    currind=(floor((i-1)*(binsize*freqac)):floor((i+1)*(binsize*freqac)))+1;
    
    currind=min(currind,length(valid));
    val=min(valid(currind));
    spill=mean(spillover(currind));
    
    valbins(i)=val;
    bins(i)=spill;
end;


