function []=findvidcorrelations(options,bins,fname)
%load stance_CIMG0004
%load bins11

vidmat=options.videomatrix;


numFrames=min(size(vidmat,4),length(bins));
%numFrames=100;



 state.currstate.k=1;
 state.tot=zeros(numFrames,1);
 state.motionmaps=zeros(size(vidmat,1),size(vidmat,2),numFrames);     
 se=strel('square',2);
        
alph=0.3;
bet=0.9;
            
 tot=[];
              
           
       for k = 1 : numFrames 
           
           k
  
           
               state.currstate.k=k;
               state.currstate.frame= vidmat(:,:,:,k);
               [mtnidx,currstate,map]=getmotionidx(state.currstate,alph,bet,40,se);
               state.currstate=currstate;
               state.tot(k,1)=mtnidx;           
               state.motionmaps(:,:,k)=map;  

       end
       
       
    curr_spikes=bins(1:min(numFrames,length(bins)));
       
   
    maxcorrs=zeros(size(vidmat,1),size(vidmat,2));
    corrts=zeros(size(vidmat,1),size(vidmat,2));
    epsize=500;
    
    wght=epsize/numFrames;
    
    for p=1:floor(numFrames/epsize)
        inds=(p-1).*epsize+(1:epsize);
     for k=1:size(vidmat,1)
         for m=1:size(vidmat,2)
             
             curr_mIdx=state.motionmaps(k,m,inds);
             curr_spikes=bins(inds);
             [xc1,lags1] = xcorr(curr_spikes-mean(curr_spikes),curr_mIdx-mean(curr_mIdx),50,'coeff');
             
             [mx,mxi]=max(abs(xc1));
             
             %maxcorrs(k,m)=max(maxcorrs(k,m),mx);
            maxcorrs(k,m)=maxcorrs(k,m)+wght*mx;
             
             corrts(k,m)=(lags1(mxi));
             
         end;
     end;
    end;
       
     imagesc(maxcorrs); 
     colorbar;
     
     print('-depsc','-r400',strcat('figs/mean_',fname,'.eps'));

     
    %   for i=1: numframes
    %       im=state.motionmaps(:,:,i);
    %       imagesc(im);
    %       
    %       pause(0.1);
    %   end;
    
    
       
       
       
end       
       
       
function [mtnidx,newstate,map]=getmotionidx(currstate, alph, bet, thresh,se)
 
           
         
           if currstate.k==1
             currstate.BG=currstate.frame;
           end;
           diffim=distfunct(currstate.frame,currstate.BG);
           
           if currstate.k==1
             newstate.smoothed_diffim=diffim;
           else  
             newstate.smoothed_diffim=(1-bet).*currstate.smoothed_diffim+bet.*diffim;
           end;
           
           
           map=newstate.smoothed_diffim;
           %image(BG);
           %image(frame);
           
          % size(diffim)
           %figure(fig1)
           %image(currstate.frame)          
           
           %%%set(fig1, 'CData', currstate.frame);
           
           binim=(newstate.smoothed_diffim>thresh);
           binim=imerode(binim,se);
           %figure(fig2)
           %imagesc(binim,[0 1]);
          
           %%%set(fig2, 'CData', binim);
           
           %drawnow
           
           mtnidx=sum(sum(binim));
           
           newstate.BG=(1-alph).*currstate.BG+alph.*currstate.frame;
           

           
end
function [C]=distfunct(A,B)
%C=abs(A(:,:,1)-B(:,:,1))+abs(A(:,:,2)-B(:,:,2))+abs(A(:,:,3)-B(:,:,3));
C=sum(abs(A-B),3);
end

