function [d,t,syntherr]=getSchreiberDistance(hmm_train,actual_train,hmm_model)

trainY=actual_train;
path=hmm_train;

bintrain=double(diff(trainY)>0.4);
binpath=double(diff(path)>0.4);
binpathflip=double(-diff(path)>0.4);
T=length(binpath)+1;
[obs,hidden]=mhmm_sample(T,1, hmm_model.prior, hmm_model.transmat, hmm_model.mu, hmm_model.Sigma, hmm_model.mixmat);

hidden=double(diff(hidden-1)>0.4);

%%%
%d=jolivetdist(bintrain,binpath,10);
%'JOLIVET'
%d
%syntherr=d;
%t=0;
%pause;

f=figure;
%plot(bintrain,'r');
%hold;
%plot(binpath,'b');
%pause;
close(f)

%Schreiber distance
%figure;
ds=3;
maxlag=5;
t=-50:50;

ef=(1/sqrt(2*pi*ds.^2))*exp(-t.^2./(2*ds.^2));


pathf=conv(binpath,ef);
pathf_flip=conv(binpath,ef);
trainf=conv(bintrain,ef);
samplef=conv(hidden',ef);

%pathf=pathf;
%trainf=trainf;

[xc1,lags]=xcorr(pathf,trainf,maxlag,'coeff');
[m1,i1]=max(xc1);


[xc2,lags]=xcorr(pathf_flip,trainf,maxlag,'coeff');
[m2,i2]=max(xc2);

if (m1>m2)
    m=m1;
    xc=xc1;
    i=i1;
else
    m=m2;
    xc=xc2;
    i=i2;
end

%Schreiber S, Fellous JM, Whitmer JH, Tiesinga PHE, Sejnowski TJ (2003). A
%new correlation based measure of spike timing reliability. Neurocomputing %52:925?931.

d=m;
t=lags(i);


size(samplef)
size(trainf)


d
[xc,lags]=xcorr(samplef,trainf,maxlag,'coeff');
'dude2'
[m,i]=max(xc);

syntherr=m;
i

d/m
