%A benchmark test for a quantitative assessment
%of simple neuron models
%Renaud Jolivet

function [d]=jolivetdist(A,B,window)


AI=find(A);
NA=length(A)
Nkdat=sum(A)
NB=length(B)
NkB=sum(B)
fA=sum(A)./NA
fB=sum(B)./NB
Bold=B;

nmatch=0;
matches=[];
for i=1:length(AI)
    currind=AI(i);
    
    if (currind-window>1)
        win=currind-window:currind;
        
        matched=0;
        for k=win
            if B(k)==1;
                matched=1;
                B(k)=0;
                break;
            end;
                
        end;
        
        if matched==1
            nmatch=nmatch+1;
            matches=[matches currind];
            continue;
        end;
    end;
    
    
    if (currind+window<length(A))
        win=currind:(currind+window);
        
        matched=0;
        for k=win
            if B(k)==1;
                matched=1;
                B(k)=0;
                break;
            end;
                
        end;
        
        if matched==1
            nmatch=nmatch+1;
            matches=[matches currind];
            continue;
        end;
    end;
    
    
    
end;
nmatch

Npoiss=2*fB*window*Nkdat;
Nnorm=1-2*fB*window;

d=(nmatch-Npoiss)/(0.5*Nnorm*(Nkdat+NkB));

%figure;
%hold on;
%plot(A);
%plot(0.5*Bold,'k');
%plot(matches,1.5,'ro');