close all;
clear

'examine lateralization'

'EPSCs'
s = RandStream('mcg16807','Seed',0)
RandStream.setGlobalStream(s)

oss1=[];
oss2=[];

phimaxs1=[];
phimaxs2=[];

angles1=[];
angles2=[];

deltas1=[];
deltas2=[];

eppre=15;
swingsize=5;


labels=[];


for modality=1:4
    
switch modality
   case 2
        prefix='EPSCs_'
        numcells=9
   case 3
        prefix='GCSpikes_'
        numcells=7
    case 1
        prefix='MFTs'
        numcells=4
    
    case 4
        prefix='Spill_'
        numcells=9
        
end

for k=1:numcells
load(strcat('filt/',prefix,num2str(k),'_1'))
limb1=md;
load(strcat('filt/',prefix,num2str(k),'_2'))
limb2=md;


%orientation selectivity
os1=orientation_selectivity(limb1);
os2=orientation_selectivity(limb2);

oss1=[oss1;os1];
oss2=[oss2;os2];


limb1orig=limb1;
limb2orig=limb2;

limb1=abs(limb1-mean(limb1));
limb2=abs(limb2-mean(limb2));


limb1=limb1-min(limb1);
limb1=limb1./max(limb1);
limb2=limb2-min(limb2);
limb2=limb2./max(limb2);




N=length(limb1);



N=(length(limb1))
phi=( (0:N-1));
%wrap around
phi=[phi 0]
phi=phi-eppre; %offset from swing 
phi=phi*2*pi/(N);

limb1=[limb1 limb1(1)];
limb2=[limb2 limb2(1)];
%[m,ind]=max( abs((limb1-mean(limb1))));

[m,ind1]=max(limb1);
phimax1=phi(ind1);
[m,ind2]=max(limb2);
phimax2=phi(ind2);

%DELTA
delta1=(limb1orig(ind1)-mean(limb1orig))./std(limb1orig);
delta2=(limb2orig(ind2)-mean(limb2orig))./std(limb2orig);
figure
hold on;
ind1
ind2
plot((limb1orig-mean(limb1orig))./mean(limb1orig),'b');
plot((limb2orig-mean(limb2orig))./mean(limb2orig),'r');


deltas1=[deltas1; delta1];
deltas2=[deltas2; delta2];


phimaxs1=[phimaxs1; phimax1];
phimaxs2=[phimaxs2; phimax2];

angles1=[angles1; phimax1];
angles2=[angles2; phimax2];

labels=[labels;modality];



figure;
%hold on;
polar(phi,limb1,'b');
hold on;
polar( [phimax1 phimax1],[0 1],'b--');

phiswing=swingsize*2*pi/(N);
polar( [phiswing phiswing],[0 1],'g--');
%pause;    
hold on;
polar(phi,limb2,'r');
polar( [phimax2 phimax2],[0 1],'r--');


prefix
k

print('-dmeta','-r400',strcat('figs/lateralization/polar_',prefix,'_',num2str(k),'.emf'));
%pause;
close all;

end;
end;




%%%%%ANGLE DIFF
figure;



cols=['g','r','b','m'];

figure;
hold on;


for k=1:3
    inds=find(labels==k);
    size(inds)
    As=(angles1(inds)-angles2(inds))*(360/(2*pi));
 
    As=As+2*rand(length(As),1); %jitter points to avoid absolute overlap
   
    As=mod(As,180)
%    angles1(inds)
%    pause;
    plot(k,As,strcat(cols(k),'o'));
    plot(k+0.*As,As,strcat(cols(k),'o'));
    plot(k,mean(As),strcat(cols(k),'x'));
    sm=std(As)./sqrt(length(As));
    plot([k k],mean(As)+[-sm sm],cols(k));
    
    'AS'
    k
    mean(As)
    sm
    pause;
end;

width=400;
height=400;
xlim([0.5 3.5]);
axe=gca;


set(axe,'FontName','arial')
set(axe,'fontsize',14)
set(gca,'TickDir','out');
set(gca,'Box','off');
set(gca,'TickLength',[0.02 0.025]);
set(gca,'XTick',[1 2 3]);
set(gca,'XTickLabel',{'MFTs','EPSCs','Spikes'});
title('Phase difference between two limbs');
ylabel('Phase difference (degrees)')
set(gcf,'position',[450, 200, width, height]);
set(gcf, 'PaperPositionMode', 'auto');
print('-dmeta','-r400',strcat('figs/lateralization/angle_delta.emf'));

%%%%%%% OSS


figure;
hold on;


for k=1:3
    inds=find(labels==k);
    plot(oss1(inds),oss2(inds),strcat(cols(k),'o'));
end;


indstot=find( (labels==1) | (labels==2) | (labels==3));
indstot
pause;
oss1tot=oss1(indstot);
oss2tot=oss2(indstot);
[R,P]=corrcoef(oss1tot,oss2tot)
P(1,2)
pause;
PO = polyfit(oss1tot,oss2tot,1);
  
 x=min(oss1tot):0.1:max(oss1tot);

 
 plot(x,polyval(PO,x),'k');

width=400;
height=400;

axe=gca;


set(axe,'FontName','arial')
set(axe,'fontsize',14)
set(gca,'TickDir','out');
set(gca,'Box','off');
set(gca,'TickLength',[0.02 0.025]);

xlabel('left limb modulation index');
ylabel('right limb modulation index');
set(gcf,'position',[450, 200, width, height]);
set(gcf, 'PaperPositionMode', 'auto');
print('-dmeta','-r400',strcat('figs/lateralization/oss_vs_oss.emf'));



%%%%%%%%%%%%%%%%%%%%%%LEFT LIMB%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


cols=['g','r','b','m'];

figure;
hold on;


for k=1:4
    inds=find(labels==k);
    size(inds);
    As=(angles1(inds))*(360/(2*pi));
 
    As=mod(As,360); 
    %+2*rand(length(As),1); %jitter points to avoid absolute overlap
   
%    angles1(inds)
%    pause;
    plot(k+0.*As,As,strcat(cols(k),'o'));
    plot(k,mean(As),strcat(cols(k),'x'));
    sm=std(As)./sqrt(length(As));
    plot([k k],mean(As)+[-sm sm],cols(k));
    
    'MAX'
    min(As)
    max(As)
end;

mean(As)
std(As)

width=400;
height=400;
xlim([0.5 3.5]);
axe=gca;


set(axe,'FontName','arial')
set(axe,'fontsize',14)
set(gca,'TickDir','out');
set(gca,'Box','off');
set(gca,'TickLength',[0.02 0.025]);
set(gca,'XTick',[1 2 3]);
set(gca,'YTick',0:90:360);
set(gca,'XTickLabel',{'MFTs','EPSCs','Spikes'});
title('Phase of left limb');
ylabel('Phase (degrees)')
set(gcf,'position',[450, 200, width, height]);
set(gcf, 'PaperPositionMode', 'auto');
print('-dmeta','-r400',strcat('figs/lateralization/leftlimb.emf'));


%%%%%%%%%%%%%%%%%%%%%%RIGHT LIMB%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


cols=['g','r','b','m'];

figure;
hold on;


for k=1:3
    inds=find(labels==k);
    size(inds)'
    As=(angles2(inds))*(360/(2*pi));
 
    As=mod(As,360); 
    %+2*rand(length(As),1); %jitter points to avoid absolute overlap
   
%    angles1(inds)
%    pause;
    plot(k,As,strcat(cols(k),'o'));
    plot(k+0.*As,As,strcat(cols(k),'o'));
    plot(k,mean(As),strcat(cols(k),'x'));
    sm=std(As)./sqrt(length(As));
    plot([k k],mean(As)+[-sm sm],cols(k));

    'MIN'
    min(As)
    max(As)
end;

mean(As)
std(As)

width=400;
height=400;
xlim([0.5 3.5]);
axe=gca;


set(axe,'FontName','arial')
set(axe,'fontsize',14)
set(gca,'TickDir','out');
set(gca,'Box','off');
set(gca,'TickLength',[0.02 0.025]);
set(gca,'XTick',[1 2 3]);
set(gca,'YTick',0:90:360);
set(gca,'XTickLabel',{'MFTs','EPSCs','Spikes'});
title('Phase of right limb');
ylabel('Phase (degrees)')
set(gcf,'position',[450, 200, width, height]);
set(gcf, 'PaperPositionMode', 'auto');
print('-dmeta','-r400',strcat('figs/lateralization/rightlimb.emf'));

%%%%%%%%%%%%%%%%%%%%%%DELTA%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
figure;
hold on;
width=400;
height=400;
for k=1:3
    inds=find(labels==k);
    size(inds)

    plot(deltas1(inds),deltas2(inds),strcat(cols(k),'o'));
    
end;
plot([0,0],[-3,3],'k--');
plot([-4,3],[0,0],'k--');
xlim([-3.5 3]);

set(axe,'FontName','arial')
set(axe,'fontsize',14)
set(gca,'TickDir','out');
set(gca,'Box','off');
set(gca,'TickLength',[0.02 0.025]);
xlabel('Left limb modulation (Z score)');
ylabel('Right limb modulation (Z score)');
set(gcf,'position',[450, 200, width, height]);
set(gcf, 'PaperPositionMode', 'auto');
print('-dmeta','-r400',strcat('figs/lateralization/delta.emf'));


