
close all; clear; pack;

tinc=33.4;


onset_bins=[];
offset_bins=[];

for cellind=1:9
    
%pause;

    
switch cellind
    case 1
        load 'analyzed/EPSCs/110106cell6EPSCldat29.mat';
        load 'analyzed/EPSCs/110106cell6EPSCbins29.mat';
    case 2
        load 'analyzed/EPSCs/10910cell1EPSCldat16.mat'
        load 'analyzed/EPSCs/10910cell1EPSCbins16.mat'
    case 3
        load 'analyzed/EPSCs/110106cell1EPSCldat11.mat'
        load 'analyzed/EPSCs/110106cell1EPSCbins11.mat'

    case 4
        load 'analyzed/EPSCs/10519cell1EPSCldat03.mat'
        load 'analyzed/EPSCs/10519cell1EPSCbins03.mat'

    case 5
        load 'analyzed/EPSCs/110111cell1EPSCldat00.mat'
        load 'analyzed/EPSCs/110111cell1EPSCbins00.mat'
    case 6
        load 'analyzed/EPSCs/110112cell4EPSCldat41.mat'
        load 'analyzed/EPSCs/110112cell4EPSCbins41.mat'
    case 7
        load 'analyzed/EPSCs/090111cell1EPSCldat00.mat'
        load 'analyzed/EPSCs/090111cell1EPSCbins00.mat' 
    case 8
        load 'analyzed/EPSCs/110111cell2EPSCldat015.mat'
        load 'analyzed/EPSCs/110111cell2EPSCbins015.mat'
    case 9
        load 'analyzed/EPSCs/120111cell1EPSCldat02.mat'
        load 'analyzed/EPSCs/120111cell1EPSCbins02.mat'        
end

leftfore=ldat(:,1);
rightfore=ldat(:,2);


epsize=40;
eppre=15;

deadinterval=2000;

%shuffletrials as control?


%t=-100:100;
%ef=exp(-t.^2/1.5);
%ef=ef./sum(ef);
%bins=conv(bins,ef,'same');


%get movement onset
dat1=ldat(:,1);
dat2=ldat(:,2);
dat3=(dat1+dat2)>0;
dat4=diff(dat3)>0;

dat5=diff(dat3)<0;
transind=find(dat4);
transind=[0; transind];
transind2=find(dat5);
transind2=[transind2; length(dat1)];
dts_on=diff(transind);
dts_off=diff(transind2);


tt=find(dts_on>(deadinterval/tinc));
tt2=find(dts_off>(deadinterval/tinc));
tt_up=transind(tt+1);
tt_down=transind2(tt2)+1;
figure
hold on;
plot(dat3,'g');
plot(tt_up,0.*tt_up,'ro');
plot(tt_down,0.*tt_down,'bo');


figure;
for kk=1:length(tt_up)
    t_curr=tt_up(kk);
    
    onsetprepad=40;
    prepad=onsetprepad;
    onsetpostpad=15;
    
    currbin=bins((t_curr-prepad):(t_curr+onsetpostpad));
    currbin=currbin;
    
    plot(currbin);
    
    onset_bins=[onset_bins; currbin'];
end;


for kk=1:length(tt_down)
    t_curr=tt_down(kk);
    t_curr
    
    if t_curr<prepad
        'dud'
        continue;
    end;
    offsetprepad=15;
    prepad=offsetprepad
    offsetpostpad=60;
    
    currbin=bins((t_curr-prepad):(t_curr+offsetpostpad));
    
    %%%%normalize
    currbin=currbin;
    
    plot(currbin);
    
    offset_bins=[offset_bins; currbin'];
end;

end


figure;
hold on;
m=mean(onset_bins,1);
sd=std(onset_bins,1)./sqrt(size(onset_bins,1));


binsbefore=33;
binsafter=33;
comparebins=15
pre=mean(onset_bins(:,(1:comparebins)+(onsetprepad-binsbefore)),2);
post=(mean(onset_bins(:,onsetprepad+1:onsetprepad+comparebins),2));
'onset'
size(pre)
size(post)
'mean'
mean(pre)
'std'
std(pre)./sqrt(length(pre))
mean(post)
std(post)./sqrt(length(post))

[H,P]=ttest2(pre,post);

P

pause;


pre=mean(offset_bins(:,1:comparebins),2);
post=(mean(offset_bins(:,(offsetprepad+comparebins):(offsetprepad+comparebins+binsafter)),2));
'offset'
size(pre)
size(post)
'mean'
mean(pre)
'std'
std(pre)./sqrt(length(pre))
mean(post)
std(post)./sqrt(length(post))

[H,P]=ttest2(pre,post);

P

pause;



'on'
size(onset_bins)
'off'
size(offset_bins)

trng=( (1:length(m)) - onsetprepad-1)*tinc;
errorbar( trng, m,sd);
plot([0 0],[min(m)-mean(sd) max(m)+mean(sd)],'k--');
axe=gca;

set(gcf, 'PaperPositionMode', 'auto');

set(axe,'FontName','arial')
set(axe,'fontsize',14)
ylabel('EPSC rate');
xlabel('time(ms)');
set(gca,'TickDir','out');
set(gca,'Box','off');
set(gca,'TickLength',[0.02 0.025]);
set(gca,'XTick',[-1000 -500 0 500])
set(gcf,'position',[100, 200, 500, 400])
%set(gca,'XTickLabel',{'Long time';'short time'})

xlim([min(trng) max(trng)])
print('-dmeta','-r400','figs/movementonset.emf')




figure;
hold on;
axe=gca;
m=mean(offset_bins,1);
sd=std(offset_bins,1)./sqrt(size(offset_bins,1));
trng=( (1:length(m)) - offsetprepad-1)*tinc;
errorbar(trng,m,sd,'r');
plot([0 0],[min(m)-mean(sd) max(m)+mean(sd)],'k--');

set(gcf, 'PaperPositionMode', 'auto');

set(axe,'FontName','arial')
set(axe,'fontsize',14)
ylabel('EPSC rate');
xlabel('time(ms)');
set(gca,'TickDir','out');
set(gca,'Box','off');
set(gca,'TickLength',[0.02 0.025]);
set(gca,'XTick',[0 500 1000])
%set(gca,'XTickLabel',{'Long time';'short time'})
set(gcf,'position',[100, 200, 500, 400])

xlim([min(trng) max(trng)])
print('-dmeta','-r400','figs/movementoffset.emf')

