function plotallsteps()
f=figure;

for cellind=1:20
switch cellind
     case 1
        load 'analyzed/EPSCs/110106cell6EPSCldat29.mat';
        
    case 2
        load 'analyzed/EPSCs/10910cell1EPSCldat16.mat';

    case 3
        load 'analyzed/EPSCs/110106cell1EPSCldat11.mat';

    case 4
        load 'analyzed/EPSCs/10519cell1EPSCldat03.mat';

    case 5
        load 'analyzed/EPSCs/110111cell1EPSCldat00.mat';
    case 6
        load 'analyzed/EPSCs/110112cell4EPSCldat41.mat';
      
    case 7
        load 'analyzed/EPSCs/090111cell1EPSCldat00.mat';
         
    case 8
        load 'analyzed/EPSCs/110111cell2EPSCldat015.mat';
       
    case 9
        load 'analyzed/EPSCs/120111cell1EPSCldat02.mat';
    case 10
        load 'analyzed/GC_spikes/06_01_2011_Cell6ldat0014.mat';

    case 11
        load 'analyzed/GC_spikes/10520cell2ldat10520_009-015.mat';
       
    case 12
        load 'analyzed/GC_spikes/110111cell2ldatCIMG0005.mat';
     

    case 13
        load 'analyzed/GC_spikes/110106cell3ldatCIMG0006.mat';
        

    case 14
        load 'analyzed/GC_spikes/100112cell4ldat29CIMG0008';
        
    case 15
        load 'analyzed/GC_spikes/060111cell4ldat018.mat';
        
    case 16
        load 'analyzed/GC_spikes/060111cell5ldat025.mat';
   case 17
        load 'analyzed/MFTs/10519MFTldat14.mat';
      
    case 18
        load 'analyzed/MFTs/110106MFTldat51.mat';
       
    case 19
        load 'analyzed/MFTs/10515MFTldat10515-25.mat';

    case 20
        load 'analyzed/MFTs/110111MFTldat1101-25.mat';
            
end

ldat=ldat';
plotonestep(cellind,ldat,f)
end

axe=gca;
xlabel('time (s)');
set(axe,'FontName','arial')
set(axe,'fontsize',14)
set(gca,'TickDir','out');
set(gca,'Box','off');
set(gca,'TickLength',[0.02 0.025]);
set(gca,'YTick',[])
set(gcf,'position',[100, 200, 800, 400])

print('-depsc','-r400','figs/pawplot.eps')



function plotonestep(cellind,ldat,fig)
figure(fig)
hold on;
%size(ldat)
%pause;
sampint=0.033;
lineheight=0.8;
stepsep=lineheight+0.2;

ddat1=diff(ldat(1,:));
ddat2=diff(ldat(2,:));

for i=1:length(ddat1)
    if ddat1(i)>0.3
    plot([i i]*sampint,[(1*cellind) (1*cellind+lineheight)],'r-', 'LineWidth',1.5);
    end;
%    if ddat2(i)>0.3
%    plot([i i]*sampint,[ (2*cellind+stepsep) (2*cellind+stepsep+lineheight)],'b-','LineWidth', 1.5);
%    end;
end;


