close all;
z_threshold=2;
zpad=0.3;
width=350;
height=400;




load 'analyzed/MFTerrs'
m_err_tot=100*errs;
m_err_zscore=errs_z_score;
m_cvs=cvs;
m_cvs_lf=m_cvs(:,1);
m_cvs_rf=m_cvs(:,2);
m_oss_lf=oss(:,1);
m_oss_rf=oss(:,2);
m_oss_zscore_lf=oss_z_score(:,1);
m_oss_zscore_rf=oss_z_score(:,2);
m_evs_lf=evs(:,1);
m_evs_lf=convev(m_evs_lf,1);
m_evs_rf=evs(:,2);
m_evs_rf=convev(m_evs_rf,2);
m_shuffevs_lf=shuff_evs_tot(:,1);
m_shuffevs_lf=convev(m_shuffevs_lf,1);
m_shuffevs_rf=shuff_evs_tot(:,2);
m_shuffevs_rf=convev(m_shuffevs_rf,2);
%m_shuffevs_lf=shuff_evs(:,1);
%m_shuffevs_lf
%m_shuffevs_rf=shuff_evs(:,2);






load 'analyzed/EPSCerrs'
e_err_tot=100*errs;
e_err_zscore=errs_z_score;
e_cvs=cvs;
e_cvs_lf=e_cvs(:,1);
e_cvs_rf=e_cvs(:,2);
e_oss_lf=oss(:,1);
e_oss_rf=oss(:,2);
e_oss_zscore_lf=oss_z_score(:,1);
e_oss_zscore_rf=oss_z_score(:,2);
e_evs_lf=evs(:,1);
e_evs_lf
e_evs_lf=convev(e_evs_lf,1);
e_evs_rf=evs(:,2);
e_evs_rf=convev(e_evs_rf,2);
e_shuffevs_lf=shuff_evs_tot(:,1);
e_shuffevs_lf=convev(e_shuffevs_lf,1);
e_shuffevs_rf=shuff_evs_tot(:,2);
e_shuffevs_rf=convev(e_shuffevs_rf,2);


load 'analyzed/spikeserrs'
s_err_tot=100*errs;
s_err_zscore=errs_z_score;
s_cvs=cvs;
s_cvs_lf=s_cvs(:,1);
s_cvs_rf=s_cvs(:,2);
s_oss_lf=oss(:,1);
s_oss_rf=oss(:,2);
s_oss_zscore_lf=oss_z_score(:,1);
s_oss_zscore_rf=oss_z_score(:,2);
s_evs_lf=evs(:,1);
s_evs_lf
s_evs_lf=convev(s_evs_lf,1);
s_shuffevs_lf=shuff_evs_tot(:,1);
s_shuffevs_lf=convev(s_shuffevs_lf,1);
s_evs_rf=evs(:,2);
s_evs_rf=convev(s_evs_rf,2);
s_shuffevs_rf=shuff_evs_tot(:,2);
s_shuffevs_rf=convev(s_shuffevs_rf,2);


load 'analyzed/Spillerrs'
sp_err_tot=100*errs;
sp_err_zscore=errs_z_score;
sp_cvs=cvs;
sp_cvs_lf=sp_cvs(:,1);
sp_cvs_rf=sp_cvs(:,2);
sp_oss_lf=oss(:,1);
sp_oss_rf=oss(:,2);
sp_oss_zscore_lf=oss_z_score(:,1);
sp_oss_zscore_rf=oss_z_score(:,2);
sp_evs_lf=evs(:,1);
sp_evs_lf
sp_evs_lf=convev(sp_evs_lf,1);
sp_shuffevs_lf=shuff_evs_tot(:,1);
sp_shuffevs_lf=convev(sp_shuffevs_lf,1);
sp_evs_rf=evs(:,2);
sp_evs_rf=convev(sp_evs_rf,2);
sp_shuffevs_rf=shuff_evs_tot(:,2);
sp_shuffevs_rf=convev(sp_shuffevs_rf,2);


figure;
hold on;
title('Prediction quality')
ylabel('Prediction quality %');


m_err=[];

m_pred_zscores=[];
for i=1:size(m_err_tot,1)
    
    ind=1;
    
    if m_err_tot(i,2)>m_err_tot(i,1)
        ind=2;
    end;
    
    currerr=m_err_tot(i,ind);
    currz=m_err_zscore(i,ind);
    m_err=[m_err; currerr];
    m_pred_zscores=[m_pred_zscores;currz];
    
    
    plot(1,currerr,'ro');
    if (currz>z_threshold)
        plot(1+zpad,currerr,'r*');    
    end;
end
    
    
plot(m_err.*0+1,m_err,'ro');


e_err=[];
e_pred_zscores=[];
for i=1:size(e_err_tot,1)
    
    ind=1;
    
    if e_err_tot(i,2)>e_err_tot(i,1)
        ind=2;
    end;
    
    currerr=e_err_tot(i,ind);
    currz=e_err_zscore(i,ind);
    e_err=[e_err; currerr];
    e_pred_zscores=[e_pred_zscores;currz];
    
    plot(2,currerr,'go');
    if (currz>z_threshold)
        plot(2+zpad,currerr,'g*');    
    end;
end
    
    
plot(e_err.*0+2,e_err,'go');


s_err=[];
s_pred_zscores=[];
for i=1:size(s_err_tot,1)
    
    ind=1;
    
    if s_err_tot(i,2)>s_err_tot(i,1)
        ind=2;
    end;
    
    currerr=s_err_tot(i,ind);
    currz=s_err_zscore(i,ind);
    s_err=[s_err; currerr];
    s_pred_zscores=[s_pred_zscores;currz];
    
    plot(3,currerr,'bo');
    if (currz>z_threshold)
        plot(3+zpad,currerr,'b*');    
    end;
end
plot(s_err.*0+3,s_err,'bo');
%legend('GC EPSC','MFT','GC spike');


sp_err=[];
sp_pred_zscores=[];
for i=1:size(sp_err_tot,1)
    
    ind=1;
    
    if sp_err_tot(i,2)>sp_err_tot(i,1)
        ind=2;
    end;
    
    currerr=sp_err_tot(i,ind);
    currz=sp_err_zscore(i,ind);
    sp_err=[sp_err; currerr];
    sp_pred_zscores=[sp_pred_zscores;currz];
    
    
    plot(4,currerr,'ko');
    if (currz>z_threshold)
        plot(4+zpad,currerr,'k*');    
    end;
end
plot(sp_err.*0+4,sp_err,'ko');


%size(m_err)
errorbar(4,mean(sp_err),std(sp_err)./sqrt(size(sp_err,1)-1),'kx','MarkerFaceColor',[1 1 1]);
errorbar(3,mean(s_err),std(s_err)./sqrt(size(s_err,1)-1),'bx','MarkerFaceColor',[1 1 1]);
errorbar(1,mean(m_err),std(m_err)./sqrt(size(m_err,1)-1),'rx','MarkerFaceColor',[1 1 1]);
errorbar(2,mean(e_err),std(e_err)./sqrt(size(e_err,1)-1),'gx','MarkerFaceColor',[1 1 1]);

%xlim([0.5 3.5]);

ylim([0 100]);
axe=gca;
set(axe,'FontName','arial')
set(axe,'fontsize',14)
set(gca,'TickDir','out');
set(gca,'Box','off');
set(gca,'TickLength',[0.02 0.025]);
set(gca,'XTick',[1 2 3 4])
set(gca,'XTickLabel',{'MFTs';'EPSCs';'Spikes';'Spillover'})
set(gcf,'position',[450, 300, width, height])

set(gcf, 'PaperPositionMode', 'auto');


print('-depsc','-r400','figs/tot_prediction.eps')


'----- PREDICTION ERRORS---'

'm_pred_zscores'
[h,p]=ttest(m_pred_zscores)
mean(m_pred_zscores)
std(m_pred_zscores)./(sqrt(length(m_pred_zscores)-1))

'e_pred_zscores'
[h,p]=ttest(e_pred_zscores)
mean(e_pred_zscores)
std(e_pred_zscores)./(sqrt(length(e_pred_zscores)-1))


's_pred_zscores'
[h,p]=ttest(s_pred_zscores)
mean(s_pred_zscores)
std(s_pred_zscores)./(sqrt(length(s_pred_zscores)-1))

'sp_pred_zscores'
[h,p]=ttest(sp_pred_zscores)
mean(sp_pred_zscores)
std(sp_pred_zscores)./(sqrt(length(sp_pred_zscores)-1))


pause;


figure;
hold on;
title('Circular variance left forelimb')
ylabel('Circular variance');
plot(m_cvs_lf.*0+1,m_cvs_lf,'ro');
plot(e_cvs_lf.*0+2,e_cvs_lf,'go');
plot(s_cvs_lf.*0+3,s_cvs_lf,'bo');
plot(sp_cvs_lf.*0+4,sp_cvs_lf,'ko');
%legend('GC EPSC','MFT','GC spike');


size(m_cvs_lf)
errorbar(4,mean(sp_cvs_lf),std(sp_cvs_lf)./sqrt(size(sp_cvs_lf,1)-1),'kx','MarkerFaceColor',[1 1 1]);
errorbar(3,mean(s_cvs_lf),std(s_cvs_lf)./sqrt(size(s_cvs_lf,1)-1),'bx','MarkerFaceColor',[1 1 1]);
errorbar(1,mean(m_cvs_lf),std(m_cvs_lf)./sqrt(size(m_cvs_lf,1)-1),'rx','MarkerFaceColor',[1 1 1]);
errorbar(2,mean(e_cvs_lf),std(e_cvs_lf)./sqrt(size(e_cvs_lf,1)-1),'gx','MarkerFaceColor',[1 1 1]);

%xlim([0.5 3.5]);

axe=gca;
ylim([0 1]);
set(axe,'FontName','arial')
set(axe,'fontsize',14)
set(gca,'TickDir','out');
set(gca,'Box','off');
set(gca,'TickLength',[0.02 0.025]);
set(gca,'XTick',[1 2 3 4]);
set(gca,'XTickLabel',{'MFTs';'EPSCs';'Spikes'});
set(gcf,'position',[450, 200, width, height]);
set(gcf, 'PaperPositionMode', 'auto');

print('-depsc','-r400','figs/tot_cv_left.eps');




figure;
hold on;
title('Circular variance right forelimb')
ylabel('Circular variance');
plot(m_cvs_rf.*0+1,m_cvs_rf,'ro');
plot(e_cvs_rf.*0+2,e_cvs_rf,'go');
plot(s_cvs_rf.*0+3,s_cvs_rf,'bo');
plot(sp_cvs_rf.*0+4,sp_cvs_rf,'ko');
%legend('GC EPSC','MFT','GC spike');


size(m_cvs_rf)
errorbar(4,mean(sp_cvs_rf),std(sp_cvs_rf)./sqrt(size(sp_cvs_rf,1)-1),'kx','MarkerFaceColor',[1 1 1]);
errorbar(3,mean(s_cvs_rf),std(s_cvs_rf)./sqrt(size(s_cvs_rf,1)-1),'bx','MarkerFaceColor',[1 1 1]);
errorbar(1,mean(m_cvs_rf),std(m_cvs_rf)./sqrt(size(m_cvs_rf,1)-1),'rx','MarkerFaceColor',[1 1 1]);
errorbar(2,mean(e_cvs_rf),std(e_cvs_rf)./sqrt(size(e_cvs_rf,1)-1),'gx','MarkerFaceColor',[1 1 1]);

%xlim([0.5 3.5]);

axe=gca;
ylim([0 1]);
set(axe,'FontName','arial')
set(axe,'fontsize',14)
set(gca,'TickDir','out');
set(gca,'Box','off');
set(gca,'TickLength',[0.02 0.025]);
set(gca,'XTick',[1 2 3 4]);
set(gca,'XTickLabel',{'MFTs';'EPSCs';'Spikes'});
set(gcf,'position',[450, 200, width, height]);
set(gcf, 'PaperPositionMode', 'auto');

print('-depsc','-r400','figs/tot_cv_right.eps');



figure;
hold on;
title('Modulation by left limb')
ylabel('Modulation index');
plot(m_oss_lf.*0+1,m_oss_lf,'ro');


for i=1:length(m_oss_zscore_lf)
    currz=m_oss_zscore_lf(i);
    if (currz>z_threshold)
        plot(m_oss_lf.*0+1+zpad,m_oss_lf(i),'r*');    
    end;
end;

plot(e_oss_lf.*0+2,e_oss_lf,'go');

for i=1:length(e_oss_zscore_lf)
    currz=e_oss_zscore_lf(i);

    if (currz>z_threshold)
        plot(e_oss_lf.*0+2+zpad,e_oss_lf(i),'g*');    
    end;
end;


s_oss_lf

pause;

plot(s_oss_lf.*0+3,s_oss_lf,'bo');
%legend('GC EPSC','MFT','GC spike');

for i=1:length(s_oss_lf)
    currz=s_oss_zscore_lf(i);
    if (currz>z_threshold)
        plot(s_oss_lf.*0+3+zpad,s_oss_lf(i),'b*');    
    end;
end;


plot(sp_oss_lf.*0+4,sp_oss_lf,'ko');
%legend('GC EPSC','MFT','GC spike');

for i=1:length(sp_oss_lf)
    currz=sp_oss_zscore_lf(i);
    if (currz>z_threshold)
        plot(sp_oss_lf.*0+4+zpad,sp_oss_lf(i),'b*');    
    end;
end;


size(m_cvs_lf)
errorbar(4,mean(sp_oss_lf),std(sp_oss_lf)./sqrt(size(sp_oss_lf,1)-1),'kx','MarkerFaceColor',[1 1 1]);
errorbar(3,mean(s_oss_lf),std(s_oss_lf)./sqrt(size(s_oss_lf,1)-1),'bx','MarkerFaceColor',[1 1 1]);
errorbar(1,mean(m_oss_lf),std(m_oss_lf)./sqrt(size(m_oss_lf,1)-1),'rx','MarkerFaceColor',[1 1 1]);
errorbar(2,mean(e_oss_lf),std(e_oss_lf)./sqrt(size(e_oss_lf,1)-1),'gx','MarkerFaceColor',[1 1 1]);

%xlim([0.5 3.5]);

axe=gca;
ylim([0 1]);
set(axe,'FontName','arial')
set(axe,'fontsize',14)
set(gca,'TickDir','out');
set(gca,'Box','off');
set(gca,'TickLength',[0.02 0.025]);
set(gca,'XTick',[1 2 3 4]);
set(gca,'XTickLabel',{'MFTs';'EPSCs';'Spikes';'Spillover'});
set(gcf,'position',[450, 200, width, height]);
set(gcf, 'PaperPositionMode', 'auto');

print('-depsc','-r400','figs/tot_oss_rightt.eps');



figure;
hold on;
title('Modulation by right limb')
ylabel('Modulation index');
plot(m_oss_rf.*0+1,m_oss_rf,'ro');

for i=1:length(m_oss_zscore_rf)
    currz=m_oss_zscore_rf(i);
    if (currz>z_threshold)
        plot(m_oss_rf.*0+1+zpad,m_oss_rf(i),'r*');    
    end;
end;


plot(e_oss_rf.*0+2,e_oss_rf,'go');

for i=1:length(e_oss_zscore_rf)
    currz=e_oss_zscore_rf(i);
    if (currz>z_threshold)
        plot(e_oss_rf.*0+2+zpad,e_oss_rf(i),'g*');    
    end;
end;



plot(s_oss_rf.*0+3,s_oss_rf,'bo');
%legend('GC EPSC','MFT','GC spike');

for i=1:length(s_oss_zscore_rf)
    currz=s_oss_zscore_rf(i);
    if (currz>z_threshold)
        plot(s_oss_rf.*0+3+zpad,s_oss_rf(i),'b*');    
    end;
end;



plot(sp_oss_rf.*0+4,sp_oss_rf,'ko');
%legend('GC EPSC','MFT','GC spike');

for i=1:length(sp_oss_zscore_rf)
    currz=sp_oss_zscore_rf(i);
    if (currz>z_threshold)
        plot(sp_oss_rf.*0+4+zpad,sp_oss_rf(i),'k*');    
    end;
end;



size(m_cvs_lf)
errorbar(4,mean(sp_oss_rf),std(sp_oss_rf)./sqrt(size(sp_oss_rf,1)-1),'kx','MarkerFaceColor',[1 1 1]);
errorbar(3,mean(s_oss_rf),std(s_oss_rf)./sqrt(size(s_oss_rf,1)-1),'bx','MarkerFaceColor',[1 1 1]);
errorbar(1,mean(m_oss_rf),std(m_oss_rf)./sqrt(size(m_oss_rf,1)-1),'rx','MarkerFaceColor',[1 1 1]);
errorbar(2,mean(e_oss_rf),std(e_oss_rf)./sqrt(size(e_oss_rf,1)-1),'gx','MarkerFaceColor',[1 1 1]);

%xlim([0.5 3.5]);

axe=gca;
ylim([0 1]);
set(axe,'FontName','arial')
set(axe,'fontsize',14)
set(gca,'TickDir','out');
set(gca,'Box','off');
set(gca,'TickLength',[0.02 0.025]);
set(gca,'XTick',[1 2 3 4]);
set(gca,'XTickLabel',{'MFTs';'EPSCs';'Spikes';'Spillover'});
set(gcf,'position',[450, 200, width, height]);
set(gcf, 'PaperPositionMode', 'auto');

print('-depsc','-r400','figs/tot_oss_left.eps');



figure;
hold on;
%%%%%%%PREDICTION 2
m_evs_lf
m_evs_rf
%m_shuffevs
%m_shuffevs

%MFT
minsteps=0;
for i=1:length(m_evs_lf)
    arr1=m_evs_lf{i};
    shuffarr1=m_shuffevs_lf{i};
    
    if (arr1(1).Nactual<minsteps)
        continue;
    end;
    
    D=[];
    for j=1:length(arr1)
        arr1(j).Nactual
        if (isnan(arr1(j).F1)==0)
            D=[D;arr1(j).F1];
        end;
    end;
    
    mD=mean(D);
    currz=0;
    
    Dshuff=[];
    for j=1:length(shuffarr1)
        arr1(j).Nactual
        if (isnan(shuffarr1(j).F1)==0)
            Dshuff=[Dshuff;shuffarr1(j).F1];
        end;
    end;
    
    st=std(Dshuff);
    mt=mean(Dshuff);
    currz=(mD-mt)./st;
        plot(1,mD,'ro');
        
     if (currz>z_threshold)
        plot(1+zpad,mD,'r*');    
    end;
end;

%EPSC
'EPSC'
for i=1:length(e_evs_lf)
    arr1=e_evs_lf{i};
    shuffarr1=e_shuffevs_lf{i};
    
    if (arr1(1).Nactual<minsteps)
        continue;
    end;
    
    D=[];
    for j=1:length(arr1)
        arr1(j).Nactual
        if (isnan(arr1(j).F1)==0)
            D=[D;arr1(j).F1];
        end;
    end;
    
    mD=mean(D);
    currz=0;
    
    
    
    Dshuff=[];
    for j=1:length(shuffarr1)
        arr1(j).Nactual
        if (isnan(arr1(j).F1)==0)
            Dshuff=[Dshuff;shuffarr1(j).F1];
        end;
    end;

    st=std(Dshuff);
    mt=mean(Dshuff);
    currz=(mD-mt)./st;
  

    
    plot(2,mD,'go');
        
     if (currz>z_threshold)
        plot(2+zpad,mD,'g*');    
    end;
end;



%spike
'SPIKE'
for i=1:length(s_evs_lf)
    arr1=s_evs_lf{i};
    shuffarr1=s_shuffevs_lf{i};
    
    if (arr1(1).Nactual<minsteps)
        continue;
    end;
    
    D=[];
    for j=1:length(arr1)
        arr1(j).Nactual
        if (isnan(arr1(j).F1)==0)
            D=[D;arr1(j).F1];
        end;
    end;
    
    mD=mean(D);
    currz=0;
    
    
    
    Dshuff=[];
    for j=1:length(shuffarr1)
        arr1(j).Nactual
        if (isnan(arr1(j).F1)==0)
            Dshuff=[Dshuff;shuffarr1(j).F1];
        end;
    end;

    st=std(Dshuff);
    mt=mean(Dshuff);
    currz=(mD-mt)./st;
  

    
    plot(3,mD,'bo');
        
     if (currz>z_threshold)
        plot(3+zpad,mD,'b*');    
    end;
end;



'SPILLOVEr'
for i=1:length(sp_evs_lf)
    arr1=sp_evs_lf{i};
    shuffarr1=sp_shuffevs_lf{i};
    
    if (arr1(1).Nactual<minsteps)
        continue;
    end;
    
    D=[];
    for j=1:length(arr1)
        arr1(j).Nactual
        if (isnan(arr1(j).F1)==0)
            D=[D;arr1(j).F1];
        end;
    end;
    
    mD=mean(D);
    currz=0;
    
    
    
    Dshuff=[];
    for j=1:length(shuffarr1)
        arr1(j).Nactual
        if (isnan(arr1(j).F1)==0)
            Dshuff=[Dshuff;shuffarr1(j).F1];
        end;
    end;

    st=std(Dshuff);
    mt=mean(Dshuff);
    currz=(mD-mt)./st;
  

    
    plot(4,mD,'ko');
        
     if (currz>z_threshold)
        plot(4+zpad,mD,'k*');    
    end;
end;


axe=gca;
title('Prediction left limb');
ylim([0 1]);
set(axe,'FontName','arial')
set(axe,'fontsize',14)
set(gca,'TickDir','out');
set(gca,'Box','off');
set(gca,'TickLength',[0.02 0.025]);
set(gca,'XTick',[1 2 3 4]);
set(gca,'XTickLabel',{'MFTs';'EPSCs';'Spikes';'Spillover'});
set(gcf,'position',[450, 200, width, height]);
set(gcf, 'PaperPositionMode', 'auto');
xlim([0.5 4.5]);

print('-depsc','-r400','figs/F1_fact_lf.eps');



%%%%%%%PREDICTION 2 right limb
m_evs_lf
m_evs_rf
%m_shuffevs
%m_shuffevs

figure;
hold on;

%MFT
minsteps=0;
for i=1:length(m_evs_rf)
    arr1=m_evs_rf{i};
    shuffarr1=m_shuffevs_rf{i};
    
    if (arr1(1).Nactual<minsteps)
        continue;
    end;
    
    D=[];
    for j=1:length(arr1)
        arr1(j).Nactual
        if (isnan(arr1(j).F1)==0)
            D=[D;arr1(j).F1];
        end;
    end;
    
    mD=mean(D);
    currz=0;
    
    Dshuff=[];
    for j=1:length(shuffarr1)
        arr1(j).Nactual
        if (isnan(shuffarr1(j).F1)==0)
            Dshuff=[Dshuff;shuffarr1(j).F1];
        end;
    end;
    
    st=std(Dshuff);
    mt=mean(Dshuff);
    currz=(mD-mt)./st;
        plot(1,mD,'ro');
        
     if (currz>z_threshold)
        plot(1+zpad,mD,'r*');    
    end;
end;

%EPSC
'EPSC'
for i=1:length(e_evs_rf)
    arr1=e_evs_rf{i};
    shuffarr1=e_shuffevs_rf{i};
    
    if (arr1(1).Nactual<minsteps)
        continue;
    end;
    
    D=[];
    for j=1:length(arr1)
        arr1(j).Nactual
        if (isnan(arr1(j).F1)==0)
            D=[D;arr1(j).F1];
        end;
    end;
    
    mD=mean(D);
    currz=0;
    
    
    
    Dshuff=[];
    for j=1:length(shuffarr1)
        arr1(j).Nactual
        if (isnan(arr1(j).F1)==0)
            Dshuff=[Dshuff;shuffarr1(j).F1];
        end;
    end;

    st=std(Dshuff);
    mt=mean(Dshuff);
    currz=(mD-mt)./st;
  

    
    plot(2,mD,'go');
        
     if (currz>z_threshold)
        plot(2+zpad,mD,'g*');    
    end;
end;



%spike
'SPIKE'
length(s_evs_rf)
for i=1:length(s_evs_rf)
    arr1=s_evs_rf{i};
    shuffarr1=s_shuffevs_rf{i};
    
    if (arr1(1).Nactual<minsteps)
        continue;
    end;
    
    D=[];
    for j=1:length(arr1)
        arr1(j).Nactual
        if (isnan(arr1(j).F1)==0)
            D=[D;arr1(j).F1];
        end;
    end;
    
    mD=mean(D);
    currz=0;
    
    
    
    Dshuff=[];
    for j=1:length(shuffarr1)
        arr1(j).Nactual
        if (isnan(arr1(j).F1)==0)
            Dshuff=[Dshuff;shuffarr1(j).F1];
        end;
    end;

    st=std(Dshuff);
    mt=mean(Dshuff);
    currz=(mD-mt)./st;
  

    
    plot(3,mD,'bo');
        
     if (currz>z_threshold)
        plot(3+zpad,mD,'b*');    
    end;
end;




'SPILLOVER'
for i=1:length(sp_evs_rf)
    arr1=sp_evs_rf{i};
    shuffarr1=sp_shuffevs_rf{i};
    
    if (arr1(1).Nactual<minsteps)
        continue;
    end;
    
    D=[];
    for j=1:length(arr1)
        arr1(j).Nactual
        if (isnan(arr1(j).F1)==0)
            D=[D;arr1(j).F1];
        end;
    end;
    
    mD=mean(D);
    currz=0;
    
    
    
    Dshuff=[];
    for j=1:length(shuffarr1)
        arr1(j).Nactual
        if (isnan(arr1(j).F1)==0)
            Dshuff=[Dshuff;shuffarr1(j).F1];
        end;
    end;

    st=std(Dshuff);
    mt=mean(Dshuff);
    currz=(mD-mt)./st;
  

    
    plot(4,mD,'ko');
        
     if (currz>z_threshold)
        plot(4+zpad,mD,'k*');    
    end;
end;


axe=gca;
title('Prediction right limb');
ylim([0 1]);
set(axe,'FontName','arial')
set(axe,'fontsize',14)
set(gca,'TickDir','out');
set(gca,'Box','off');
set(gca,'TickLength',[0.02 0.025]);
set(gca,'XTick',[1 2 3 4]);
set(gca,'XTickLabel',{'MFTs';'EPSCs';'Spikes';'Spillover'});
set(gcf,'position',[450, 200, width, height]);
set(gcf, 'PaperPositionMode', 'auto');
xlim([0.5 4.5]);

print('-depsc','-r400','figs/F1_fact_rf.eps');


'-----ERRORS---'

'm_oss_zscore_lf'
[h,p]=ttest(m_oss_zscore_lf)
mean(m_oss_zscore_lf)
std(m_oss_zscore_lf)./(sqrt(length(m_oss_zscore_lf)-1))

'm_oss_zscore_rf'
[h,p]=ttest(m_oss_zscore_rf)
mean(m_oss_zscore_rf)
std(m_oss_zscore_rf)./(sqrt(length(m_oss_zscore_rf)-1))

'e_oss_zscore_lf'
[h,p]=ttest(e_oss_zscore_lf)
mean(e_oss_zscore_lf)
std(e_oss_zscore_lf)./(sqrt(length(e_oss_zscore_lf)-1))

'e_oss_zscore_rf'
[h,p]=ttest(e_oss_zscore_rf)
mean(e_oss_zscore_rf)
std(e_oss_zscore_rf)./(sqrt(length(e_oss_zscore_rf)-1))

's_oss_zscore_lf'
[h,p]=ttest(s_oss_zscore_lf)
mean(s_oss_zscore_lf)
std(s_oss_zscore_lf)./(sqrt(length(s_oss_zscore_lf)-1))

's_oss_zscore_rf'
[h,p]=ttest(s_oss_zscore_rf)
mean(s_oss_zscore_rf)
std(s_oss_zscore_rf)./(sqrt(length(s_oss_zscore_rf)-1))

'sp_oss_zscore_lf'
[h,p]=ttest(sp_oss_zscore_lf)
mean(sp_oss_zscore_lf)
std(sp_oss_zscore_lf)./(sqrt(length(sp_oss_zscore_lf)-1))

'sp_oss_zscore_rf'
[h,p]=ttest(sp_oss_zscore_rf)
mean(sp_oss_zscore_rf)
std(sp_oss_zscore_rf)./(sqrt(length(sp_oss_zscore_rf)-1))

'DUUUUUUUUUDEE'

m_oss_zscore_lf
m_oss_zscore_rf
m_pred_zscores

e_oss_zscore_lf
e_oss_zscore_rf
e_pred_zscores

s_oss_zscore_lf
s_oss_zscore_rf
s_pred_zscores

sp_oss_zscore_lf
sp_oss_zscore_rf
sp_pred_zscores


