function varargout = stance_analyse(varargin)
% STANCE_ANALYSE M-file for stance_analyse.fig
%      STANCE_ANALYSE, by itself, creates a new STANCE_ANALYSE or raises the existing
%      singleton*.
%
%      H = STANCE_ANALYSE returns the handle to a new STANCE_ANALYSE or the handle to
%      the existing singleton*.
%
%      STANCE_ANALYSE('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in STANCE_ANALYSE.M with the given input arguments.
%
%      STANCE_ANALYSE('Property','Value',...) creates a new STANCE_ANALYSE or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before stance_analyse_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to stance_analyse_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help stance_analyse

% Last Modified by GUIDE v2.5 10-Oct-2011 18:02:24

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @stance_analyse_OpeningFcn, ...
                   'gui_OutputFcn',  @stance_analyse_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before stance_analyse is made visible.
function stance_analyse_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to stance_analyse (see VARARGIN)

% Choose default command line output for stance_analyse
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes stance_analyse wait for user response (see UIRESUME)
% uiwait(handles.gait_form);


%set(handles.limbpanel,'SelectionChangeFcn',@limbpanel_SelectionChangeFcn,'handles', handles)

% --- Outputs from this function are returned to the command line.
function varargout = stance_analyse_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes on button press in pushbutton1.
function pushbutton1_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on button press in pushbutton2.
function pushbutton2_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on button press in pushbutton3.
function pushbutton3_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on button press in pushbutton4.
function pushbutton4_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on button press in loadmoviebutton.
function loadmoviebutton_Callback(hObject, eventdata, handles)
% hObject    handle to loadmoviebutton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


1061


handles

 [filename, pathname, fi] = uigetfile('*','Choose a movie file');
 [p,f_npre,e]=fileparts(filename);
 
 
 fn=strcat(pathname,filename);

 roi=getroi(fn);
 
 
    prompt={'Start frame'};
    name='Enter start frame';
    numlines=1;
    defaultanswer={''};
    answer=inputdlg(prompt,name,numlines,defaultanswer);
    s=answer{1};
    
    
    
    options.startframe= str2num(s);
    options.fn=fn;
    options.f_prefix=f_npre;
    options.roi=roi;
    options.numframes= 1500;
    options.currframe=1;
    options.currlimb=1; 
    %1 left fore 2 right fore 3 left hind 4 right hind
    options.limbdata=-1*ones(options.numframes,4);
  
    setappdata(handles.gait_form,'options',options);
    
    loadvid(handles);
    
    
    dispframe(handles);
    
    
    function loadvid(handles)
    
    options=getappdata(handles.gait_form,'options');
    
    
    info.color='red'; 
    info.title='loading video'; 
    p=progbar(info); 

    
    readerobj=mmreader(options.fn);
 % Read in all video frames.
 
 
    x1=options.roi.pos(1);
    x2=options.roi.pos(3);
   y1=options.roi.pos(2);
   y2=options.roi.pos(4);
   hght=y2-y1;
   wdth=x2-x1;
   
   
  rngY=uint32(options.roi.pos(2)):uint32(options.roi.pos(4));
  rngX=uint32(options.roi.pos(1)):uint32(options.roi.pos(3));

 
  vidmat=zeros(length(rngY),length(rngX),3,options.numframes);
  
  'loading'
 for k=1:options.numframes
%     k
     
    currframe=options.startframe+k-1;
    vidFrames = read(readerobj,currframe);
    
%    size(vidFrames)
       % Get the number of frames.
    %numFrames = get(readerobj, 'numberOfFrames');
 %umFrames=9000

  
      
           blank1=zeros(hght,wdth,3);
           blank2=zeros(hght,wdth);
           
           
      frame= vidFrames(rngY,rngX,:);
      vidmat(:,:,:,k)=double(frame)/255;
    
      
      
        if (mod(k,10)==1)          
               progbar(p,k/options.numframes*100);

       end;
 end;
 
progbar(p,-1);
 
 options.videomatrix=vidmat;
 setappdata(handles.gait_form,'options',options);
 
%'dude'

     
    function dispframe(handles)
        
        
    options=getappdata(handles.gait_form,'options');
    axis(handles.videoaxis);
    
    
    
    currframe=options.videomatrix(:,:,:,options.currframe);

    
    image(currframe);
    
    
    set(handles.eptext,'String',strcat(num2str(options.currframe),'/',num2str(options.numframes)));
    
    
    if (options.limbdata(options.currframe,options.currlimb)==0)
    
    set(handles.statustext,'String','stance');  
   
    end
    
    if (options.limbdata(options.currframe,options.currlimb)==1)
    
    set(handles.statustext,'String','swing');  
   
    end
    
    if (options.limbdata(options.currframe,options.currlimb)==-1)
    
    set(handles.statustext,'String','undefined');  
   
    end
    
    
    
    if options.currlimb==1
        set(handles.limbpanel,'SelectedObject',handles.leftfore);
    end

    if options.currlimb==2
        set(handles.limbpanel,'SelectedObject',handles.rightfore);
    end 
    
    if options.currlimb==3
        set(handles.limbpanel,'SelectedObject',handles.lefthind);
    end
    
    if options.currlimb==4
        set(handles.limbpanel,'SelectedObject',handles.righthind);
    end   
%    set(eventdata.NewValue,'Tag')
    
    
 %   switch get(eventdata.NewValue,'Tag') % Get Tag of selected object.
 %   case 'leftfore'
 %       currcode=1;
        % Code for when radiobutton1 is selected.
 %   case 'rightfore'
 %       currcode=2;
        % Code for when radiobutton2 is selected.
%    case 'lefthind'
%        currcode=3;
        % Code for when togglebutton1 is selected.
%    case 'righthind'
%        currcode=4;
        % Code for when togglebutton2 is selected.
%   
%     end

    
    

%h = findobj(figurehandles,'Tag','FormatTb')

    
  %  'man'
      %            try
      %     vidFrames = read(readerobj,k);
      %     catch Exception
      %         'reading error!'
      %         break;
      %     end;
        
           
      %     for j=1:size(state,2)
      %         currlabel=state(j).label;
               
               
               
      %         rngY=uint32(state(j).roi.pos(2)):uint32(state(j).roi.pos(4));
      %         rngX=uint32(state(j).roi.pos(1)):uint32(state(j).roi.pos(3));


     %          state(j).currstate.k=k;
     %          state(j).currstate.frame= vidFrames(rngY,rngX,:);
     %          [mtnidx,currstate]=getmotionidx(state(j).currstate,alph,bet,40,state(j).im1,state(j).im2,se);
     %          state(j).currstate=currstate;
     %          state(j).tot(k,1)=mtnidx;

     %         
     %      end
           
     %      if (mod(k,100)==1)          
     %          progbar(p,k/numFrames*100);
     %          disp(f1,state, numFrames)
     %      end;

% --- Executes on button press in loadanalysisbutton.
function loadanalysisbutton_Callback(hObject, eventdata, handles)
% hObject    handle to loadanalysisbutton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

 [filename, pathname, fi] = uigetfile('*','Choose an analysis file');
 [p,f_npre,e]=fileparts(filename);

 fn=strcat(pathname,filename);
 load(fn);
 
 setappdata(handles.gait_form,'options',options);
 
 dispframe(handles)
 
% --- Executes on button press in saveanalysisbutton.
function saveanalysisbutton_Callback(hObject, eventdata, handles)
% hObject    handle to saveanalysisbutton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

options=getappdata(handles.gait_form,'options');
[filename, pathname] = uiputfile(strcat('stance_',options.f_prefix,'.mat'), 'Save analysis as');
 fn=strcat(pathname,filename);
save(fn,'options','-v7.3');

% --- Executes on button press in plotdatabutton.
function plotdatabutton_Callback(hObject, eventdata, handles)
% hObject    handle to plotdatabutton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on key press with focus on gait_form and none of its controls.
function gait_form_KeyPressFcn(hObject, eventdata, handles)
% hObject    handle to gait_form (see GCBO)
% eventdata  structure with the following fields (see FIGURE)
%	Key: name of the key that was pressed, in lower case
%	Character: character interpretation of the key(s) that was pressed
%	Modifier: name(s) of the modifier key(s) (i.e., control, shift) pressed
% handles    structure with handles and user data (see GUIDATA)

options=getappdata(handles.gait_form,'options');

if (strcmp(eventdata.Key,'z'))
    options.limbdata(options.currframe,options.currlimb)=1;

    options.currframe=min(options.currframe+1,options.numframes);
end;

if (strcmp(eventdata.Key,'m'))
    options.limbdata(options.currframe,options.currlimb)=0;
    options.currframe=min(options.currframe+1,options.numframes);
end;

if (strcmp(eventdata.Key,'leftarrow'))
   options.currframe=max(options.currframe-1,1); 
end

if (strcmp(eventdata.Key,'rightarrow'))
    options.currframe=min(options.currframe+1,options.numframes);
end;
setappdata(handles.gait_form,'options',options);
dispframe(handles);

function limbpanel_SelectionChangeFcn(hObject, eventdata, handles)


currcode=1;    
switch get(eventdata.NewValue,'Tag') % Get Tag of selected object.
    case 'leftfore'
        currcode=1;
        % Code for when radiobutton1 is selected.
    case 'rightfore'
        currcode=2;
        % Code for when radiobutton2 is selected.
    case 'lefthind'
        currcode=3;
        % Code for when togglebutton1 is selected.
    case 'righthind'
        currcode=4;
        % Code for when togglebutton2 is selected.
   
end

options=getappdata(handles.gait_form,'options');
options.currlimb=currcode;
setappdata(handles.gait_form,'options',options);
dispframe(handles);

% --- If Enable == 'on', executes on mouse press in 5 pixel border.
% --- Otherwise, executes on mouse press in 5 pixel border or over plotdatabutton.
function plotdatabutton_ButtonDownFcn(hObject, eventdata, handles)


% hObject    handle to plotdatabutton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on button press in plotbutton.
function plotbutton_Callback(hObject, eventdata, handles)
% hObject    handle to plotbutton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

    'dude'
f=figure;
options=getappdata(handles.gait_form,'options');
subplot(221);
plot(options.limbdata(:,1),'ro');
title('left fore');
subplot(222);
plot(options.limbdata(:,2),'ro');
title('right fore');
subplot(223);
plot(options.limbdata(:,3),'ro');
subplot(224);
plot(options.limbdata(:,4),'ro');


% --- Executes on button press in firstfframebuttom.
function firstfframebuttom_Callback(hObject, eventdata, handles)
% hObject    handle to firstfframebuttom (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
options=getappdata(handles.gait_form,'options');
options.currframe=1;
setappdata(handles.gait_form,'options',options);
dispframe(handles);
