
clf;
close all;
clear classes all;


addpath('MutualInformation')
addpath('mi')
addpath('ami')
addpath('svm_v0.56')





%a=uint8(rand(1,100)>0.25);
%b=uint8(rand(1,100)>0.25);
%entropy(a)

%mutualinfo(a,b)



load 'analyzed/EPSCs/ldat11.mat'
load 'analyzed/EPSCs/bins11.mat'

%load 'analyzed/EPSCs/ldat16.mat'
%load 'analyzed/EPSCs/bins16.mat'
%load 'analyzed/EPSCs/ldat41.mat'
%load 'analyzed/EPSCs/bins41.mat'

%load 'analyzed/EPSCs/ldat29.mat';
%load 'analyzed/EPSCs/bins29.mat';

gaitmat=ldat(:,2);
eventmat=bins;


epsize=30;
len=1400;

trainX=[];
trainY=[];
testX=[];
testY=[];

for i=1:len
    curra=eventmat(i:(i+epsize-1));
    
    
    
    currb= gaitmat(i+floor(epsize/2));
    
    %starti=i+floor(epsize/2);
    %currb= sum(gaitmat( (starti-2):(starti+2)))>3;
    
    
    curra=curra./mean(curra);
    
    if (i<floor(2*len/3))
    trainX=[trainX;curra'];
    trainY=[trainY;2*currb-1];
    else
        testX=[testX;curra'];
        testY=[testY;2*currb-1];        
    end;
end;


kernel = rbf(0.05);
C      = 100.0;
tutor  = smosvctutor;   % this means we use the SMO training algorithm
net    = dagsvm;        % this means we use the DAG-SVM algortihm to combine
                        % the outputs of a number of 2-class networks

                        
net = train(svc, tutor, trainX, trainY, C, kernel);
%net = fixduplicates(net, x, y);

%net2 = strip(net);

recov_trainY=fwd(net,trainX);
recov_testY=fwd(net,testX);
testX

% compute correctness
l=size(trainX,1)
fprintf(1,'correctness = %4.1f%%\n', 100*sum(sign(fwd(net,trainX))==trainY)./l);

plot(trainY,'b');
hold;
%plot(recov_trainY,'r');
plot(recov_trainY>0,'g');

figure;
%plot(recov_testY,'r');
hold;
plot(testY,'b');
plot(recov_testY>0,'g');

