close all;
clear;

sumdat=[];


valfig=figure;
figure;

%load ../GC_EPSCs/10519cell1EPSC/STAstuff03
%load ../spillover/spill10519000


%load ../GC_EPSCs/10910cell1EPSC/STAstuff16
%load ../spillover/spill10910007

%load ../GC_EPSCs/110111cell1EPSC/STAstuff00
%load ../spillover/spill110111000

%[bins,valbins]=convspill(spillmat);


%plot(bins);



load 'SPILLOVER'

SPILLOVER_dat=sumdat;



SPILLOVER_rs=[];
SPILLOVER_ms=[];
SPILLOVER_spike_rs=[];

for i=2:length(SPILLOVER_dat)
    SPILLOVER_rs=[SPILLOVER_rs;SPILLOVER_dat(i).r];
    SPILLOVER_ms=[SPILLOVER_ms;SPILLOVER_dat(i).maxcorr];
    SPILLOVER_spike_rs=[SPILLOVER_spike_rs;SPILLOVER_dat(i).mcorr];
end;



figure;
hold on;
title('correlation coefficient for spillover')
ylabel('Correlation of spillover to motion index');
plot(SPILLOVER_rs.*0+1,SPILLOVER_rs,'ro');
plot(SPILLOVER_ms.*0+2,SPILLOVER_ms,'go');

%legend('GC EPSC','MFT','GC spike');
errorbar(1,mean(SPILLOVER_rs),std(SPILLOVER_rs)./sqrt(size(SPILLOVER_rs,1)-1),'rx','MarkerFaceColor',[1 1 1]);

errorbar(2,mean(SPILLOVER_ms),std(SPILLOVER_ms)./sqrt(size(SPILLOVER_ms,1)-1),'gx','MarkerFaceColor',[1 1 1]);

xlim([0.5 2.5]);

axe=gca;
set(axe,'FontName','arial')
set(axe,'fontsize',14)
set(gca,'TickDir','out');
set(gca,'Box','off');
set(gca,'TickLength',[0.02 0.025]);
set(gca,'XTick',[1 2])
set(gca,'XTickLabel',{'Long time';'short time'})
set(gcf,'position',[100, 200, 300, 400])
print('-depsc','-r400','figs/TOT_spillovercorr.eps')


figure;
hold on;
%title('Correlation of spillover to EPSC frequency')
ylabel('Correlation of spillover to EPSC frequency');
plot(SPILLOVER_spike_rs.*0+1,SPILLOVER_spike_rs,'ro');


%legend('GC EPSC','MFT','GC spike');
errorbar(1,mean(SPILLOVER_spike_rs),std(SPILLOVER_spike_rs)./sqrt(size(SPILLOVER_spike_rs,1)-1),'rx','MarkerFaceColor',[1 1 1]);

xlim([0.5 1.5]);

axe=gca;
set(axe,'FontName','arial')
set(axe,'fontsize',14)
set(gca,'TickDir','out');
set(gca,'Box','off');
set(gca,'TickLength',[0.02 0.025]);
set(gca,'XTick',[1])
set(gca,'XTickLabel',{'Spillover'})
set(gcf,'position',[100, 200, 150, 400])
print('-depsc','-r400','figs/TOT_spillovercorr.eps')


figure;
title('correlation of spikes versus correlation of motion')
plot(SPILLOVER_spike_rs,SPILLOVER_rs,'ro');

