clear; close all;



analyze_GC_EPSCs;
%analyze_MFTs;
%analyze_GCspikes;
%analyze_spillover;


z_threshold=2;
p_threshold=0.05;
zpad=0.3;

load 'GC_EPSC_tot'
'EPSC'
GCEPSC_dat=get_z_score_for_analysis(sumdat);



load 'MFT_Spikes'
'MFT'
MFT_dat=get_z_score_for_analysis(sumdat);

load 'GC_spikes'
'GC SPIKES'
GSPIKE_dat=get_z_score_for_analysis(sumdat);


load 'SPILLOVER'
'SPILLOVER'
SPILLOVER_dat=get_z_score_for_analysis(sumdat);




GEPSCS_rs=[];
GEPSCS_rs_ps=[];
GEPSCS_ms=[];
GEPSCS_ms_z=[];
GEPSCS_ts=[];
GEPSCS_xcs=[];

for i=1:length(GCEPSC_dat)
    GEPSCS_rs=[GEPSCS_rs;GCEPSC_dat(i).r];
    GEPSCS_rs_ps=[GEPSCS_rs_ps; GCEPSC_dat(i).r_p(1,2)];
    GEPSCS_ms=[GEPSCS_ms;GCEPSC_dat(i).maxcorr];
    GEPSCS_ms_z=[GEPSCS_ms_z;GCEPSC_dat(i).maxcorr_z_score];
    GEPSCS_ts=[GEPSCS_ts;GCEPSC_dat(i).maxcorrt];
    GEPSCS_xcs=[GEPSCS_xcs;GCEPSC_dat(i).xc];
end;


'GEPSCS_ms_z'
GEPSCS_ms_z


MFT_rs=[];
MFT_rs_ps=[];
MFT_ms=[];
MFT_ms_z=[];
MFT_ts=[];
MFT_xcs=[];
for i=1:length(MFT_dat)
    MFT_rs=[MFT_rs;MFT_dat(i).r];
    MFT_rs_ps=[MFT_rs_ps; MFT_dat(i).r_p(1,2)];
    MFT_ms=[MFT_ms;MFT_dat(i).maxcorr];
    MFT_ms_z=[MFT_ms_z;MFT_dat(i).maxcorr_z_score];
    MFT_ts=[MFT_ts;MFT_dat(i).maxcorrt];
    MFT_xcs=[MFT_xcs;MFT_dat(i).xc];
end;





GSPIKE_rs=[];
GSPIKE_rs_ps=[];
GSPIKE_ms=[];
GSPIKE_ms_z=[];
GSPIKE_ts=[];
GSPIKE_xcs=[];
for i=1:length(GSPIKE_dat)
    GSPIKE_rs=[GSPIKE_rs;GSPIKE_dat(i).r];
    GSPIKE_rs_ps=[GSPIKE_rs_ps; GSPIKE_dat(i).r_p(1,2)];
    GSPIKE_ms=[GSPIKE_ms;GSPIKE_dat(i).maxcorr];
    GSPIKE_ms_z=[GSPIKE_ms_z;GSPIKE_dat(i).maxcorr_z_score];
    GSPIKE_ts=[GSPIKE_ts;GSPIKE_dat(i).maxcorrt];
    GSPIKE_xcs=[GSPIKE_xcs;GSPIKE_dat(i).xc];
   
end;




SPILLOVER_rs=[];
SPILLOVER_rs_ps=[];
SPILLOVER_ms=[];
SPILLOVER_ms_z=[];

SPILLOVER_spike_rs=[];

for i=2:length(SPILLOVER_dat)
    SPILLOVER_rs=[SPILLOVER_rs;SPILLOVER_dat(i).r];
    SPILLOVER_rs_ps=[SPILLOVER_rs_ps; SPILLOVER_dat(i).r_p(1,2)];
    SPILLOVER_ms=[SPILLOVER_ms;SPILLOVER_dat(i).maxcorr];
    SPILLOVER_ms_z=[SPILLOVER_ms_z;SPILLOVER_dat(i).maxcorr_z_score];
    SPILLOVER_spike_rs=[SPILLOVER_spike_rs;SPILLOVER_dat(i).mcorr];
end;





figure;
hold on;

set(gcf, 'PaperPositionMode', 'auto');

title('Correlation coefficient for long (1.5s) periods')
ylabel('Correlation coefficient')
plot(MFT_rs.*0+1,MFT_rs,'ro');
plot(GEPSCS_rs.*0+2,GEPSCS_rs,'go');
plot(SPILLOVER_rs.*0+3,SPILLOVER_rs,'mo');
plot(GSPIKE_rs.*0+4,GSPIKE_rs,'bo');
%legend('GC EPSC','MFT','GC spike');



for i=1:length(MFT_rs_ps)
    currp=MFT_rs_ps(i);
    if (currp<p_threshold)
        plot(MFT_rs_ps.*0+1+zpad,MFT_rs(i),'r*');    
    end;
end;

for i=1:length(GEPSCS_rs_ps)
    currp=GEPSCS_rs_ps(i);
    if (currp<p_threshold)
        plot(GEPSCS_rs_ps.*0+2+zpad,GEPSCS_rs(i),'g*');    
    end;
end;



for i=1:length(SPILLOVER_rs_ps)
    currp=SPILLOVER_rs_ps(i);
    if (currp<p_threshold)
        plot(SPILLOVER_rs_ps.*0+3+zpad,SPILLOVER_rs(i),'m*');    
    end;
end;


for i=1:length(GSPIKE_rs_ps)
    currp=GSPIKE_rs_ps(i);
    if (currp<p_threshold)
        plot(GSPIKE_rs_ps.*0+4+zpad,GSPIKE_rs(i),'b*');    
    end;
end;


errorbar(1,mean(MFT_rs),std(MFT_rs)./sqrt(size(MFT_rs,1)-1),'rx','MarkerFaceColor',[1 1 1]);
errorbar(2,mean(GEPSCS_rs),std(GEPSCS_rs)./sqrt(size(GEPSCS_rs,1)-1),'gx','MarkerFaceColor',[1 1 1]);
errorbar(3,mean(SPILLOVER_rs),std(SPILLOVER_rs)./sqrt(size(SPILLOVER_rs,1)-1),'m-x','MarkerFaceColor',[1 1 1]);
errorbar(4,mean(GSPIKE_rs),std(GSPIKE_rs)./sqrt(size(GSPIKE_rs,1)-1),'bx','MarkerFaceColor',[1 1 1]);

xlim([0.5 4.5]);

axe=gca;

set(gcf, 'PaperPositionMode', 'auto');

set(axe,'FontName','arial')
set(axe,'fontsize',14)
set(gca,'TickDir','out');
set(gca,'Box','off');
set(gca,'TickLength',[0.02 0.025]);
set(gca,'XTick',[1 2 3 4])
set(gca,'XTickLabel',{'MFTs';'EPSCs'; 'Spillover'; 'Spikes'})
set(gcf,'position',[100, 200, 300, 400])
print('-depsc','-r400','figs/TOT_longpeak.eps')



figure;
hold on;
title('Peak in short period crosscorrelogram')
ylabel('crosscorrelation coefficient');
plot(MFT_ms.*0+1,MFT_ms,'ro');
plot(GEPSCS_ms.*0+2,GEPSCS_ms,'go');
plot(SPILLOVER_ms.*0+3,SPILLOVER_ms,'mo');
plot(GSPIKE_ms.*0+4,GSPIKE_ms,'bo');

for i=1:length(MFT_ms_z)
    currz=MFT_ms_z(i);
    if (currz>z_threshold)
        plot(MFT_ms_z.*0+1+zpad,MFT_ms(i),'r*');    
    end;
end;

for i=1:length(GEPSCS_ms_z)
    currz=GEPSCS_ms_z(i);
    if (currz>z_threshold)
        plot(GEPSCS_ms_z.*0+2+zpad,GEPSCS_ms(i),'g*');    
    end;
end;



for i=1:length(SPILLOVER_ms_z)
    currz=SPILLOVER_ms_z(i);
    if (currz>z_threshold)
        plot(SPILLOVER_ms_z.*0+3+zpad,SPILLOVER_ms(i),'m*');    
    end;
end;


for i=1:length(GSPIKE_ms_z)
    currz=GSPIKE_ms_z(i);
    if (currz>z_threshold)
        plot(GSPIKE_ms_z.*0+4+zpad,GSPIKE_ms(i),'b*');    
    end;
end;

%legend('GC EPSC','MFT','GC spike');

errorbar(1,mean(MFT_ms),std(MFT_ms)./sqrt(size(MFT_ms,1)-1),'rx','MarkerFaceColor',[1 1 1]);
errorbar(2,mean(GEPSCS_ms),std(GEPSCS_ms)./sqrt(size(GEPSCS_ms,1)-1),'gx','MarkerFaceColor',[1 1 1]);
errorbar(3,mean(SPILLOVER_ms),std(SPILLOVER_ms)./sqrt(size(SPILLOVER_ms,1)-1),'mx','MarkerFaceColor',[1 1 1]);
errorbar(4,mean(GSPIKE_ms),std(GSPIKE_ms)./sqrt(size(GSPIKE_ms,1)-1),'bx','MarkerFaceColor',[1 1 1]);
xlim([0.5 4.5]);
ylim([0 0.3]);

axe=gca;

set(gcf, 'PaperPositionMode', 'auto');

set(axe,'FontName','arial')
set(axe,'fontsize',14)
set(gca,'TickDir','out');
set(gca,'Box','off');
set(gca,'TickLength',[0.02 0.025]);
set(gca,'XTick',[1 2 3 4])
set(gca,'XTickLabel',{'MFTs';'EPSCs';'Spillover';'Spikes'})
set(gcf,'position',[450, 200, 300, 400])
print('-depsc','-r400','figs/TOT_shortpeak.eps')


figure;
hold on;
title('Time to peak correlation')

plot(MFT_ts.*0+2,MFT_ts,'go');
plot(GEPSCS_ts.*0+1,GEPSCS_ts,'ro');

plot(GSPIKE_ts.*0+3,GSPIKE_ts,'bo');
%legend('GC EPSC','MFT','GC spike');



errorbar(2,mean(MFT_ts),std(MFT_ts)./sqrt(size(MFT_ts,1)-1),'gx','MarkerFaceColor',[1 1 1]);

errorbar(1,mean(GEPSCS_ts),std(GEPSCS_ts)./sqrt(size(GEPSCS_ts,1)-1),'rx','MarkerFaceColor',[1 1 1]);


errorbar(3,mean(GSPIKE_ts),std(GSPIKE_ts)./sqrt(size(GSPIKE_ts,1)-1),'bx','MarkerFaceColor',[1 1 1]);
xlim([0.5 3.5]);
ylabel('Time (ms)');
axe=gca;

set(gcf, 'PaperPositionMode', 'auto');

set(axe,'FontName','arial')
set(axe,'fontsize',14)
set(gca,'TickDir','out');
set(gca,'Box','off');
set(gca,'TickLength',[0.02 0.025]);
set(gca,'XTick',[1 2 3])
set(gca,'XTickLabel',{'MFTs';'EPSCs';'Spikes'})
set(gcf,'position',[800, 200, 300, 400])
print('-depsc','-r400','figs/TOT_timepeak.eps')


figure;
hold on;
GSPIKE_xcs
plot(GCEPSC_dat(1).lags,mean(GEPSCS_xcs),'r','LineWidth',1.5);
plot(GCEPSC_dat(1).lags,mean(MFT_xcs),'g','LineWidth',1.5);
plot(GCEPSC_dat(1).lags,mean(GSPIKE_xcs),'b','LineWidth',1.5);
legend('GC-EPSCS','MFTs','GC-spikes');

%plot(GCEPSC_dat(1).lags,mean(GEPSCS_xcs)+std(GEPSCS_xcs)./sqrt(length(GCEPSC_dat)-1),'r-.');
%plot(GCEPSC_dat(1).lags,mean(GEPSCS_xcs)-std(GEPSCS_xcs)./sqrt(length(GCEPSC_dat)-1),'r-.');
%plot(GCEPSC_dat(1).lags,mean(MFT_xcs)+std(MFT_xcs)./sqrt(length(MFT_dat)-1),'g-.');
%plot(GCEPSC_dat(1).lags,mean(MFT_xcs)-std(MFT_xcs)./sqrt(length(MFT_dat)-1),'g-.');
%plot(GCEPSC_dat(1).lags,mean(GSPIKE_xcs)+std(GSPIKE_xcs)./sqrt(length(GSPIKE_dat)-1),'b-.');
%plot(GCEPSC_dat(1).lags,mean(GSPIKE_xcs)-std(GSPIKE_xcs)./sqrt(length(GSPIKE_dat)-1),'b-.');

axe=gca;
set(axe,'FontName','arial')
set(axe,'fontsize',14)
set(gca,'TickDir','out');
set(gca,'Box','off');
set(gca,'TickLength',[0.02 0.025]);
title('Average crosscorrelogram')
xlabel('time (milliseconds)');
ylabel('crosscorrelation coefficient');
print('-depsc','-r400','figs/TOT_avgXcorr.eps')


figure;
hold on;
title('correlation coefficient for spillover')
ylabel('Correlation of spillover to motion index');
plot(SPILLOVER_rs.*0+1,SPILLOVER_rs,'ro');
plot(SPILLOVER_ms.*0+2,SPILLOVER_ms,'go');

%legend('GC EPSC','MFT','GC spike');
errorbar(1,mean(SPILLOVER_rs),std(SPILLOVER_rs)./sqrt(size(SPILLOVER_rs,1)-1),'rx','MarkerFaceColor',[1 1 1]);

errorbar(2,mean(SPILLOVER_ms),std(SPILLOVER_ms)./sqrt(size(SPILLOVER_ms,1)-1),'gx','MarkerFaceColor',[1 1 1]);

xlim([0.5 2.5]);

axe=gca;

set(gcf, 'PaperPositionMode', 'auto');

set(axe,'FontName','arial')
set(axe,'fontsize',14)
set(gca,'TickDir','out');
set(gca,'Box','off');
set(gca,'TickLength',[0.02 0.025]);
set(gca,'XTick',[1 2])
set(gca,'XTickLabel',{'Long time';'short time'})
set(gcf,'position',[100, 200, 300, 400])
print('-depsc','-r400','figs/TOT_spillovercorr.eps')


figure;
hold on;
%title('Correlation of spillover to EPSC frequency')
ylabel('Correlation of spillover to EPSC frequency');
plot(SPILLOVER_spike_rs.*0+1,SPILLOVER_spike_rs,'ro');


%legend('GC EPSC','MFT','GC spike');
errorbar(1,mean(SPILLOVER_spike_rs),std(SPILLOVER_spike_rs)./sqrt(size(SPILLOVER_spike_rs,1)-1),'rx','MarkerFaceColor',[1 1 1]);

xlim([0.5 1.5]);

axe=gca;

set(gcf, 'PaperPositionMode', 'auto');

set(axe,'FontName','arial')
set(axe,'fontsize',14)
set(gca,'TickDir','out');
set(gca,'Box','off');
set(gca,'TickLength',[0.02 0.025]);
set(gca,'XTick',[1])
set(gca,'XTickLabel',{'Spillover'})
set(gcf,'position',[100, 200, 150, 400])
print('-depsc','-r400','figs/TOT_spillovercorr.eps')


figure;
title('correlation of spikes versus correlation of motion')
plot(SPILLOVER_spike_rs,SPILLOVER_rs,'ro');

