function [sumdat]=histanal(mIdx, spikes,figtitle)


tinc=1000*0.0334;


Nsamples=size(spikes,1)
window=50;


mIdx=mIdx';


%figure;



corr_mat=[];

m_spikes=[];
m_mtn=[];

lags1=0;
for startind=1:floor(window/4):(Nsamples-window-1)

    
  
curr_spikes=spikes(startind:startind+window,:)';
curr_mIdx=mIdx(startind:startind+window,:)';




m_spikes=[m_spikes; mean(curr_spikes)];
m_mtn=[m_mtn; mean(curr_mIdx)];



if startind==1
[xc1,lags1] = xcorr(curr_spikes-mean(curr_spikes),curr_mIdx-mean(curr_mIdx),'coeff');
end;


[xc3, bdu3, bdl3] = xcorrc(curr_spikes-mean(curr_spikes),curr_mIdx-mean(curr_mIdx),'coeff',200,0.99);
%[xc3, bdu3, bdl3] = xcorrc(curr_mIdx-mean(curr_mIdx),curr_mIdx-mean(curr_mIdx),'coeff',200,0.99);




cantcompute=0;
if (isnan(sum(xc3))==1)
    cantcompute=1;
end

if (cantcompute==0)

    corr_mat=[corr_mat; xc3];
end;


%hold on;
%h=stem(tinc*lags1,xc3,'r');
end;



hold on;

sm_dat=std(corr_mat)./sqrt(size(corr_mat,1)-1);
m_dat=mean(corr_mat);


[maxval,maxind]=max(m_dat);
[minval,minind]=min(m_dat);

maxt=tinc*lags1(maxind)
mint=tinc*lags1(minind)

plot(tinc*lags1,m_dat-sm_dat,'k-.');
plot(tinc*lags1,m_dat+sm_dat,'k-.');
plot(tinc*lags1,m_dat,'r','LineWidth',1.5);
%h=errorbar(tinc*lags1,mean(corr_mat),std(corr_mat)./sqrt(size(corr_mat,1)-1),'bo','MarkerFaceColor',[1 1 1]);

%plot(tinc*lags1,bdu3,'b');
%plot(tinc*lags1,bdl3,'b');

%set(h,'MarkerFaceColor','red');

axe=gca;
set(axe,'FontName','arial')
set(axe,'fontsize',14)
set(gca,'TickDir','out');
set(gca,'Box','off');
set(gca,'TickLength',[0.02 0.025]);
title(figtitle)
ylim([-0.2 0.3]);
%ylim([-0.3 1.1]);

xlabel('time (milliseconds)');
ylabel('crosscorrelation coefficient');
print('-dmeta','-r400',strcat('figs/',figtitle,'.emf'));

%figure;
%plot(m_spikes,m_mtn,'ro');
[r,p]=corrcoef(m_spikes,m_mtn);
r=r(1,2);

r

sumdat.r=r;
sumdat.r_p=p;
sumdat.maxcorr=maxval;
sumdat.maxcorrt=maxt;
sumdat.mincorr=minval;
sumdat.mincorrt=mint;
sumdat.xc=m_dat;
sumdat.lags=tinc*lags1;
%p(1,2)