
centrioles=load('IG_130712_HeLaCenpAmCherryCentrinGFP_Cdk1Inhrel_10ngmlNoc_02_5_crop02_centrioles_R3D_D3D.rtf'); 
kinetochores=load('IG_130712_HeLaCenpAmCherryCentrinGFP_Cdk1Inhrel_10ngmlNoc_02_5_crop02_kinetochores_R3D_D3D.rtf');

% text files contain coordinates x y z of centrioles of spindle poles 
% and kinetochores

% extract GM and M coordinates
GM=centrioles(1,:);
M=centrioles(2,:);

% exract individual coordinates of centrioles
GM_x1=centrioles(1,1);
GM_y1=centrioles(1,2);
GM_z1=centrioles(1,3);

M_x1=centrioles(2,1);
M_y1=centrioles(2,2);
M_z1=centrioles(2,3);

%calculates distance between the spindle poles
GM_M_dist = sqrt((GM_x1 - M_x1).^2+(GM_y1 - M_y1).^2+(GM_z1 - M_z1).^2);


% calculate distance for each coordinate (x, y, and z) between GM and M spindle
% pole and kinetochores
GM_kn=kinetochores - GM(ones(size(kinetochores,1),1),:);
M_kn=kinetochores - M(ones(size(kinetochores,1),1),:);

% calculate the overall distance (all coordinates together) for GM
% centrosome
x_GM_kn=GM_kn(:,1).^2;
y_GM_kn=GM_kn(:,2).^2;
z_GM_kn=GM_kn(:,3).^2;

GMkinetochoredistance=sqrt(x_GM_kn+y_GM_kn+z_GM_kn);

% calculate the overall distance (all coordinates together) for M
% centrosome

x_M_kn=M_kn(:,1).^2;
y_M_kn=M_kn(:,2).^2;
z_M_kn=M_kn(:,3).^2;

Mkinetochoredistance=sqrt(x_M_kn+y_M_kn+z_M_kn);

% plots distances between spindle pole and kinetochore 
figure 
plot(GMkinetochoredistance,'.')
xlabel('Kinetochore');
ylabel('Distances, um');
title('Distances between GM centrosome and kinetochores');
%saveas (gcf,'Distances between GM centrosome and kinetochores');

% plots distances between spindle pole and kinetochore 
figure 
plot(Mkinetochoredistance,'.')
xlabel('Kinetochore');
ylabel('Distances, um');
title('Distances between M centrosome and kinetochores');
%saveas (gcf,'Distances between M centrosome and kinetochores');

% plots GM vs M to kinetochore distances
figure 
plot(GMkinetochoredistance, Mkinetochoredistance,'.')
xlabel('GMkinetochoredistance, um');
ylabel('Mkinetochoredistance, um');
title('GM vs M to kinetochore distances');
%saveas (gcf,'GM vs M to kinetochore distances');

% defines cathegories which the distances will be classified into
Bins=[1:20]


% plots histogram of frequencies at which certain GM/Mkinetochoredistances
% appear
figure
hist(GMkinetochoredistance,Bins);
xlabel('Distances, um');
ylabel('Occurence, %');
title('Distribution of distances of kinetochores from GM centrosome');

% plots histogram of frequencies at which certain GM/Mkinetochoredistances
% appear

figure
hist(Mkinetochoredistance,Bins);
xlabel('Distances, um');
ylabel('Occurence, %');
title('Distribution of distances of kinetochores from M centrosome');

% plots together GM vs M distances as a line histogram
GM=hist(GMkinetochoredistance,Bins);
M=hist(Mkinetochoredistance,Bins);

figure
line(Bins, [GM;M]');
xlabel('Distances, um');
ylabel('Occurence, %');
title('Distribution of distances of kinetochores from GM vs M centrosome');
legend('GM', 'M');

% saves as .mat file Angles between a spindle pole and kinetochore pair , 
% distances between spindle pole and kinetochore pair centers,inter-kinetochore distances 
% save('centrioles.txt','kinetochores.txt','GMkinetochoredistance','Mkinetochoredistance', 'GM_M_dist');

