# Box plot all data in different concentration, SSMD score and heatmap

BoxPlot.SSMD.Heatmap <- function()
{
	# read signal
	raw.data <- read.csv("E:/HTS/Liyun/code/141210 he5_7dpf plate3 XL880 combined.csv");
	# Roy Signal
	Roy.signal <- raw.data[raw.data[,13] == "Ntg", ];
	Roy.signal <- Roy.signal[,4:12];
	Roy.mean <- mean(as.numeric(apply(Roy.signal, 1, max)));
	Roy.sd <- sd(as.numeric(apply(Roy.signal, 1, max)));
	
	# Back Ground Parameters 
	bg.ratio <- Roy.mean+3*Roy.sd;
		
	# assign the data to different group
	signal.all <- as.matrix(raw.data[ ,4:12]);
	max.signal <- apply(signal.all, 1, max);
	signal.all[signal.all<=bg.ratio] <- 0;
	well.signal <- apply(signal.all, 1, sum);
	well.signal <- as.numeric(apply(cbind(well.signal, max.signal), 1, max));

	# signal in different concertration
	s.con <- well.signal[raw.data[,13] %in% c("+", "-", 4,2,1,0.5,0.25,0.125)];
	s.lab <- raw.data[raw.data[,13] %in% c("+", "-", 4,2,1,0.5,0.25,0.125), 13];
	s.all <- data.frame(s.con,s.lab);
	s.pos <- well.signal[raw.data[,13]=="+"];
	s.neg <- well.signal[raw.data[,13]=="-"];
	s4 <- well.signal[raw.data[,13]==4];
	s2 <- well.signal[raw.data[,13]==2];
	s1 <- well.signal[raw.data[,13]==1];
	s0.5 <- well.signal[raw.data[,13]==0.5];
	s0.25 <- well.signal[raw.data[,13]==0.25];
	s0.125 <- well.signal[raw.data[,13]==0.125];
	
	# Different Concentration Signal Boxplot
	png("E:/HTS/Liyun/code/figure1.png", width=1800, height=960);
	par(fig=c(0.02,0.31,0,1), font=2, lwd=3);
	boxplot.signal <- data.frame(rbind(cbind(s4/bg.ratio, rep("A", length(s4))), cbind(s2/bg.ratio, rep("B", length(s2))), cbind(s1/bg.ratio, rep("C", length(s1))), cbind(s0.5/bg.ratio, rep("D", length(s0.5))), cbind(s0.25/bg.ratio, rep("E", length(s0.25))), cbind(s0.125/bg.ratio, rep("F", length(s0.125))), cbind(s.neg/bg.ratio, rep("G", length(s.neg)))));
	boxplot.signal <- data.frame(as.numeric(as.character(boxplot.signal[,1])), boxplot.signal[,2]);
	colnames(boxplot.signal) <- c("signal", "label");
	boxplot(signal ~ label, boxplot.signal, notch=TRUE, outline = FALSE, whisklty = 0, staplelty = 0, ylim=c(0,16), ylab="", names=rep("", 7), font.axis=2, font.lab=2, cex.axis=2, cex.lab=2, cex.main=2, lwd=3, yaxt='n', boxwex=0.5);
	axis(1, at=c(1:7), labels=c("4","2","1","0.5","0.25","0.125","(-)"), font=2, cex.axis = 2, lwd=3, las=3);
	axis(2, cex.axis = 2, lwd=3, font=2);
	mtext("YFP", side=2, line=4, cex=2);
	s.median <- c(median(s4/bg.ratio), median(s2/bg.ratio), median(s1/bg.ratio), median(s0.5/bg.ratio), median(s0.25/bg.ratio), median(s0.125/bg.ratio));
	library('pracma');
	rank.polyfit <- polyfit(c(1:6), s.median, 2);
	rank.polyfit.value <- polyval(rank.polyfit, c(0:250)*0.02+1);
	lines(c(0:250)*0.02+1, rank.polyfit.value, lwd=3);

	# Calculate SSMD score
	SSMD.pos.log <- (gamma(length(s.pos)/2-1/2)/gamma(length(s.pos)/2-1))*sqrt(2/(length(s.pos)-1))*mean(log(s.pos, base=2)-median(log(s.neg, base=2)))/sd(log(s.pos, base=2)-median(log(s.neg, base=2)));
	SSMD.neg.log <- (gamma(length(s.neg)/2-1/2)/gamma(length(s.neg)/2-1))*sqrt(2/(length(s.neg)-1))*mean(log(s.neg, base=2)-median(log(s.neg, base=2)))/sd(log(s.neg, base=2)-median(log(s.neg, base=2)));
	SSMD.s4.log <- (gamma(length(s4)/2-1/2)/gamma(length(s4)/2-1))*sqrt(2/(length(s4)-1))*mean(log(s4, base=2)-median(log(s.neg, base=2)))/sd(log(s4, base=2)-median(log(s.neg, base=2)));
	SSMD.s2.log <- (gamma(length(s2)/2-1/2)/gamma(length(s2)/2-1))*sqrt(2/(length(s2)-1))*mean(log(s2, base=2)-median(log(s.neg, base=2)))/sd(log(s2, base=2)-median(log(s.neg, base=2)));
	SSMD.s1.log <- (gamma(length(s1)/2-1/2)/gamma(length(s1)/2-1))*sqrt(2/(length(s1)-1))*mean(log(s1, base=2)-median(log(s.neg, base=2)))/sd(log(s1, base=2)-median(log(s.neg, base=2)));
	SSMD.s0.5.log <- (gamma(length(s0.5)/2-1/2)/gamma(length(s0.5)/2-1))*sqrt(2/(length(s0.5)-1))*mean(log(s0.5, base=2)-median(log(s.neg, base=2)))/sd(log(s0.5, base=2)-median(log(s.neg, base=2)));
	SSMD.s0.25.log <- (gamma(length(s0.25)/2-1/2)/gamma(length(s0.25)/2-1))*sqrt(2/(length(s0.25)-1))*mean(log(s0.25, base=2)-median(log(s.neg, base=2)))/sd(log(s0.25, base=2)-median(log(s.neg, base=2)));
	SSMD.s0.125.log <- (gamma(length(s0.125)/2-1/2)/gamma(length(s0.125)/2-1))*sqrt(2/(length(s0.125)-1))*mean(log(s0.125, base=2)-median(log(s.neg, base=2)))/sd(log(s0.125, base=2)-median(log(s.neg, base=2)));
	SSMD.log <- c(SSMD.s4.log, SSMD.s2.log, SSMD.s1.log, SSMD.s0.5.log, SSMD.s0.25.log, SSMD.s0.125.log, SSMD.neg.log, SSMD.pos.log);
	
	#  Plot SSMD score
	par(fig=c(0.33,0.64,0,1), font=2, lwd=3, new=TRUE)
	plot(SSMD.log, ylim=c(-2,3), xlim=c(0.5, 8.5), pch='*', cex=4, xaxt='n', yaxt='n', ylab='', xlab='');
	axis(1, at=c(1:8), labels=c("4","2","1","0.5","0.25","0.125","(-)", "(+)"), font=2, cex.axis = 2, lwd=3, las=3);
	axis(2, at=c(-4:6)*0.5, labels=c(-4:6)*0.5 , cex.axis = 2, lwd=3, font=2);
	abline(h=0, col="black", lwd=3, lty=3);
	abline(h=c(-0.25, 0.25), col="blue", lwd=3, lty=3);
	abline(h=c(-0.5, 0.5), col="gold", lwd=3, lty=3);
	abline(h=c(-1, 1), col="pink", lwd=3, lty=3);
	abline(h=c(-1.645, 1.645), col="green", lwd=3, lty=3);
	abline(h=c(-2, 2), col="red", lwd=3, lty=3);
	mtext("SSMD Score", side=2, line=4, cex=2);
		
	# Heatmap
	s.colorcode <- s.con[1:96]/(median(s.con[1:96])+1.5*IQR(s.con[1:96]));
	s.colorcode[s.colorcode>1] <- 1;
	s.x <- 1:96 %% 12;
	s.x[s.x==0] <- 12;	
	s.y <- ceiling(1:96/12);
	
	# colorRamp produces custom palettes, but needs values between 0 and 1
	colorFunction <- colorRamp(c("black", "tan4", "darkgoldenrod"));
	
	# Apply colorRamp and switch to hexadecimal representation
	s.colorcode.matrix <- colorFunction(s.colorcode);
	sColors <- rgb(s.colorcode.matrix, maxColorValue=255);

	# Let's plot
	par(fig=c(0.61,0.99,0.3,1), font=1, lwd=2, new=TRUE);
	plot(x=s.x*1.5, y=(9-s.y)*0.94, col=sColors, pch=19, cex=8.3, xlim=c(0.5,18), ylim=c(0.5,10.5), bty="n", xaxt='n', yaxt="n", xlab='', ylab='');
	dev.off();
}
