function ai_total=Process_Roseplot_Junjie(positive_quadrant,data_file)
load(data_file);
%% ssurvival plot
nx = []; %records all x in real trajectories
ny = []; %all y
nt = []; %all FRM
nv = [];
nvx = [];
nvy = [];
for iTS_i = 1:size(iTS,1)
    iTS_survival_curr=trace_survival(iTS{iTS_i},F.XS,F.YS);
        nx = [nx
        F.XS(iTS_survival_curr)];
        ny = [ny
        F.YS(iTS_survival_curr)];
        nt = [nt
        F.FRM(iTS_survival_curr)];
        nv = [nv
        F.RDc(iTS_survival_curr)];
        nvx = [nvx
            F.DX(iTS_survival_curr)];
        nvy = [nvy
            F.DY(iTS_survival_curr)];
    
end
%% AI_temporal_JunjieLuo_new
tic
[snt I] = sort(nt);
snx = nx(I);
sny = ny(I);
snv = nv(I);
% snvx = nvx(I);
% snvy = nvy(I);
%everything above is to sort the huge vectors by their frame number, which
%will facilitate temporal analysis of index.

s = size(snt,1);
t = max(snt);
[sn_quadrant,sn_angle]=find_quadrant2(snx,sny);

count_quadrant=zeros(4, max(snt));
mv_quadrant=zeros(4,max(snt));
for i = 1:s
    frm = snt(i);
%     if snv(i)>0.01
    if ~isnan(sn_quadrant(i))
        count_quadrant(sn_quadrant(i),frm)=count_quadrant(sn_quadrant(i),frm)+1;
        mv_quadrant(sn_quadrant(i),frm)=mv_quadrant(sn_quadrant(i),frm)+snv(i);
    end
%     end
end
%plot(ar);
% % figure, plot(count_quadrant')
% % legend({'1', '2', '3', '4'})

% % figure, 
for quadrant_i=1:4
%     subplot(2,2,quadrant_i)
% % hold on
is_quadrant_curr=sn_quadrant==quadrant_i;
% % plot(snx(is_quadrant_curr),'r.')
% % plot(sny(is_quadrant_curr),'.')
% % title(quadrant_i)
% % legend({'x','y'})
end

counts = zeros(4, t-1000);
mvs = zeros(1, t-1000);
%counts and mvs are count and mv smoothed over a window of 1000 frames

for i = 1:t-1000
    counts(:,i)=nansum(count_quadrant(:,i:i+1000),2);
    mvs(i) = nansum(mv_quadrant(positive_quadrant,i:i+1000));
end
negative_quadrant=[1 2 3 4]~=positive_quadrant;
ai = (counts(positive_quadrant,:)-mean(counts(negative_quadrant,:),1))./ ...
     (counts(positive_quadrant,:)+mean(counts(negative_quadrant,:),1));%%%%%%%
mvs = mvs./counts(positive_quadrant,:); %deviding velocity sums by counts gives mean velocity
% N = counts(1,i)+counts(2,i);
% p = counts(1,i)./N;
% aisd = 6./(2*p+1).^2.*sqrt(p.*(1-p)./N);
% N and p were used to estimate standard deviation of attraction index, but
% I ended up using multiple runs and directly calculate mean and sd at
% every time point.
figure;
plot(mvs);
xlabel('Frames')
ylabel('Speed, pixels/frame')
title('Speed')


figure;
plot(ai, 'b');
title('Attraction index')
xlabel('Frames')
ylabel('AI')
set(gca, 'YLim',[-1 1]);

mean(ai)
count_total=nansum(count_quadrant,2);
ai_total = (count_total(positive_quadrant,:)-mean(count_total(negative_quadrant,:),1))./ ...
           (count_total(positive_quadrant,:)+mean(count_total(negative_quadrant,:),1))%%%%%%%
%attraction_index = (sum(count(1,4500:12500))-sum(count(2,4500:12500))/3)./(sum(count(1,4500:12500))+sum(count(2,4500:12500))/3)
toc

%[theta_hist,theta_out]=
% % figure,hist(sn_angle,pi*(-1:0.02:1));

figure,rose(sn_angle,pi*(-1:0.02:1)) 
title('Distribution of flies in the arena')



end

% function iTS_survival=trace_survival(iTS,XS,YS)
% Dxy_threshold=0.15;
% window_width=100;
% 
% xy=XS(iTS)+1i*YS(iTS);
% Dxy=xy(2:end)-xy(1:end-1);
% is_stop=(abs(Dxy)<Dxy_threshold);
% 
% if length(is_stop)<window_width
%     if all(is_stop)
%         iTS_survival=[];
%     else
%         iTS_survival=iTS;
%     end
% else
%     is_survival=true(size(iTS));
%     for window_i=1:(length(is_stop)-window_width+1)
%         is_stop_curr=is_stop(window_i-1+(1:window_width));
%         if all(is_stop_curr)
%             is_survival(window_i+(1:window_width))=0;
%         end
%     end
%     iTS_survival=iTS(is_survival);
% end
% end
