function[temp]=SingleTrajectoryViewer(temp_fn, n, flag, k)

% temp_fn is the path to the data file

% n is the number or a range of numbers of trajectories that you want to
% view

% flag=0 means that trajectories will be displayed consequtively; flag=1
% means that all trajectories will be displayed together

% k sets the cutofff threshold: only trajectories that have >k datapoints
% will be displayed.

% example of use:
%
%  SingleTrajectoryViewer_250513('C:\Users\C1X-2.mat', 1:100, 0, 200)
%
% opens file C1X.mat, shown trajectories 1 to 100 one-by-one, skipping the
% ones that have less than 200 datapoints.
%
% If you would like to select trajectories by clicking on them, set the n
% large, i.e. n=1:100000, to make sure that the maximum of n is larger than
% the number of trajectories in the dataset.
  
global fn
fn=temp_fn;
load (fn)

x=F.XS; y=F.YS;
v=sqrt(F.DX.^2+F.DY.^2);
w=abs(F.DTH);

% create the trajectory ID's to display
if nargin<2
    n=1:10;
end;

if nargin<3
    flag=0;
end;

if nargin<4
    k=100;
end;

%====% code between the lines is copied and modified from  Process_Roseplot_Junjie

nt = []; %all FRM
nx=[];
ny=[];

for iTS_i = 1:size(iTS,1)
    iTS_survival_curr=trace_survival(iTS{iTS_i},F.XS,F.YS);
        nx = [nx
        F.XS(iTS_survival_curr)];
        ny = [ny
        F.YS(iTS_survival_curr)];
        nt = [nt
        F.FRM(iTS_survival_curr)];
        
end

[snt I] = sort(nt);
snx = nx(I);
sny = ny(I);
%======

[~,~,fit_params]=find_quadrant2(snx,sny);% fit_params=[para_fit R dR center_dis];
closereq;

xc=fit_params(1);
yc=fit_params(2);
ang=fit_params(3);
R=fit_params(4);
dR=fit_params(5);
centre_dis=fit_params(6);

%remove datapoints on the edges of the arena - points to remove are in
%ind_rem

% centres of the four circles
circ=[xc+centre_dis*sin(ang)    yc+centre_dis*cos(ang);
      xc-centre_dis*sin(ang)    yc-centre_dis*cos(ang);
      xc-centre_dis*cos(ang)    yc+centre_dis*sin(ang);
      xc+centre_dis*cos(ang)    yc-centre_dis*sin(ang)];
  
% find indexes of the points (ind_rem) along the edges, and remove these points 
ind_rem=[];


for i=1:4
    
    x_loc=x-circ(i,1);
    y_loc=y-circ(i,2);
    
    [~,ro_loc]=cart2pol(x_loc, y_loc);
%     keyboard
    ind_rem=[ind_rem; find(ro_loc<=R+dR)];
   
end;

%create array of all useful indexes, inds
inds=cell2mat(iTS);
inds_cl=setdiff(inds, ind_rem);
% keyboard
% plot "good" datapoins in grey 
figure('WindowStyle', 'docked')

% this command plots grey dots
plot(x(inds_cl(1:1:end)),y(inds_cl(1:1:end)),'.', 'MarkerEdgeColor', [0.5 0.5 0.5], 'MarkerSize',3)
axis equal


hold on
axis equal
sy{1}='Press Enter to continue, "b" to go step back,';
sy{2}='or click on a point to highlight trajectory';
ylabel(sy)
s{1}=fn;
s{2}='Start of trajectory is blue, end - red';
title(s,'Interpreter', 'none')
% FormatAndSaveFig('RemovedAndRemainedDatapoints');

  

set(gca,'NextPlot', 'add')

i=n(1); j=1;

b=[];


while i<=n(end)

    inds=intersect([iTS{i}], inds_cl);
    x_tr=x(inds);
    y_tr=y(inds);
    
    if length(x_tr)>k
    trajectory_length=length(x_tr)/30    
    cmap=buildcmap(1:length(x_tr));
    h_loc=[]; hold on;
   for loc_ind=1:length(x_tr)
  h_loc(loc_ind)=plot(x_tr(loc_ind),y_tr(loc_ind),'.','MarkerEdgeColor', cmap(loc_ind,:));
  end;
    
    
    if ~isempty(x_tr)
   h_loc1=plot(x_tr(1), y_tr(1), 'ob');
   h_loc2=plot(x_tr(end), y_tr(end), 'or');
    end;
    
    if flag==0 
        s{3}=['Trajectory number ', num2str(i)];
        title(s,'Interpreter', 'none')
        [p, q, b]=myginput(1,'arrow')
        
        if b==98 % go back
            j=j-2;
        end;
            
        if b==1 % a point was clicked on the figure. Show trajectory for that point

            [~,ind_f]=min(sqrt((x(inds_cl)-p).^2+(y(inds_cl)-q).^2));
            a=cellfun(@(x) find(x==inds_cl(ind_f)), iTS,'UniformOutput', false);

            for l=1:size(a,1)
                if ~isempty(a{l})
                    ind_tr=l
                end;
            end;
            
            j=j; i=ind_tr;
        else j=j+1; i=n(j);
        end;
            
            
        delete(h_loc)
        if ~isempty(x_tr)
%             keyboard
            delete(h_loc1);
            delete(h_loc2);
        end;
    end;
    
    elseif b==98
        j=j-1; i=n(j);
    else 
        j=j+1; i=n(j);
    end;

end;


