function rtC1procesome(dafs, dirsraw, dirszed)

%%% reserved : S, F, D

initdir = pwd;

nfiles = size(dafs,2);
for f=1:nfiles
    workdir = dirszed{f};
    if ~exist(workdir)
        mkdir(workdir);
    end;
    cd(workdir);

    datadir = dirsraw{f};
    
    % obtain sorted S F, raw D structs
%     if isempty(varargin)
   % [datadir dafs{f}]
        [S,F] = read_raw_dataC1(datadir,dafs{f});
%     else
%         S=varargin{1};
%         F=varargin{2};
%         D=varargin{3};
%         T=varargin{4};
%     end;

    % compute additional params necessary for data quality ctrl
    S.STARTX = zeros(size(S.ID));
    S.ENDX = zeros(size(S.ID));
    S.STARTY = zeros(size(S.ID));
    S.ENDY = zeros(size(S.ID));
    
    [iSB, iFB] = find_first(S.ID, F.ID, S.FRM1, F.FRM);
    S.STARTX = F.X(iFB);
    S.STARTY = F.Y(iFB);
    iFE = iFB + S.FRMTOT - 1;
    S.ENDX = F.X(iFE);
    S.ENDY = F.Y(iFE);
    
    % make cuts in S
    %framesMin = 60;
    framesMin = 45;
    longMax = 3;
    hood = 2;%weights associated with discriminating noise from movement
    
    ai = [S.LONG abs(S.STARTX - S.ENDX) abs(S.STARTY - S.ENDY)];
    %La flags blobs that have not moved during the entire extent of their
    %trajectories.
    La = ((ai(:,2) < (hood * ai(:,1))) & (ai(:,3) < (hood * ai(:,1))));
  
    % L vector for survivors, in full S dimensions
    tL = (S.FRMTOT > framesMin) & (S.LONG < longMax) & ~La;
    % ids of surviving trajectories
    aliveIDs = S.ID(tL);
    % indices into full F-space for begin frames and end frames of survivors
    aiFB = iFB(tL);
    aiFE = iFE(tL);

    % assemble index subsets of F struct corresponding to each trajectory
    iT = cell(size(aiFB));
    for i=1:size(aiFB)
        iT{i} = [aiFB(i):aiFE(i)]';
    end;
    clear i;

    % smooth data and compute derivatives
    swin = 5;
    [iTS, F.DT, F.XS, F.YS, F.DX, F.DY, F.DTH, F.DDX, F.DDY, F.DDTH, F.THDc, F.RDc, F.THDDc, F.RDDc] = ...
        compall_gradsC1(iT, F.T, F.X, F.Y, swin);
    % classify stim events:	   
    
    % save current vars before moving on
    curout = strcat(workdir,dafs{f});
    save(curout, 'S', 'F', 'iT', 'iTS');
    clear('S', 'F', 'aiFB', 'aiFE', 'tL', 'iT', 'iTS');
    
    progress = sprintf('done with %s; %d of %d.\n', dafs{f}, f, max(size(dafs)));
    disp(progress);
end;

%cd(initdir);
cd(workdir)%changed 021206
return;