%%
%% Existence of oscillations
%%
close all;
clear;

N=3;
T_a = [8]; % mRNA half-life (min)
T_b = 90; % protein half-life (min)
T_d = 5:0.1:45; %Td (min)
K = 5; %MM constant
nu = 2.0; %Hill coefficient

%% simulation parameter
simTd = 5:0.1:45;
c = 0.5; beta = 0.4;
plasmid_conc = [0.5,1.0,5]; %nM
cbeta1 = plasmid_conc(1)*c*beta*ones(1,length(simTd)); %c*beta used for simulations
cbeta2 = plasmid_conc(2)*c*beta*ones(1,length(simTd));
cbeta3 = plasmid_conc(3)*c*beta*ones(1,length(simTd));

%
%% main code
%%
a = log(2)./T_a;
b = log(2)./T_b;

Q = @(a,b,d) sqrt((a+d)*(b+d))/((a+b)/2+d);
W = @(N,a,b,d) 2*(-cos(pi/N) + sqrt((cos(pi/N))^2 + (Q(a,b,d))^2*(sin(pi/N))^2)) / (Q(a,b,d)^2*(sin(pi/N))^2);

boundary = zeros(length(T_d),length(T_a)); %boundary = c*beta (TX*TL)

for i=1:length(a)
    for j=1:length(T_d)
        d = log(2)/T_d(j);
        Wval = W(N,a(i),b,d);
        if (nu > Wval)
            boundary(j,i) = K* nthroot(Wval/(nu-Wval),nu)*nu/(nu-Wval) *(a(i)+d)*(b+d);
        else
            boundary(j,i) = inf;
        end
    end 
end

figure;
plot(T_d, boundary,'k');
fill([T_d, T_d(length(T_d)), T_d(1)], [boundary', 1.1, 1.1], [0.85,0.85,0.85]);
hold on;
plot(simTd, cbeta1,'--r');
hold on;
plot(simTd, cbeta2,'--b');
plot(simTd, cbeta3,'--g');


xlabel('Td (min)');
ylabel('TX*TL rate (c\beta)');
xlim([T_d(1), T_d(length(T_d))]);
ylim([0,1.1]);



