%%
%% equilibrium point of ring oscillators
%%
function eq = equilibrium_point(N, Rsq, K, nu)

%note that p_i is normalized by K_i

fmap = @(R2,K,nu,x) R2/(1 + (x/K)^nu);
eps = 1e-8;
range = [0,1e6]; %p_N

while (abs(range(2) - range(1)) > eps) %equilibrium search with bisection algorithm
    cur = mean(range); % p_N protein conc.
    mapped = cur;
    for i=1:N        
        if(i >= 2) mapped = fmap(Rsq(i), K(i), nu(i), mapped); %starting from p_2 = ...
        else mapped = fmap(Rsq(1), K(1), nu(1), mapped); %p_1 = ...
        end
    end
    
    if(mapped < cur) range(2) = cur;
    else range(1) = cur;
    end
end

eq = zeros(N,1); %protein equilibrium

eq(N) = mean(range);
eq(1) = fmap(Rsq(1), K(1), nu(1), eq(N));
for i=2:N-1
    eq(i) = fmap(Rsq(i),K(i),nu(i),eq(i-1));
end
end
