% IHC_GFP_extract

% This script uses previously extracted ROI information for individual cells in a 3D confocal
% stack (in the form of an excel file where columns represent individual 
% cells and rows represent mean integrated intensity for each slice in a 
% stack) in order to 1) determine a slice number representing the 
% maximum integrated intensity for every ROI represented in the field of
% view and 2) return the mean integrated intensity value for the
% corresponding signal to be quantified (e.g. BMAL immunoreactivity).


%% import the channel to be analyzed
clear
[fileName, pathName] = uigetfile('*.xlsx', 'Select the .xlsx file', path);
data1 = importdata([pathName fileName]);
signal=data1.Sheet1;

%% import the gfp channel

[fileName, pathName] = uigetfile('*.xlsx', 'Select the .xlsx file', path);
data2 = importdata([pathName fileName]);
gfp=data2.Sheet1;

%% extract max gfp signal

for i = 1:length(gfp(1,:))
    maxgfp(i) = max(gfp(:,i))
end

%% determine slice position corresponding to max gfp signal

for i=1:length(gfp(1,:))
    gfp_position(i) = find (gfp(:,i)==maxgfp(i))
end

%% Extract peak signal from channel to be analyzed based on max GFP position

for i=1:length(gfp(1,:))
    pos = gfp_position(i)
    solo_col = signal(:,i)
    max_signal = solo_col(pos)
    signal_max(i) =  max_signal
end

%% Search for true signal max in local area

for i=1:length (gfp(1,:))
    pos = gfp_position(i)
    solo_col = signal(:,i);
    range = solo_col((pos-4):(pos));
    max_range = max(range)
    true_peak(i) = max_range
end

true_peak = true_peak'

%% Determine slice position of new true peak signal values

for j=1:length(gfp(1,:))
   new_sig_position(j) = find (signal(:,j)==true_peak(j))
end

new_sig_position = new_sig_position'




