// Michelle J

// File directory
// Search for lif subfiles and iterate through them 
// Get parent directory of lif file
// If there are three channels (C0 = nothing, C1 = eyfp, C2 = cfos)
// If there are two channels (C0 = eyfp, C1 = cfos)
// Pre-processing the channels:
// 1) split the channels
// 2) Detects the number of channels and adjust the LUT for eyfp and cfos
// 3) merges the channels so that eyfp is always channel 1 and cfos is always channel 2
// 4) Saves as a tiff file


#@ string(value = '.lif', persist = false, label = "File ext", description = "Image directory to loop through. Can have subfolders.") ext 

setBatchMode(true);

// Recursively lists the files in a user-specified directory.
 dir = getDirectory("Choose a Directory ");
 count = 1;
 processFolder(dir); 

 function processFolder(dir) {
    list = getFileList(dir);
    
    for (i=0; i<list.length; i++) {
       if (endsWith(list[i], "/"))
          processFolder(""+dir+list[i]);
       else
          if (endsWith(list[i], ext)){
          	print((count++) + ": " + dir + list[i]);
          	path = dir + list[i];
          	processFile(dir, list[i]);
          }          
    }
 }

function processFile(dir, name) {

	// Prints file
	print("Processing: " + dir + name);

	// Get file name minus extension
	 dir = replace(dir, "\\", "/");
	 dotIndex = indexOf(name, ".");
     name = substring(name, 0, dotIndex); 

	// Image path
	id = dir + name + ext;

	// Get last image in series & import with Bio-Formats Importer
	run("Bio-Formats Macro Extensions");
	Ext.setId(id);
	Ext.getCurrentFile(file);
	Ext.getSeriesCount(seriesCount);
	run("Bio-Formats Importer", "open=[" + id + 
    	      	"] autoscale color_mode=Composite rois_import=[ROI manager] view=Hyperstack stack_order=XYCZT stitch_tiles series_list=" + seriesCount);

	// Check number of channels & split
	getDimensions(w, h, channels, slices, frames);
	print("channels:" + channels);
	
	if (channels > 1) {
		run("Split Channels");
		// Temp
			 list = getList("image.titles");
		  if (list.length==0)
		     print("No image windows are open");
		  else {
		     print("Image windows:");
		     for (i=0; i<list.length; i++)
		        print("   "+list[i]);
		  }
		 print("");
		 // End of temp
		
			if (channels > 2){
				//__________________ C2 = eyfp, C3 = cfos ___________________
				
				// ______ Process eyfp ________
				//selectWindow("C2-" + id + " - " + name + "M");
				//selectWindow("C2-" + id );
				selectWindow(list[1]);
				print(list[1]);
				run("Green");
				eyfp_title = getTitle();
		
				// ______ Process cfos ________
				//selectWindow("C3-" + id + " - " + name + "M");
				//selectWindow("C3-" + id );
				selectWindow(list[2]);
				print(list[2]);
				run("Red");
				cfos_title = getTitle();
				run("Merge Channels...", "c1=["+ eyfp_title + "] c2=[" + cfos_title + "] create");
				saveAs("Tiff", dir + name +  ".tif");
				
				
			} else if (channels == 1) {
		
				//__________________ C1 = eyfp, C2 = cfos ___________________
				
				// ______ Process eyfp ________
				//selectWindow("C1-" + id + " - " + name + "M");
				//selectWindow("C1-" + id );
				selectWindow(list[0]);
				print(list[0]);
				run("Green");
				eyfp_title = getTitle();
		
				// ______ Process cfos ________
				//selectWindow("C2-" + id + " - " + name + "M");
				//selectWindow("C2-" + id );
				selectWindow(list[1]);
				print(list[1]);
				run("Red");
				cfos_title = getTitle();
				run("Merge Channels...", "c1=["+ eyfp_title + "] c2=[" + cfos_title + "] create");
				saveAs("Tiff", dir + name +  ".tif");
				
			} 	
	} else {
		// __________________ C1 = cfos __________________________
		
		run("Red");
		cfos_title = getTitle();
		saveAs("Tiff", dir + name +  ".tif");
	}
	print("Saved image as '", name +  ".tif'");
	close("*") ;
}

















