// Michelle J
// 03.27.2023
// File directory
// Search for slice name based on the truncating a propriety image file format
// Get parent directory of lif file
// If there are three channels (C0 = nothing, C1 = eyfp, C2 = cfos)
// If there are two channels (C0 = eyfp, C1 = cfos)
// Pre-processing the channels:
// 1) split the channels
// 2) Detects the number of channels and adjust the LUT for eyfp and cfos
// 3) merges the channels so that eyfp is always channel 1 and cfos is always channel 2
// 4) Saves as a tiff file


#@ string(value = '.lif', persist = false, label = "File ext of file to search for matching tif name", description = "Unique extension to find tiff file of slice. E.g. Truncating '.lif' from 325_1_1.lif allows identification of `325_1_1.tif") ext 
#@ Double(value=0.35, persist = true, label = "Contrast saturation", description = "The default is 0.35 contrast based on sample images") sat 


setBatchMode(true);

// Recursively lists the files in a user-specified directory.
 dir = getDirectory("Choose a root directory to process. Can contain subfolders.");
 count = 1;
 processFolder(dir); 

 function processFolder(dir) {
    list = getFileList(dir);
    
    for (i=0; i<list.length; i++) {
       if (endsWith(list[i], "/"))
          processFolder(""+dir+list[i]);
       else
          if (endsWith(list[i], ext)){
          	print((count++) + ": " + dir + list[i]);
          	path = dir + list[i];
          	processFile(dir, list[i]);
          }          
    }
 }

function processFile(dir, name) {

	// Prints file
	print("Processing: " + dir + name);

	// Get file name minus extension
	 dir = replace(dir, "\\", "/");
	 dotIndex = indexOf(name, ".");
     name = substring(name, 0, dotIndex); 

	// Image path
	id = dir + name + '.tif';
	open(id);
	tif_title = getTitle();

	// Make composite image and turn into MAX z-projection
	run("Make Composite");
	run("Z Project...", "projection=[Max Intensity]");

	// Select the MAX Z-projection
	selectWindow("MAX_" + tif_title );
	max_title = getTitle();

	// Flatten the image and enhance the contrast
	run("Flatten");
	run("16-bit");
	run("Enhance Contrast", "saturated="+sat);
	
	// Save the image
	saveAs("Tiff", dir + max_title);
	print("Saved image as '", max_title);
	close("*") ;
}




