// Michelle J
// 06.09.2023
// Directions: First choose the proprietary extension for your images. The following macro will parse through all subdirectories of a root directory and 
// look for this extension to get all unique image names (slice names) within that root folder.
// If your images are save as tifs, don't use tifs as your extension. Just create an empty file in a text editor and save the same image name with a unique extension like '.lif'
// Input: File ext, the  file extension that contains the image name (typically .lif file; .tif is not used because multiple images are stored as tifs). 
// Output: Tiff of segmented output saved as "Fast_G_eYFP_LabelImage.tif" 
//          in the working directory & segmentation counts saved as txt files in the image folder.


#@ string(value = '.lif', persist = true, label = "File ext", description = "Choose the file extension to get the base image name from. (.lif recommended)") ext 
#@ string(value = 'C1', persist = true, label = "Channel", description = "Channel of the tiff image that will be segmented. e.g. `C1`, `C2`, `C3`, etc... ") channel 
#@ Float   (value = 0.005, label="Brightness threshold (fraction of brightest pix)", style="slider", min=0.001, max=0.02, stepSize=0.001, "format:#.###", description = "Fraction of brightest pixels to use. Pixels brighter than this threshold are used as seed during a watershedding step.") thresh
//#@ Float(value = 0.005, persist = true, label = "Brightness threshold (fraction of brightest pix)", "format:#.###", description = "Fraction of brightest pixels to use. Pixels brighter than this threshold are used as seed during a watershedding step.") thresh
#@ Boolean (value=true, label = "Save segmentation .tif?", description ="Yes, to check quality. No, to save space.", persist=true) SaveSegBinary
#@ Boolean (value=true, label = "Save log output?", description ="Save the log output file to the image folder directory.", persist=true) SaveLog
#@ Boolean (value=true, label = "batchmode", description ="Process in batchmode (recommended)", persist=true) BatchMode

setBatchMode(BatchMode);
// Recursively lists the files in a user-specified directory.


 dir = getDirectory("Choose a Directory ");
 count = 1;
 processFolder(dir, thresh, channel); 

 function processFolder(dir, thresh, channel) {
    list = getFileList(dir);
    
    for (i=0; i<list.length; i++) {
       if (endsWith(list[i], "/"))
          processFolder(""+dir+list[i], thresh, channel);
       else
          if (endsWith(list[i], ext)){
          	print((count++) + ": " + dir + list[i]);
          	path = dir + list[i];
          	processFile(dir, list[i], thresh, channel);
          }          
    }
 }


function processFile(dir, name, thresh, channel) {

	// Prints file
	print("Processing: " + dir + name);

	// Get file name minus extension
	 dir = replace(dir, "\\", "/");
	 dotIndex = indexOf(name, ".");
     name = substring(name, 0, dotIndex); 
	 s = getTime();

	// Multichannel Tiff Image path
	id = dir + name + '.tif';

	print(id);
	if (File.exists(id) == 0) {
		print("File doesn't exist! trying alternate name...");
	 	sliceIndex = indexOf(name, "_");
	 	name = substring(name, 0, sliceIndex + 1) + "S" + substring(name, sliceIndex + 1, lengthOf(name));
	 	
	 	id = dir + name + '.tif';
	 	print(id);
	}
	 	
	open(id);
	Stack.getDimensions(width, height, channels, slices, frames) ;
	print("Channels: "+channels);
	
	originalImage = getTitle();
	dir = getInfo("image.directory");
	imageTitle = split(getTitle(),".");
	imageName = imageTitle[0];

	// Getting the original image 
	selectWindow(originalImage);

	// Split the channels and duplicate eyfp channel
	if (channels > 1){
		run("Split Channels");
	} else {
		rename(channel +"-" + imageName + ".tif");
	}
	
	selectWindow(channel + "-" + imageName + ".tif");
	run("Duplicate...", "duplicate");
	selectWindow(channel + "-" + imageName + "-1.tif");
	//selectWindow("C2-" + imageName + ".tif");
	//close();

	// Run background subtractions and gaussian blur on eyfp channel
	run("Subtract Background...", "rolling=15 stack");
	print("Done background subtraction");
	run("Gaussian Blur...", "sigma=4.00 scaled stack");
	print("Done Gaussian Blur");
	run("Invert", "stack");
	

	// Select the 0.3 percent brighted pixels in eyfp channels
	hist = stackHistogram(256);  // user-defined function
	countTotal = arraySum(hist); // user-defined function
	count = hist[0];
	p = 0;       
	while (count/countTotal < thresh) {
		p++;
		count += hist[p];
	}
	print("Threshold = " + p);	
	
	selectWindow(channel + "-" + imageName + "-1.tif");
	//run("Duplicate...", "duplicate");
	//run("Duplicate...");
	run("Duplicate...", "title=" + channel + "-" + imageName + "-2.tif duplicate");
	selectWindow(channel + "-" + imageName + "-2.tif");
	setOption("BlackBackground", false);
	setThreshold(0, p);

	// Toggle the different options for converting to mask here per Michelle S' recommendations
	run("Convert to Mask", "method=Intermodes background=Light");
	run("Close-", "stack");
	run("Watershed", "stack");
	run("Open", "stack");
	print("Done Processing Binary Image.");
	run("Classic Watershed", "input="+channel + "-" + imageName+"-1.tif mask=" + channel + "-" + imageName + "-2.tif use min=0 max="+p);
	print("Done with eyfp segmentation");

	// Save the processed binary image
	selectWindow(channel + "-" + imageName + "-2.tif");
	close();
	
	// Save the binary segmentation image
	if (SaveSegBinary){
		selectWindow("watershed");
		saveAs("Tiff", dir + imageName + "_"+channel+"_eYFP_LabelImage.tif");
		print("Done saving images");
	}
	
	// Run 3D manager script to measure eyfp cell counts 
	run("3D Manager Options", 
	"volume surface compactness 3d_moments integrated_density mean_grey_value std_dev_grey_value mode_grey_value minimum_grey_value maximum_grey_value centroid_(pix) use distance_between_centers=10 distance_max_contact=1.80 drawing=Contour");
	run("3D Manager");

	selectWindow(imageName+"_"+channel+"_eYFP_LabelImage.tif");
	Ext.Manager3D_AddImage();
	selectWindow(channel + "-" + imageName + ".tif");
	Ext.Manager3D_Measure();
	Ext.Manager3D_Quantif();
	print("Saving eyfp measurements");
	Ext.Manager3D_SaveResult("M", dir+channel+"_eYFP_"+imageName+".txt");
	Ext.Manager3D_SaveResult("Q", dir+channel+"_eYFP_"+imageName+"_eYFP.txt");
	Ext.Manager3D_CloseResult("All");
	Ext.Manager3D_CloseResult("M");
	Ext.Manager3D_CloseResult("Q");

	// Print the time, save the log, close all
	f = getTime();
	print("Time =",(f-s)/1000,"seconds");

	if (SaveLog){
		selectWindow("Log");
		saveAs("text", dir+imageName+"_"+channel+"_eYFP_Log.txt");
	}	
	
	//cleanUp();
	run("Close All");
	print("Done all!");
}

// USER DEFINED FUNCTIONS
function arraySum(array) {
	sum = 0;
	for (i = 0; i < array.length; i++) {
		sum += array[i];
	}
	return sum;
}

function stackHistogram(nBins) {
	stackCounts = newArray(nBins);
	for (i = 0; i < stackCounts.length; i++) {
		stackCounts[i] = 0;
	}
	for (slice = 1; slice <= nSlices; slice++) {
        getHistogram(values,counts,nBins);
        for (i = 0; i < nBins; i++) {
            stackCounts[i] += counts[i];
        }
        run("Next Slice [>]");
	}
	return stackCounts;
}

// Closes the "Results" and "Log" windows and all image windows
function cleanUp() {
    requires("1.30e");
    if (isOpen("Results")) {
         selectWindow("Results"); 
         run("Close" );
    {

    while (nImages()>0) {
          selectImage(nImages());  
          run("Close");
    }
}




