function varargout = TDT_reading_ver_3_01(varargin)
% TDT_READING_VER_3_01 MATLAB code for TDT_reading_ver_3_01.fig
%      TDT_READING_VER_3_01, by itself, creates a new TDT_READING_VER_3_01 or raises the existing
%      singleton*.
%
%      H = TDT_READING_VER_3_01 returns the handle to a new TDT_READING_VER_3_01 or the handle to
%      the existing singleton*.
%
%      TDT_READING_VER_3_01('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in TDT_READING_VER_3_01.M with the given input arguments.
%
%      TDT_READING_VER_3_01('Property','Value',...) creates a new TDT_READING_VER_3_01 or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before TDT_reading_ver_3_01_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to TDT_reading_ver_3_01_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help TDT_reading_ver_3_01

% Last Modified by GUIDE v2.5 22-Dec-2017 12:02:15

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @TDT_reading_ver_3_01_OpeningFcn, ...
                   'gui_OutputFcn',  @TDT_reading_ver_3_01_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before TDT_reading_ver_3_01 is made visible.
function TDT_reading_ver_3_01_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to TDT_reading_ver_3_01 (see VARARGIN)

% Choose default command line output for TDT_reading_ver_3_01
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes TDT_reading_ver_3_01 wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = TDT_reading_ver_3_01_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes on button press in pushbutton1.
function pushbutton1_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get tank and block information
MyPath=get(handles.Path,'String');
MyTank=get(handles.Tank,'String');
MyBlock=get(handles.Block,'String');
MyBlock_after=get(handles.AfterBlock,'String');
after = 0;
if length(MyBlock_after) > 5
    after = 1;
end

% Get channel(s) information
Channel=get(handles.ChannelNum,'String');
comma_pos = strfind(Channel,',');
comma_pos = [0,comma_pos,length(Channel)+1];
Channel_Num = length(comma_pos)-1;
MyChannel = zeros(1,Channel_Num);
for ii=1:Channel_Num
    first=comma_pos(ii)+1;
    last=comma_pos(ii+1)-1;
    MyChannel(ii)=str2num(Channel(first:last));
end

%Get average scale information
average_scale=str2num(get(handles.AverScale,'String'));

%Get event information
Event=get(handles.EventName,'String');
comma_pos = strfind(Event,',');
comma_pos = [0,comma_pos,length(Event)+1];
Event_Num = length(comma_pos)-1;
MyEvent = cell(1,Event_Num);
for ii=1:Event_Num
    first=comma_pos(ii)+1;
    last=comma_pos(ii+1)-1;
    MyEvent{ii}=Event(first:last);
end

%Get all the data and filter them. Then the waveform is pass to the waveform_draw GUI 
data=cell(Channel_Num,Event_Num);
data_after=cell(Channel_Num,Event_Num);
average_waveform_after = {};
cutOffFreq_H=str2num(get(handles.Filter_High,'String'));	% Cutoff frequency
cutOffFreq_L=str2num(get(handles.Filter_Low,'String'));
for jj=1:Event_Num
    for ii=1:Channel_Num    
        data{ii,jj}=TDT2mat([MyPath,MyTank],MyBlock,'TYPE',{'snips'},'STORE',MyEvent{jj},'CHANNEL',MyChannel(ii));
        clc
        data{ii,jj}=getfield(data{ii,jj}.snips,MyEvent{jj});
        data{ii,jj}=TDTdigitalfilter(data{ii,jj},[cutOffFreq_L,cutOffFreq_H],'LFP');
        temp_data = data{ii,jj}.data; % single channel&event data
        temp_data = temp_data';
        trial_adjust = floor(size(temp_data,2)/average_scale)*average_scale; % make sure the trial num can be divided by average_scale
        temp_data = temp_data(:,1:trial_adjust);
        
        datasize=size(temp_data);
        average_waveform=zeros(datasize(1),datasize(2)/average_scale);
        for kk=1:datasize(1)
            aa=reshape(temp_data(kk,:),average_scale,datasize(2)/average_scale);
            average_waveform(kk,:)=mean(aa,1);
        end
        
        if after == 1
            data_after{ii,jj}=TDT2mat([MyPath,MyTank],MyBlock_after,'TYPE',{'snips'},'STORE',MyEvent{jj},'CHANNEL',MyChannel(ii));
            clc
            data_after{ii,jj}=getfield(data_after{ii,jj}.snips,MyEvent{jj});
            data_after{ii,jj}=TDTdigitalfilter(data_after{ii,jj},[cutOffFreq_L,cutOffFreq_H],'LFP');
            temp_data = data_after{ii,jj}.data; % single channel&event data
            temp_data = temp_data';
            trial_adjust = floor(size(temp_data,2)/average_scale)*average_scale; % make sure the trial num can be divided by average_scale
            temp_data = temp_data(:,1:trial_adjust);
        
            datasize=size(temp_data);
            average_waveform_after=zeros(datasize(1),datasize(2)/average_scale);
            for kk=1:datasize(1)
                aa=reshape(temp_data(kk,:),average_scale,datasize(2)/average_scale);
                average_waveform_after(kk,:)=mean(aa,1);
            end
            setappdata(0,'data_after',average_waveform_after)
            filename = [MyTank,'_',MyBlock,'_',MyBlock_after,'_',MyEvent{jj},'_Ch',num2str(MyChannel(ii))];
        else
            filename = [MyTank,'_',MyBlock,'_',MyEvent{jj},'_Ch',num2str(MyChannel(ii))];
    
        end
        setappdata(0,'filename',filename)
        setappdata(0,'after',after)
        setappdata(0,'data',average_waveform)
        setappdata(0,'Channel',MyChannel(ii))
        setappdata(0,'Event',MyEvent{jj})
        %setappdata(0,'Samplerate',data{ii,jj}.fs)
        setappdata(0,'Samplerate', 24414.062500)
        waveform_draw
    end
end

guidata(hObject,handles);


function Tank_Callback(hObject, eventdata, handles)
% hObject    handle to Tank (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Tank as text
%        str2double(get(hObject,'String')) returns contents of Tank as a double


% --- Executes during object creation, after setting all properties.
function Tank_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Tank (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Block_Callback(hObject, eventdata, handles)
% hObject    handle to Block (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Block as text
%        str2double(get(hObject,'String')) returns contents of Block as a double


% --- Executes during object creation, after setting all properties.
function Block_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Block (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function AverScale_Callback(hObject, eventdata, handles)
% hObject    handle to AverScale (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of AverScale as text
%        str2double(get(hObject,'String')) returns contents of AverScale as a double


% --- Executes during object creation, after setting all properties.
function AverScale_CreateFcn(hObject, eventdata, handles)
% hObject    handle to AverScale (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function ChannelNum_Callback(hObject, eventdata, handles)
% hObject    handle to ChannelNum (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of ChannelNum as text
%        str2double(get(hObject,'String')) returns contents of ChannelNum as a double


% --- Executes during object creation, after setting all properties.
function ChannelNum_CreateFcn(hObject, eventdata, handles)
% hObject    handle to ChannelNum (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function EventName_Callback(hObject, eventdata, handles)
% hObject    handle to EventName (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of EventName as text
%        str2double(get(hObject,'String')) returns contents of EventName as a double


% --- Executes during object creation, after setting all properties.
function EventName_CreateFcn(hObject, eventdata, handles)
% hObject    handle to EventName (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function Filter_Low_Callback(hObject, eventdata, handles)
% hObject    handle to Filter_Low (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Filter_Low as text
%        str2double(get(hObject,'String')) returns contents of Filter_Low as a double


% --- Executes during object creation, after setting all properties.
function Filter_Low_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Filter_Low (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Filter_High_Callback(hObject, eventdata, handles)
% hObject    handle to Filter_High (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Filter_High as text
%        str2double(get(hObject,'String')) returns contents of Filter_High as a double


% --- Executes during object creation, after setting all properties.
function Filter_High_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Filter_High (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


function AfterBlock_Callback(hObject, eventdata, handles)
% hObject    handle to AfterBlock (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of AfterBlock as text
%        str2double(get(hObject,'String')) returns contents of AfterBlock as a double


% --- Executes during object creation, after setting all properties.
function AfterBlock_CreateFcn(hObject, eventdata, handles)
% hObject    handle to AfterBlock (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Path_Callback(hObject, eventdata, handles)
% hObject    handle to Path (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Path as text
%        str2double(get(hObject,'String')) returns contents of Path as a double


% --- Executes during object creation, after setting all properties.
function Path_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Path (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
