function varargout = waveform_draw(varargin)
% WAVEFORM_DRAW MATLAB code for waveform_draw.fig
%      WAVEFORM_DRAW, by itself, creates a new WAVEFORM_DRAW or raises the existing
%      singleton*.
%
%      H = WAVEFORM_DRAW returns the handle to a new WAVEFORM_DRAW or the handle to
%      the existing singleton*.
%
%      WAVEFORM_DRAW('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in WAVEFORM_DRAW.M with the given input arguments.
%
%      WAVEFORM_DRAW('Property','Value',...) creates a new WAVEFORM_DRAW or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before waveform_draw_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to waveform_draw_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help waveform_draw

% Last Modified by GUIDE v2.5 23-May-2023 18:19:43

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @waveform_draw_OpeningFcn, ...
                   'gui_OutputFcn',  @waveform_draw_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before waveform_draw is made visible.
function waveform_draw_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to waveform_draw (see VARARGIN)

% Choose default command line output for waveform_draw
% handles.output = hObject;

axes(handles.axes1)
cla(handles.axes1,'reset');
hold on;
handles.waveform = getappdata(0,'data');
channel = getappdata(0,'Channel');
event = getappdata(0,'Event');
handles.samplerate = getappdata(0,'Samplerate');
title(['Event:',event,' CH:',num2str(channel)])
for ii=1:min(size(handles.waveform))
    plot((1:length(handles.waveform))./handles.samplerate*1000,handles.waveform(:,ii),'k')
end
plot((1:length(handles.waveform))./handles.samplerate*1000,mean(handles.waveform,2),'r', 'LineWidth',2)
xlim([0 length(handles.waveform)/handles.samplerate*1000])
hold off

% Use default parameters to calulate
axes(handles.axes1);
if isfield(handles,'hMSlope1')
    set(handles.hMSlope1,'Visible','off');
end
if isfield(handles,'hMSlope2')
    set(handles.hMSlope2,'Visible','off');
end

points1=[str2num(get(handles.defMS_start,'String')),1; str2num(get(handles.defMS_end,'String')),1];
hold on;
handles.hMSlope1 = plot([points1(1,1),points1(1,1)],handles.axes1.YLim,'r');
handles.hMSlope2 = plot([points1(2,1),points1(2,1)],handles.axes1.YLim,'r');
hold off

aa=floor(points1(1,1)/1000*handles.samplerate);
bb=floor(points1(2,1)/1000*handles.samplerate);
handles.MS=zeros(2,size(handles.waveform,2)); % MS = MSlope
temp=[];
for ii=1:size(handles.waveform,2)
    temp=[ones((bb-aa)+1,1) (aa:bb)'./handles.samplerate];
    handles.MS(:,ii)=regress(handles.waveform(aa:bb,ii),temp).*str2num(get(handles.Polarity,'String'));
end
axes(handles.axes2);
cla(handles.axes2,'reset');
hold on
plot(handles.MS(2,:),'.','MarkerSize',12)
ylim([0,max(abs(handles.MS(2,:)))*1.2])
title('slope self define')
hold off


axes(handles.axes1)
if isfield(handles,'hSetBaseline1')
    set(handles.hSetBaseline1,'Visible','off');
end

if isfield(handles,'hSetBaseline2')
    set(handles.hSetBaseline2,'Visible','off');
end

points2=[str2num(get(handles.defBL_start,'String')),1; str2num(get(handles.defBL_end,'String')),1];
hold on
handles.hSetBaseline1 = plot([points2(1,1),points2(1,1)],handles.axes1.YLim,'b');
handles.hSetBaseline2 = plot([points2(2,1),points2(2,1)],handles.axes1.YLim,'b');
hold off
aa=floor(points2(1,1)/1000*handles.samplerate);
bb=floor(points2(2,1)/1000*handles.samplerate);
handles.baseline=mean(handles.waveform(aa:bb,:),1);

axes(handles.axes1)
if isfield(handles,'hSetPeak1')
    set(handles.hSetPeak1,'Visible','off');
end
if isfield(handles,'hSetPeak2')
    set(handles.hSetPeak2,'Visible','off');
end

points3=[str2num(get(handles.defSP_start,'String')),1; str2num(get(handles.defSP_end,'String')),1];
hold on
handles.hSetPeak1 = plot([points3(1,1),points3(1,1)],handles.axes1.YLim,'y');
handles.hSetPeak2 = plot([points3(2,1),points3(2,1)],handles.axes1.YLim,'y');
hold off
aa=floor(points3(1,1)/1000*handles.samplerate);
bb=floor(points3(2,1)/1000*handles.samplerate);
[valley,latency]=max(abs(handles.waveform(aa:bb,:)),[],1);
latency=latency+aa-1;
handles.latency_ms=latency/handles.samplerate*1000-str2num(get(handles.Sti_start,'String'));
handles.peak=(valley.*str2num(get(handles.Polarity,'String'))-handles.baseline).*str2num(get(handles.Polarity,'String'));


axes(handles.axes3)
cla(handles.axes3,'reset');
hold on
plot(handles.peak,'.','MarkerSize',12);
ylim([0 max(abs(handles.peak))*1.2])
title('Peak')
hold off

axes(handles.axes4)
cla(handles.axes4,'reset');
hold on
plot(handles.latency_ms,'.','MarkerSize',12);
ylim([0 max(abs(handles.latency_ms))*1.2])
title('Peak Latency')
hold off

handles.fEPSP_r2=zeros(2,size(handles.waveform,2));
for ii=1:size(handles.waveform,2)
    ee=floor(aa+(latency(ii)-aa)*0.2);
    ff=floor(latency(ii)-(latency(ii)-aa)*0.2);
    temp=[ones((ff-ee)+1,1) (ee:ff)'./handles.samplerate];
    handles.fEPSP_r2(:,ii)=regress(handles.waveform(ee:ff,ii),temp)*str2num(get(handles.Polarity,'String'));
end
axes(handles.axes5)
cla(handles.axes5,'reset');
hold on
plot(handles.fEPSP_r2(2,:),'.','MarkerSize',12)
title('Auto slope 20 - 80%')
ylim([0 max(abs(handles.fEPSP_r2(2,:)))*1.2])
hold off



% Draw and process after data
axes(handles.axes6)
cla(handles.axes6,'reset');
hold on;
handles.waveform_after = getappdata(0,'data_after');
handles.after = getappdata(0,'after');
if handles.after == 1
    for ii=1:min(size(handles.waveform_after))
        plot((1:length(handles.waveform_after))./handles.samplerate*1000,handles.waveform_after(:,ii),'k')
    end
    plot((1:length(handles.waveform_after))./handles.samplerate*1000,mean(handles.waveform_after,2),'r', 'LineWidth',2)
    xlim([0 length(handles.waveform)/handles.samplerate*1000])
end
hold off

if handles.after == 1

    axes(handles.axes6);
    if isfield(handles,'hMSlope3')
        set(handles.hMSlope3,'Visible','off');
    end
    if isfield(handles,'hMSlope4')
        set(handles.hMSlope4,'Visible','off');
    end



    points1=[str2num(get(handles.defMS_start,'String')),1; str2num(get(handles.defMS_end,'String')),1];
    hold on;
    handles.hMSlope3 = plot([points1(1,1),points1(1,1)],handles.axes1.YLim,'r');
    handles.hMSlope4 = plot([points1(2,1),points1(2,1)],handles.axes1.YLim,'r');
    hold off

    aa=floor(points1(1,1)/1000*handles.samplerate);
    bb=floor(points1(2,1)/1000*handles.samplerate);
    handles.MS_after=zeros(2,size(handles.waveform_after,2)); % MS = MSlope
    temp=[];
    for ii=1:size(handles.waveform_after,2)
        temp=[ones((bb-aa)+1,1) (aa:bb)'./handles.samplerate];
        handles.MS_after(:,ii)=regress(handles.waveform_after(aa:bb,ii),temp).*str2num(get(handles.Polarity,'String'));
    end
    axes(handles.axes2);
    hold on
    plot((length(handles.MS)+4):(length(handles.MS)+length(handles.MS_after)+3),handles.MS_after(2,:),'.','MarkerSize',12)
    ylim([0,max(abs([handles.MS_after(2,:),handles.MS(2,:)]))*1.2])
    title('slope self define')
    hold off


    axes(handles.axes6)
    if isfield(handles,'hSetBaseline3')
        set(handles.hSetBaseline3,'Visible','off');
    end

    if isfield(handles,'hSetBaseline4')
        set(handles.hSetBaseline4,'Visible','off');
    end

    points2=[str2num(get(handles.defBL_start,'String')),1; str2num(get(handles.defBL_end,'String')),1];
    hold on
    handles.hSetBaseline3 = plot([points2(1,1),points2(1,1)],handles.axes1.YLim,'b');
    handles.hSetBaseline4 = plot([points2(2,1),points2(2,1)],handles.axes1.YLim,'b');
    hold off
    aa=floor(points2(1,1)/1000*handles.samplerate);
    bb=floor(points2(2,1)/1000*handles.samplerate);
    handles.baseline_after=mean(handles.waveform_after(aa:bb,:),1);

    axes(handles.axes6)
    if isfield(handles,'hSetPeak3')
        set(handles.hSetPeak3,'Visible','off');
    end
    if isfield(handles,'hSetPeak4')
        set(handles.hSetPeak4,'Visible','off');
    end

    points3=[str2num(get(handles.defSP_start,'String')),1; str2num(get(handles.defSP_end,'String')),1];
    hold on
    handles.hSetPeak3 = plot([points3(1,1),points3(1,1)],handles.axes1.YLim,'y');
    handles.hSetPeak4 = plot([points3(2,1),points3(2,1)],handles.axes1.YLim,'y');
    hold off
    aa=floor(points3(1,1)/1000*handles.samplerate);
    bb=floor(points3(2,1)/1000*handles.samplerate);
    [valley_after,latency_after]=max(abs(handles.waveform_after(aa:bb,:)),[],1);
    latency_after=latency_after+aa-1;
    handles.latency_ms_after=latency_after/handles.samplerate*1000-str2num(get(handles.Sti_start,'String'));
    handles.peak_after=(valley_after.*str2num(get(handles.Polarity,'String'))-handles.baseline_after).*str2num(get(handles.Polarity,'String'));


    axes(handles.axes3)
    hold on
    plot((length(handles.peak)+4):(length(handles.peak)+length(handles.peak_after)+3),handles.peak_after,'.','MarkerSize',12);
    ylim([0 max(abs([handles.peak,handles.peak_after]))*1.2])
    title('Peak')
    hold off

    axes(handles.axes4)
    hold on
    plot((length(handles.latency_ms)+4):(length(handles.latency_ms)+length(handles.latency_ms_after)+3),handles.latency_ms_after,'.','MarkerSize',12);
    ylim([0 max(abs([handles.latency_ms,handles.latency_ms_after]))*1.2])
    title('Peak Latency')
    hold off

    handles.fEPSP_r2_after=zeros(2,size(handles.waveform_after,2));
    for ii=1:size(handles.waveform_after,2)
        ee=floor(aa+(latency_after(ii)-aa)*0.2);
        ff=floor(latency_after(ii)-(latency_after(ii)-aa)*0.2);
        temp=[ones((ff-ee)+1,1) (ee:ff)'./handles.samplerate];
        handles.fEPSP_r2_after(:,ii)=regress(handles.waveform_after(ee:ff,ii),temp)*str2num(get(handles.Polarity,'String'));
    end
    axes(handles.axes5)
    hold on
    plot((length(handles.fEPSP_r2)+4):(length(handles.fEPSP_r2)+length(handles.fEPSP_r2_after)+3),handles.fEPSP_r2_after(2,:),'.','MarkerSize',12)
    title('Auto slope 20 - 80%')
    ylim([0 max(abs([handles.fEPSP_r2(2,:),handles.fEPSP_r2_after(2,:)]))*1.2])
    hold off

end



% Update handles structure
guidata(hObject, handles);

% UIWAIT makes waveform_draw wait for user response (see UIRESUME)
uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = waveform_draw_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
% varargout{1} = handles.output;


% --- Executes when user attempts to close figure1.
function figure1_CloseRequestFcn(hObject, eventdata, handles)
% hObject    handle to figure1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: delete(hObject) closes the figure
delete(hObject);


% --- Executes on button press in MSlope.
function MSlope_Callback(hObject, eventdata, handles)
% hObject    handle to MSlope (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
axes(handles.axes1);
if isfield(handles,'hMSlope1')
    set(handles.hMSlope1,'Visible','off');
end
if isfield(handles,'hMSlope2')
    set(handles.hMSlope2,'Visible','off');
end



points1=ginput(2);
hold on;
handles.hMSlope1 = plot([points1(1,1),points1(1,1)],handles.axes1.YLim,'r');
handles.hMSlope2 = plot([points1(2,1),points1(2,1)],handles.axes1.YLim,'r');
hold off

aa=floor(points1(1,1)/1000*handles.samplerate);
bb=floor(points1(2,1)/1000*handles.samplerate);
handles.MS=zeros(2,size(handles.waveform,2)); % MS = MSlope
temp=[];
for ii=1:size(handles.waveform,2)
    temp=([ones((bb-aa)+1,1) (aa:bb)'./handles.samplerate]);
    handles.MS(:,ii)=regress(handles.waveform(aa:bb,ii),temp).*str2num(get(handles.Polarity,'String'));
end
axes(handles.axes2);
cla(handles.axes2,'reset');
hold on
plot(abs(handles.MS(2,:)),'.','MarkerSize',12)
ylim([0,max(abs(handles.MS(2,:)))*1.2])
title('slope self define')
hold off

if handles.after == 1

    axes(handles.axes6);
    if isfield(handles,'hMSlope3')
        set(handles.hMSlope3,'Visible','off');
    end
    if isfield(handles,'hMSlope4')
        set(handles.hMSlope4,'Visible','off');
    end


    hold on;
    handles.hMSlope3 = plot([points1(1,1),points1(1,1)],handles.axes1.YLim,'r');
    handles.hMSlope4 = plot([points1(2,1),points1(2,1)],handles.axes1.YLim,'r');
    hold off

    aa=floor(points1(1,1)/1000*handles.samplerate);
    bb=floor(points1(2,1)/1000*handles.samplerate);
    handles.MS_after=zeros(2,size(handles.waveform_after,2)); % MS = MSlope
    temp=[];
    for ii=1:size(handles.waveform_after,2)
        temp=[ones((bb-aa)+1,1) (aa:bb)'./handles.samplerate];
        handles.MS_after(:,ii)=regress(handles.waveform_after(aa:bb,ii),temp).*str2num(get(handles.Polarity,'String'));
    end
    axes(handles.axes2);
    hold on
    plot((length(handles.MS)+4):(length(handles.MS)+length(handles.MS_after)+3),abs(handles.MS_after(2,:)),'.','MarkerSize',12)
    ylim([0,max(abs([handles.MS_after(2,:),handles.MS(2,:)]))*1.2])
    title('slope self define')
    hold off
end

guidata(hObject,handles);                                                                               



function Polarity_Callback(hObject, eventdata, handles)
% hObject    handle to Polarity (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Polarity as text
%        str2double(get(hObject,'String')) returns contents of Polarity as a double


% --- Executes during object creation, after setting all properties.
function Polarity_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Polarity (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Y_Max_Callback(hObject, eventdata, handles)
% hObject    handle to Y_Max (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Y_Max as text
%        str2double(get(hObject,'String')) returns contents of Y_Max as a double


% --- Executes during object creation, after setting all properties.
function Y_Max_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Y_Max (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function Y_Min_Callback(hObject, eventdata, handles)
% hObject    handle to Y_Min (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Y_Min as text
%        str2double(get(hObject,'String')) returns contents of Y_Min as a double


% --- Executes during object creation, after setting all properties.
function Y_Min_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Y_Min (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in Set_Y.
function Set_Y_Callback(hObject, eventdata, handles)
% hObject    handle to Set_Y (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

Y_Max=str2num(get(handles.Y_Max,'String'));
Y_Min=str2num(get(handles.Y_Min,'String'));

axes(handles.axes1)
ylim([Y_Min Y_Max])

axes(handles.axes6)
ylim([Y_Min Y_Max])
guidata(hObject,handles);


function X_Max_Callback(hObject, eventdata, handles)
% hObject    handle to X_Max (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of X_Max as text
%        str2double(get(hObject,'String')) returns contents of X_Max as a double


% --- Executes during object creation, after setting all properties.
function X_Max_CreateFcn(hObject, eventdata, handles)
% hObject    handle to X_Max (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function X_Min_Callback(hObject, eventdata, handles)
% hObject    handle to X_Min (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of X_Min as text
%        str2double(get(hObject,'String')) returns contents of X_Min as a double


% --- Executes during object creation, after setting all properties.
function X_Min_CreateFcn(hObject, eventdata, handles)
% hObject    handle to X_Min (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in Set_X.
function Set_X_Callback(hObject, eventdata, handles)
% hObject    handle to Set_X (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

X_Max=str2num(get(handles.X_Max,'String'));
X_Min=str2num(get(handles.X_Min,'String'));

axes(handles.axes1)
xlim([X_Min X_Max])

axes(handles.axes6)
xlim([X_Min X_Max])
guidata(hObject,handles);



function defMS_start_Callback(hObject, eventdata, handles)
% hObject    handle to defMS_start (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of defMS_start as text
%        str2double(get(hObject,'String')) returns contents of defMS_start as a double


% --- Executes during object creation, after setting all properties.
function defMS_start_CreateFcn(hObject, eventdata, handles)
% hObject    handle to defMS_start (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function defMS_end_Callback(hObject, eventdata, handles)
% hObject    handle to defMS_end (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of defMS_end as text
%        str2double(get(hObject,'String')) returns contents of defMS_end as a double


% --- Executes during object creation, after setting all properties.
function defMS_end_CreateFcn(hObject, eventdata, handles)
% hObject    handle to defMS_end (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in SetBaseline.
function SetBaseline_Callback(hObject, eventdata, handles)
% hObject    handle to SetBaseline (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

axes(handles.axes1)
if isfield(handles,'hSetBaseline1')
    set(handles.hSetBaseline1,'Visible','off');
end

if isfield(handles,'hSetBaseline2')
    set(handles.hSetBaseline2,'Visible','off');
end

points2=ginput(2);
hold on
handles.hSetBaseline1 = plot([points2(1,1),points2(1,1)],handles.axes1.YLim,'b');
handles.hSetBaseline2 = plot([points2(2,1),points2(2,1)],handles.axes1.YLim,'b');
hold off
aa=floor(points2(1,1)/1000*handles.samplerate);
bb=floor(points2(2,1)/1000*handles.samplerate);
handles.baseline=mean(handles.waveform(aa:bb,:),1);

if handles.after == 1
    axes(handles.axes6)
    if isfield(handles,'hSetBaseline3')
        set(handles.hSetBaseline3,'Visible','off');
    end

    if isfield(handles,'hSetBaseline4')
        set(handles.hSetBaseline4,'Visible','off');
    end

    hold on
    handles.hSetBaseline3 = plot([points2(1,1),points2(1,1)],handles.axes1.YLim,'b');
    handles.hSetBaseline4 = plot([points2(2,1),points2(2,1)],handles.axes1.YLim,'b');
    hold off
    aa=floor(points2(1,1)/1000*handles.samplerate);
    bb=floor(points2(2,1)/1000*handles.samplerate);
    handles.baseline_after=mean(handles.waveform_after(aa:bb,:),1);
end

guidata(hObject,handles);



function defBL_start_Callback(hObject, eventdata, handles)
% hObject    handle to defBL_start (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of defBL_start as text
%        str2double(get(hObject,'String')) returns contents of defBL_start as a double


% --- Executes during object creation, after setting all properties.
function defBL_start_CreateFcn(hObject, eventdata, handles)
% hObject    handle to defBL_start (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function defBL_end_Callback(hObject, eventdata, handles)
% hObject    handle to defBL_end (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of defBL_end as text
%        str2double(get(hObject,'String')) returns contents of defBL_end as a double


% --- Executes during object creation, after setting all properties.
function defBL_end_CreateFcn(hObject, eventdata, handles)
% hObject    handle to defBL_end (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in SetPeak.
function SetPeak_Callback(hObject, eventdata, handles)
% hObject    handle to SetPeak (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

axes(handles.axes1)
if isfield(handles,'hSetPeak1')
    set(handles.hSetPeak1,'Visible','off');
end
if isfield(handles,'hSetPeak2')
    set(handles.hSetPeak2,'Visible','off');
end

points3=ginput(2);
hold on
handles.hSetPeak1 = plot([points3(1,1),points3(1,1)],handles.axes1.YLim,'y');
handles.hSetPeak2 = plot([points3(2,1),points3(2,1)],handles.axes1.YLim,'y');
hold off
aa=floor(points3(1,1)/1000*handles.samplerate);
bb=floor(points3(2,1)/1000*handles.samplerate);
[valley,latency]=max(abs(handles.waveform(aa:bb,:)),[],1);
latency=latency+aa-1;
handles.latency_ms=latency/handles.samplerate*1000-str2num(get(handles.Sti_start,'String'));
handles.peak=(valley.*str2num(get(handles.Polarity,'String'))-handles.baseline).*str2num(get(handles.Polarity,'String'));


axes(handles.axes3)
cla(handles.axes3,'reset');
hold on
plot(handles.peak,'.','MarkerSize',12);
ylim([0 max(abs(handles.peak))*1.2])
title('Peak')
hold off

axes(handles.axes4)
cla(handles.axes4,'reset');
hold on
plot(handles.latency_ms,'.','MarkerSize',12);
ylim([0 max(abs(handles.latency_ms))*1.2])
title('Peak Latency')
hold off

handles.fEPSP_r2=zeros(2,size(handles.waveform,2));
for ii=1:size(handles.waveform,2)
    ee=floor(aa+(latency(ii)-aa)*0.2);
    ff=floor(latency(ii)-(latency(ii)-aa)*0.2);
    temp=[ones((ff-ee)+1,1) (ee:ff)'./handles.samplerate];
    handles.fEPSP_r2(:,ii)=regress(handles.waveform(ee:ff,ii),temp)*str2num(get(handles.Polarity,'String'));
end
axes(handles.axes5)
cla(handles.axes5,'reset');
hold on
plot(handles.fEPSP_r2(2,:),'.','MarkerSize',12)
title('Auto slope 20 - 80%')
ylim([0 max(abs(handles.fEPSP_r2(2,:)))*1.2])
hold off

if handles.after == 1
    axes(handles.axes6)
    if isfield(handles,'hSetPeak3')
        set(handles.hSetPeak3,'Visible','off');
    end
    if isfield(handles,'hSetPeak4')
        set(handles.hSetPeak4,'Visible','off');
    end

    hold on
    handles.hSetPeak3 = plot([points3(1,1),points3(1,1)],handles.axes1.YLim,'y');
    handles.hSetPeak4 = plot([points3(2,1),points3(2,1)],handles.axes1.YLim,'y');
    hold off
    aa=floor(points3(1,1)/1000*handles.samplerate);
    bb=floor(points3(2,1)/1000*handles.samplerate);
    [valley_after,latency_after]=max(abs(handles.waveform_after(aa:bb,:)),[],1);
    latency_after=latency_after+aa-1;
    handles.latency_ms_after=latency_after/handles.samplerate*1000-str2num(get(handles.Sti_start,'String'));
    handles.peak_after=(valley_after.*str2num(get(handles.Polarity,'String'))-handles.baseline_after).*str2num(get(handles.Polarity,'String'));


    axes(handles.axes3)
    hold on
    plot((length(handles.peak)+4):(length(handles.peak)+length(handles.peak_after)+3),handles.peak_after,'.','MarkerSize',12);
    ylim([0 max(abs([handles.peak,handles.peak_after]))*1.2])
    title('Peak')
    hold off

    axes(handles.axes4)
    hold on
    plot((length(handles.latency_ms)+4):(length(handles.latency_ms)+length(handles.latency_ms_after)+3),handles.latency_ms_after,'.','MarkerSize',12);
    ylim([0 max(abs([handles.latency_ms,handles.latency_ms_after]))*1.2])
    title('Peak Latency')
    hold off

    handles.fEPSP_r2_after=zeros(2,size(handles.waveform_after,2));
    for ii=1:size(handles.waveform_after,2)
        ee=floor(aa+(latency_after(ii)-aa)*0.2);
        ff=floor(latency_after(ii)-(latency_after(ii)-aa)*0.2);
        temp=[ones((ff-ee)+1,1) (ee:ff)'./handles.samplerate];
        handles.fEPSP_r2_after(:,ii)=regress(handles.waveform_after(ee:ff,ii),temp)*str2num(get(handles.Polarity,'String'));
    end
    axes(handles.axes5)
    hold on
    plot((length(handles.fEPSP_r2)+4):(length(handles.fEPSP_r2)+length(handles.fEPSP_r2_after)+3),handles.fEPSP_r2_after(2,:),'.','MarkerSize',12)
    title('Auto slope 20 - 80%')
    ylim([0 max(abs([handles.fEPSP_r2(2,:),handles.fEPSP_r2_after(2,:)]))*1.2])
    hold off

end


guidata(hObject,handles)



function Sti_start_Callback(hObject, eventdata, handles)
% hObject    handle to Sti_start (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of Sti_start as text
%        str2double(get(hObject,'String')) returns contents of Sti_start as a double


% --- Executes during object creation, after setting all properties.
function Sti_start_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Sti_start (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function defSP_start_Callback(hObject, eventdata, handles)
% hObject    handle to defSP_start (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of defSP_start as text
%        str2double(get(hObject,'String')) returns contents of defSP_start as a double


% --- Executes during object creation, after setting all properties.
function defSP_start_CreateFcn(hObject, eventdata, handles)
% hObject    handle to defSP_start (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function defSP_end_Callback(hObject, eventdata, handles)
% hObject    handle to defSP_end (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of defSP_end as text
%        str2double(get(hObject,'String')) returns contents of defSP_end as a double


% --- Executes during object creation, after setting all properties.
function defSP_end_CreateFcn(hObject, eventdata, handles)
% hObject    handle to defSP_end (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function XlsName_Callback(hObject, eventdata, handles)
% hObject    handle to XlsName (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of XlsName as text
%        str2double(get(hObject,'String')) returns contents of XlsName as a double


% --- Executes during object creation, after setting all properties.
function XlsName_CreateFcn(hObject, eventdata, handles)
% hObject    handle to XlsName (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in WriteXls.
function WriteXls_Callback(hObject, eventdata, handles)
% hObject    handle to WriteXls (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

filename=[get(handles.XlsName,'String'),getappdata(0,'filename'),'.xls'];
if handles.after == 1
    col1=[handles.MS(2,:),[0,0,0],handles.MS_after(2,:)]';
    col2=[handles.fEPSP_r2(2,:),[0,0,0],handles.fEPSP_r2_after(2,:)]';
    col3=[handles.peak,[0,0,0],handles.peak_after]';
    col4=[handles.latency_ms,[0,0,0],handles.latency_ms_after]';
else
    col1=handles.MS(2,:)';
    col2=handles.fEPSP_r2(2,:)';
    col3=handles.peak';
    col4=handles.latency_ms';
end

titlename = {'MSlop','AutoSlope','Amplitude','Latency'};
xlswrite(filename,titlename(1:4));
xlswrite(filename,[col1 col2 col3 col4],1,'A2');

guidata(hObject,handles);


% --- Executes on button press in DrawWave.
function DrawWave_Callback(hObject, eventdata, handles)
% hObject    handle to DrawWave (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
WaveformNum_before=str2num(get(handles.WaveformNum_before,'String'));
WaveformNum_after=str2num(get(handles.WaveformNum_after,'String'));
figure
hold on
plot((1:length(handles.waveform))./handles.samplerate*1000,handles.waveform(:,WaveformNum_before),'b');
if handles.after == 1
    plot((1:length(handles.waveform_after))./handles.samplerate*1000,handles.waveform_after(:,WaveformNum_after),'r');
end
hold off

guidata(hObject,handles);


function WaveformNum_before_Callback(hObject, eventdata, handles)
% hObject    handle to WaveformNum_before (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of WaveformNum_before as text
%        str2double(get(hObject,'String')) returns contents of WaveformNum_before as a double


% --- Executes during object creation, after setting all properties.
function WaveformNum_before_CreateFcn(hObject, eventdata, handles)
% hObject    handle to WaveformNum_before (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function WaveformNum_after_Callback(hObject, eventdata, handles)
% hObject    handle to WaveformNum_after (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of WaveformNum_after as text
%        str2double(get(hObject,'String')) returns contents of WaveformNum_after as a double


% --- Executes during object creation, after setting all properties.
function WaveformNum_after_CreateFcn(hObject, eventdata, handles)
% hObject    handle to WaveformNum_after (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes when figure1 is resized.
function figure1_SizeChangedFcn(hObject, eventdata, handles)
% hObject    handle to figure1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on key release with focus on figure1 or any of its controls.
function figure1_WindowKeyReleaseFcn(hObject, eventdata, handles)
% hObject    handle to figure1 (see GCBO)
% eventdata  structure with the following fields (see MATLAB.UI.FIGURE)
%	Key: name of the key that was released, in lower case
%	Character: character interpretation of the key(s) that was released
%	Modifier: name(s) of the modifier key(s) (i.e., control, shift) released
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on key press with focus on figure1 or any of its controls.
function figure1_WindowKeyPressFcn(hObject, eventdata, handles)
% hObject    handle to figure1 (see GCBO)
% eventdata  structure with the following fields (see MATLAB.UI.FIGURE)
%	Key: name of the key that was pressed, in lower case
%	Character: character interpretation of the key(s) that was pressed
%	Modifier: name(s) of the modifier key(s) (i.e., control, shift) pressed
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on mouse press over figure background, over a disabled or
% --- inactive control, or over an axes background.
function figure1_WindowButtonUpFcn(hObject, eventdata, handles)
% hObject    handle to figure1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on key press with focus on figure1 and none of its controls
