function varargout = vesselDiameter(varargin)
% VESSELDIAMETER M-file for vesselDiameter.fig
%      VESSELDIAMETER, by itself, creates a new VESSELDIAMETER or raises the existing
%      singleton*.
%
%      H = VESSELDIAMETER returns the handle to a new VESSELDIAMETER or the handle to
%      the existing singleton*.
%
%      VESSELDIAMETER('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in VESSELDIAMETER.M with the given input arguments.
%
%      VESSELDIAMETER('Property','Value',...) creates a new VESSELDIAMETER or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before vesselDiameter_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to vesselDiameter_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help vesselDiameter

% Last Modified by GUIDE v2.5 24-Dec-2008 09:29:47

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @vesselDiameter_OpeningFcn, ...
                   'gui_OutputFcn',  @vesselDiameter_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before vesselDiameter is made visible.
function vesselDiameter_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to vesselDiameter (see VARARGIN)

% Choose default command line output for vesselDiameter
handles.output = hObject;

% initialize listbox
initial_dir = pwd;
set(handles.directoryTxt,'String',initial_dir)

% Populate the listbox
load_listbox(initial_dir,handles);

axes(handles.axes1);
axis off;
axes(handles.axes2);
title('ROI Data');
axes(handles.axes3);
xlabel('frame');
ylabel('diameter (pixels)');

% Update handles structure
guidata(hObject, handles);



% UIWAIT makes vesselDiameter wait for user response (see UIRESUME)
% uiwait(handles.figure1);

% ------------------------------------------------------------
% Read the current directory and sort the names
% ------------------------------------------------------------
function load_listbox(dir_path,handles)
dir_struct = dir([dir_path '\*.tif*']);
[sorted_names,sorted_index] = sortrows({dir_struct.name}');
handles.file_names = sorted_names;
handles.is_dir = [dir_struct.isdir];
handles.sorted_index = sorted_index;
guidata(handles.figure1,handles)
set(handles.lbox,'String',handles.file_names,...
	'Value',1)



% --- Outputs from this function are returned to the command line.
function varargout = vesselDiameter_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes on selection change in lbox.
function lbox_Callback(hObject, eventdata, handles)
% hObject    handle to lbox (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: contents = get(hObject,'String') returns lbox contents as cell array
%        contents{get(hObject,'Value')} returns selected item from lbox

dname = get(handles.directoryTxt,'String');
contents = get(hObject,'String');
selected = contents{get(hObject,'Value')};
fname = [dname '\' selected];
handles.fname = fname;
iminfo = imfinfo(fname);

set(handles.slider1,'max',length(iminfo),'Value',1,'Enable','on');
set(handles.slider2,'max',length(iminfo),'Value',1,'Enable','on');
set(handles.slider3,'max',length(iminfo),'Value',1,'Enable','on');
set(handles.edit3,'Enable','on','String','1');
set(handles.edit4,'Enable','on','String','1');
[handles.lpt handles.rpt] = deal(ones(1,length(iminfo)));

im = imread(fname,1);
if get(handles.rotateButton,'Value'), im = im'; end
axes(handles.axes1);
himage = imagesc(im);
title('Frame: 1');
colormap gray; axis(handles.axes1,'equal','off');

% % remove existing distance line if it exists
if isfield(handles,'line1')
    try
        l1 = iptgetapi(handles.line1);
        l1.delete();
    catch
    end
    handles = rmfield(handles,'line1');
end
if isfield(handles,'line2')
    try
        l2 = iptgetapi(handles.line1);
        l2.delete();
    catch
    end
    handles = rmfield(handles,'line2');
end

sim = size(im);
line1 = imline(handles.axes1,[sim(2)/2-sim(2)/4 sim(2)/2+sim(2)/4],[sim(1)/2 sim(1)/2]);
l1 = iptgetapi(line1);
fcn = makeConstrainToRectFcn('imline',get(himage,'Xdata'),get(himage,'Ydata'));
l1.setDragConstraintFcn(fcn);
l1.addNewPositionCallback(@(positions)moveLine(positions,handles));
handles.line1pos = l1.getPosition();

handles.line1 = line1;
handles.himage = himage;
handles.distance = [];
moveLine(l1.getPosition(),handles);

% enable buttons
set(handles.showDistLine,'Enable','on');
set(handles.lineButton,'Enable','on');
set(handles.playButton,'Enable','on')
set(handles.trackButton,'Enable','on');
set(handles.edgeLedit,'Enable','on');
set(handles.edgeRedit,'Enable','on');
set(handles.saveButton,'Enable','on');
guidata(hObject, handles);



% --- Callback executed after movement of roiline
function moveLine(pos,handles)
% get new data and plot
pos = round(pos);
cols = sort([pos(1,1) pos(2,1)]);
rows = sort([pos(1,2) pos(2,2)]);
ind = round(get(handles.slider1,'Value'));
if get(handles.rotateButton,'Value')
    data = imread(handles.fname,ind,'PixelRegion',{cols,rows});
    data = data';
else
    data = imread(handles.fname,ind,'PixelRegion',{rows,cols});
end
data = mean(data,1); 
data = smoothData(data,5,3,0);
data = mat2gray(data);
axes(handles.axes2);
x = cols(1):cols(2);
if length(x) ~= length(data) % this occurs when line is on edge
    x = x(1:length(data));
end
plot(x,data);
hold on;

% setup sliders for new data size
sx = size(data,2);
set(handles.slider2,'Value',1,'Max',sx,'SliderStep',[1/sx 5/sx]);
set(handles.slider3,'Value',1,'Max',sx,'SliderStep',[1/sx 5/sx]);

% plot edge selection circles
lpt = round(get(handles.slider2,'Value'));
rpt = round(get(handles.slider3,'Value'));
plot(x(lpt),data(lpt),'ro',x(rpt),data(rpt),'ro');
title('ROI Data');
hold off;

% clear distance plot
axh = handles.axes3;
line = get(axh,'Children');
set(line,'ydata',[]);
set(handles.axis3Title,'String','Run Track Edges for Current ROI');


% --- Executes during object creation, after setting all properties.
function lbox_CreateFcn(hObject, eventdata, handles)
% hObject    handle to lbox (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: listbox controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function directoryTxt_Callback(hObject, eventdata, handles)
% hObject    handle to directoryTxt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of directoryTxt as text
%        str2double(get(hObject,'String')) returns contents of directoryTxt as a double


% --- Executes during object creation, after setting all properties.
function directoryTxt_CreateFcn(hObject, eventdata, handles)
% hObject    handle to directoryTxt (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in dirBrowse.
function dirBrowse_Callback(hObject, eventdata, handles)
% hObject    handle to dirBrowse (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
directoryname = uigetdir(pwd, 'Pick a Directory');
set(handles.directoryTxt,'String',directoryname);
load_listbox(directoryname,handles);
guidata(hObject,handles);


% --- Executes on button press in pushbutton2.
function pushbutton2_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on slider movement.
function slider1_Callback(hObject, eventdata, handles)
% hObject    handle to slider1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider
if ~isempty(getappdata(hObject,'InCallback')), return; end
setappdata(hObject,'InCallback',1); 
indx = round( get( hObject, 'Value' ) );
set(hObject,'Value',indx);
showImage(handles);
if indx == 1
    set(handles.slider2,'Enable','on');
    set(handles.slider3,'Enable','on');
    set(handles.edit3,'Enable','on');
    set(handles.edit4,'Enable','on');
else
    set(handles.slider2,'Enable','off');
    set(handles.slider3,'Enable','off');
    set(handles.edit3,'Enable','off');
    set(handles.edit4,'Enable','off');
end
setappdata(hObject,'InCallback',[]); 


% --- Executes during object creation, after setting all properties.
function slider1_CreateFcn(hObject, eventdata, handles)
% hObject    handle to slider1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end


% --- Updates the image and plot in the display console
function showImage(handles)
% grayscale image 
ind = round(get(handles.slider1,'Value'));
im = imread(handles.fname,ind);
if get(handles.rotateButton,'Value'), im = im'; end
set(handles.himage,'CData',im);
title(handles.axes1,['frame: ' num2str(ind)]);
colormap gray;

% ROI profile plot
if isfield(handles,'line1')
    line1 = iptgetapi(handles.line1);
    pos = round(line1.getPosition());
else
    pos = handles.line1pos;
end
cols = sort([pos(1,1) pos(2,1)]);
rows = sort([pos(1,2) pos(2,2)]);
data = im(rows(1):rows(2),cols(1):cols(2));
data = mean(data,1);
data = mat2gray(data);
data = smoothData(data,5,3,0);

axes(handles.axes2);
plot(data); set(handles.axes2,'xtick',[],'ytick',[]);
hold on;

lpt = handles.lpt(ind);
set(handles.slider2,'Value',lpt);
set(handles.edit3,'String',num2str(lpt));
set(handles.text5,'String',num2str(data(lpt)));

rpt = handles.rpt(ind);
set(handles.slider3,'Value',rpt);
set(handles.edit4,'String',num2str(rpt));
set(handles.text6,'String',num2str(data(rpt)));

plot(lpt,data(lpt),'ro',rpt,data(rpt),'ro');
title('ROI Data');
hold off;

% distance line
if isfield(handles,'line2') %get(handles.showDistLine,'Value')
    line2 = iptgetapi(handles.line2);
    y = round((pos(1,2)+pos(2,2))/2);
    line2.setPosition([pos(1,1)+lpt,y;pos(1,1)+rpt,y]);
end

% distance plot
axes(handles.axes3);
if ~isempty(handles.distance)
    axh = handles.axes3;
    plot(handles.distance);
    xlabel('Frame');
    ylabel('Vessel Diameter (# pixels)');    
    hold on;
    plot(ind,handles.distance(ind),'r*');
    hold off;
end


% --- Executes on slider movement.
function slider2_Callback(hObject, eventdata, handles)
% hObject    handle to slider2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider
if ~isempty(getappdata(hObject,'InCallback')), return; end
setappdata(hObject,'InCallback',1); 
fr = round(get(handles.slider1,'Value'));
ind = round(get(hObject,'Value'));
set(hObject,'Value',ind);
set(handles.edit3,'String',num2str(ind));
handles.lpt(fr) = ind;
showImage(handles);
setappdata(hObject,'InCallback',[])
guidata(hObject, handles);



% --- Executes during object creation, after setting all properties.
function slider2_CreateFcn(hObject, eventdata, handles)
% hObject    handle to slider2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end


% --- Executes on button press in playButton.
function playButton_Callback(hObject, eventdata, handles)
% hObject    handle to playButton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
set(handles.lineButton,'Enable','off');
set(handles.showDistLine,'Enable','off');
set(handles.rotateButton,'Enable','off');
fr = round(get(handles.slider1,'Value'));
frMax = get(handles.slider1,'Max');
if fr == frMax, fr = 1; end
setappdata(hObject,'Playing',1);
stopped = 0;
while ( (fr < frMax) && ~stopped)
    stopped = ~getappdata(hObject,'Playing');
    fr = fr+1;
    set(handles.slider1,'Value',fr);
    showImage(handles)
    pause(1/str2double(get(handles.frameRate,'String')));
end
if ~stopped
    set(handles.slider1,'Value',1);
    showImage(handles)
end
set(handles.rotateButton,'Enable','on');
set(handles.showDistLine,'Enable','on');
set(handles.lineButton,'Enable','on');
setappdata(hObject,'Playing',0);


% --- Executes on button press in radiobutton1.
function radiobutton1_Callback(hObject, eventdata, handles)
% hObject    handle to radiobutton1 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of radiobutton1


% --- Executes on button press in radiobutton2.
function radiobutton2_Callback(hObject, eventdata, handles)
% hObject    handle to radiobutton2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of radiobutton2


% --- Executes on button press in trackButton.
function trackButton_Callback(hObject, eventdata, handles)
% hObject    handle to trackButton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% disable buttons during callback
set(handles.slider2,'Enable','off');
set(handles.slider3,'Enable','off');
set(handles.edit3,'Enable','off');
set(handles.edit4,'Enable','off');
set(handles.showDistLine,'Enable','off');
set(handles.lineButton,'Enable','off');
set(handles.playButton,'Enable','off')
set(handles.trackButton,'Enable','off');
set(handles.saveButton,'Enable','off');
set(handles.rotateButton,'Enable','off');


set(handles.figure1,'Pointer','watch');
fr = round(get(handles.slider1,'Value'));
roi = 10; % number of points around center pt to search for peak
nframes = get(handles.slider1,'Max');
if isfield(handles,'line1')
    l1 = iptgetapi(handles.line1);
    pos = round(l1.getPosition());
else
    pos = handles.line1pos;
end
cols = sort([pos(1,1) pos(2,1)]);
rows = sort([pos(1,2) pos(2,2)]);

% start iteration
for i = fr+1:nframes
    % get current frame data
    if get(handles.rotateButton,'Value')
        data = imread(handles.fname,i,'PixelRegion',{cols,rows});
        data = data';
    else
        data = imread(handles.fname,i,'PixelRegion',{rows,cols});
    end
    data = mean(data,1);
    data = mat2gray(data);
    data = smoothData(data,5,3,0);

    % left data point
    k = 0; found = 0; clear dpks dlocs
    while ~found % expand the roi until find a peak/valley
        dataL = data(handles.lpt(i-1)-roi-k:handles.lpt(i-1)+roi+k);
        if ~get(handles.peakL,'Value')
            dataL = -dataL + max(dataL);
        end
        if k > 0 % check for and remove peak plateu
            dataMax = max(dataR);
            ind = find(data == dataMax);
            if length(dataMax) > 1
                dataR = [dataR(1:ind(1)) dataR(ind(1)+length(ind):end)];
            end
        end
        [dpks dlocs] = findpeaks(dataL);
        if ~isempty(dlocs)
            found = 1;
        else
            display(['Frame ' num2str(i) ': Expanding left pt search area and looking again.']);
            k = k+1;
        end

    end
    shift = dlocs(1) - (roi+1+k);
    handles.lpt(i) = handles.lpt(i-1) + shift(shift == min(shift));

    % right data point
    found = 0;  k = 0;  clear dpks dlocs
    while ~found
        dataR = data(handles.rpt(i-1)-roi-k:handles.rpt(i-1)+roi+k);
        if ~get(handles.peakR,'Value')
            dataR = -dataR + max(dataR);
        end
        if k > 0 % check for and remove peak plateu
            dataMax = max(dataR);
            ind = find(data == dataMax);
            if length(dataMax) > 1
                dataR = [dataR(1:ind(1)) dataR(ind(1)+length(ind):end)];
            end
        end
        [dpks dlocs] = findpeaks(dataR);
        if ~isempty(dlocs)
            found = 1;
        else
            display(['Frame ' num2str(i) ': Expanding right pt search area and looking again.']);
            k = k+1;
        end
    end
    shift = dlocs(1) - (roi+1+k);
    handles.rpt(i) = handles.rpt(i-1) + shift(shift == min(shift));

    handles.distance = abs(handles.rpt - handles.lpt);

    % update display
    ind = get(handles.slider1,'Value') + 1;
    set(handles.slider1,'Value',ind);
    showImage(handles);
end

set(handles.showDistLine,'Enable','on');
set(handles.lineButton,'Enable','on');
set(handles.playButton,'Enable','on')
set(handles.trackButton,'Enable','on');
set(handles.saveButton,'Enable','on');
set(handles.rotateButton,'Enable','on');
set(handles.figure1,'Pointer','arrow');
set(handles.axis3Title,'String',[]);
guidata(hObject,handles);


% --- Executes on slider movement.
function slider3_Callback(hObject, eventdata, handles)
% hObject    handle to slider3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'Value') returns position of slider
%        get(hObject,'Min') and get(hObject,'Max') to determine range of slider
if ~isempty(getappdata(hObject,'InCallback')), return; end
setappdata(hObject,'InCallback',1);
fr = round(get(handles.slider1,'Value'));
ind = round(get(hObject,'Value'));
handles.rpt(fr) = ind;
set(handles.edit4,'String',num2str(ind));
showImage(handles);
setappdata(hObject,'InCallback',[]);
guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function slider3_CreateFcn(hObject, eventdata, handles)
% hObject    handle to slider3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: slider controls usually have a light gray background.
if isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor',[.9 .9 .9]);
end


% --- Executes when selected object is changed in uipanel1.
function uipanel1_SelectionChangeFcn(hObject, eventdata, handles)
% hObject    handle to the selected object in uipanel1 
% eventdata  structure with the following fields (see UIBUTTONGROUP)
%	EventName: string 'SelectionChanged' (read only)
%	OldValue: handle of the previously selected object or empty if none was selected
%	NewValue: handle of the currently selected object
% handles    structure with handles and user data (see GUIDATA)
newValue =  get(eventdata.NewValue,'Tag');
handles.showType = newValue;

showImage(handles);
guidata(hObject,handles);



function frameRate_Callback(hObject, eventdata, handles)
% hObject    handle to frameRate (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of frameRate as text
%        str2double(get(hObject,'String')) returns contents of frameRate as a double


% --- Executes during object creation, after setting all properties.
function frameRate_CreateFcn(hObject, eventdata, handles)
% hObject    handle to frameRate (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit3_Callback(hObject, eventdata, handles)
% hObject    handle to edit3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit3 as text
%        str2double(get(hObject,'String')) returns contents of edit3 as a double
ind = str2double(get(hObject,'String'));
set(handles.slider2,'Value',ind);
slider2_callback(handles.slider2,eventdata,handles);

% --- Executes during object creation, after setting all properties.
function edit3_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit3 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function edit4_Callback(hObject, eventdata, handles)
% hObject    handle to edit4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit4 as text
%        str2double(get(hObject,'String')) returns contents of edit4 as a double
ind = str2double(get(hObject,'String'));
set(handles.slider3,'Value',ind);
slider3_callback(handles.slider3,eventdata,handles);

% --- Executes during object creation, after setting all properties.
function edit4_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit4 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in peakR.
function peakR_Callback(hObject, eventdata, handles)
% hObject    handle to peakR (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of peakR
if get(hObject,'Value')
    set(handles.valleyR,'Value',0);
else
    set(handles.valleyR,'Value',1);
end

% --- Executes on button press in valleyR.
function valleyR_Callback(hObject, eventdata, handles)
% hObject    handle to valleyR (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of valleyR
if get(hObject,'Value')
    set(handles.peakR,'Value',0);
else
    set(handles.peakR,'Value',1);
end


% --- Executes on button press in valleyL.
function valleyL_Callback(hObject, eventdata, handles)
% hObject    handle to valleyL (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of valleyL
if get(hObject,'Value')
    set(handles.peakL,'Value',0);
else
    set(handles.peakL,'Value',1);
end

% --- Executes on button press in peakL.
function peakL_Callback(hObject, eventdata, handles)
% hObject    handle to peakL (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of peakL
if get(hObject,'Value')
    set(handles.valleyL,'Value',0);
else
    set(handles.valleyL,'Value',1);
end

function smoothY = smoothData(Y,w,type,ends)
% fastbsmooth(Y,w,type,ends) smooths vector Y with smooth
%  of width w. Version 2.0, May 2008.
% The argument "type" determines the smooth type:
%   If type=1, rectangular (sliding-average or boxcar)
%   If type=2, triangular (2 passes of sliding-average)
%   If type=3, pseudo-Gaussian (3 passes of sliding-average)
% The argument "ends" controls how the "ends" of the signal
% (the first w/2 points and the last w/2 points) are handled.
%   If ends=0, the ends are zero.  
%   If ends=1, the ends are smoothed with progressively
%     smaller smooths the closer to the end. 

if nargin==2, ends=0; type=1; end
if nargin==3, ends=0; end
switch type
    case 1
        sy = sa(Y,w,ends);
    case 2
        sy = sa(sa(Y,w,ends),w,ends);
    case 3
        sy = sa(sa(sa(Y,w,ends),w,ends),w,ends);
end
smoothY = sy;

function SmoothY = sa(Y,smoothwidth,ends)
w = round(smoothwidth);
SumPoints = sum(Y(1:w));
s = zeros(size(Y));
halfw = round(w/2);
L = length(Y);
for k = 1:L-w,
    s(k+halfw-1) = SumPoints;
    SumPoints = SumPoints-Y(k);
    SumPoints = SumPoints+Y(k+w);
end
s(k+halfw) = sum(Y(L-w+1:L));
SmoothY = s./w;
% Taper the ends of the signal if ends=1.
if ends==1,
    startpoint = (smoothwidth + 1)/2;
    SmoothY(1) = (Y(1)+Y(2))./2;
    for k=2:startpoint,
        SmoothY(k) = mean(Y(1:(2*k-1)));
        SmoothY(L-k+1) = mean(Y(L-2*k+2:L));
    end
    SmoothY(L) = (Y(L)+Y(L-1))./2;
end


% --- Executes on button press in lineButton.
function lineButton_Callback(hObject, eventdata, handles)
% hObject    handle to lineButton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if isfield(handles,'line1')
    l1 = iptgetapi(handles.line1);
    handles.line1pos = round(l1.getPosition());
    handles = rmfield(handles,'line1');
    l1.delete();
else
    line1 = imline(handles.axes1,handles.line1pos(:,1),handles.line1pos(:,2));
    l1 = iptgetapi(line1);
fcn = makeConstrainToRectFcn('imline',get(handles.himage,'Xdata'),get(handles.himage,'Ydata'));
    l1.setDragConstraintFcn(fcn);
    l1.addNewPositionCallback(@(positions)moveLine(positions,handles));
    handles.line1 = line1;
end
guidata(hObject,handles);

% --- Executes on button press in edgeRedit.
function edgeRedit_Callback(hObject, eventdata, handles)
% hObject    handle to edgeRedit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if get(hObject,'Value')
    set(handles.slider3,'Enable','on')
    set(handles.edit4,'Enable','on');
else
    set(handles.slider3,'Enable','off')
    set(handles.edit4,'Enable','off');
end


% --- Executes on button press in edgeLedit.
function edgeLedit_Callback(hObject, eventdata, handles)
% hObject    handle to edgeLedit (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
if get(hObject,'Value')
    set(handles.slider2,'Enable','on')
    set(handles.edit3,'Enable','on');
else
    set(handles.slider2,'Enable','off')
    set(handles.edit3,'Enable','off');
end


% --- Executes on button press in pushbutton8.
function pushbutton8_Callback(hObject, eventdata, handles)
% hObject    handle to pushbutton8 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)


% --- Executes on button press in showDistLine.
function showDistLine_Callback(hObject, eventdata, handles)
% hObject    handle to showDistLine (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of showDistLine
if isfield(handles,'line2'); % remove the line
    try
    line2 = iptgetapi(handles.line2);
    line2.delete();
    catch
    end
    handles = rmfield(handles,'line2');
else % show the line
    ind = round(get(handles.slider1,'Value'));
    lpt = handles.lpt(ind);
    rpt = handles.rpt(ind);
    line2 = imline(handles.axes1,handles.line1pos(:,1)+lpt,handles.line1pos(:,2)+rpt);
    l2 = iptgetapi(line2);
    l2.setColor([1 1 1]);
    fcn = makeConstrainToRectFcn('imline',get(handles.himage,'Xdata'),get(handles.himage,'Ydata'));
    l2.setDragConstraintFcn(fcn)
    handles.line2 = line2;
end
showImage(handles);
guidata(hObject,handles);



function edit5_Callback(hObject, eventdata, handles)
% hObject    handle to edit5 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit5 as text
%        str2double(get(hObject,'String')) returns contents of edit5 as a double


% --- Executes during object creation, after setting all properties.
function edit5_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit5 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in saveButton.
function saveButton_Callback(hObject, eventdata, handles)
% hObject    handle to saveButton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
fname = [get(handles.directoryTxt,'String') '\' get(handles.edit5,'String')];
answer = [];
if exist([fname '.mat'],'file')
    answer = questdlg('file already exists overwrite or rename?','warning','overwrite','rename','rename');
end
if ~strcmp(answer,'rename')
    guiOut.filename = handles.fname;
    guiOut.data = handles.distance;
    save(fname,'guiOut');
end


%% --------------------------------------------------------------------------
function [pks,locs] = findpeaks(X,varargin)
%FINDPEAKS Find local peaks in data
%   PKS = FINDPEAKS(X) finds local peaks in data set X where is a
%   vector
%
%   [PKS,LOCS]= FINDPEAKS(X) also returns the indices LOCS at which the
%   peaks occur.
%
error(nargchk(1,11,nargin,'struct'));

Ph  = -Inf;         
Pd  = [];       
Th  = 0;
Np  = [];
Str = 'none';

pks = [];
locs = [];


M = length(X);

if (M == 0)
    datamsgid = generatemsgid('emptyDataSet');
    error(datamsgid,'Data set cannot be empty.');
elseif Ph == -Inf
        Data = X;
        L = M;
        % validate value of Pd and set default values for Pd and Np
        [Pd,Np] = setvalues(Pd,Np,L); 
        if(Pd >=L)
            pdmsgid = generatemsgid('largeMinPeakDistance');
            error(pdmsgid,strcat('Invalid MinPeakDistance. Set MinPeakDistance in the range (',...
                    num2str(0), ',', num2str(L), ').'));
        else
            % call getpeaks_contindx to reduce execution time. 
            [pks,locs] = getpeaks_contindx(Data,Pd,Th,Np);
        end
else           
    Indx = find(X > Ph);
    Data = X(Indx);
    L = length(Data);
    if(L==0)
        mphmsgid = generatemsgid('largeMinPeakHeight');
        warning(mphmsgid,'Invalid MinPeakHeight. There are no data points greater than MinPeakHeight.');
    else
        % validate value of Pd and set default values for Pd and Np
        [Pd,Np] = setvalues(Pd,Np,L); 
        if(Pd >=Indx(L))
            pdmsgid = generatemsgid('largeMinPeakDistance');
            error(pdmsgid,strcat('Invalid MinPeakDistance. Set MinPeakDistance in the range (',...
                  num2str(0), ',', num2str(Indx(L)), ').'));
        else           
            [pks,locs] =getpeaks(Data,Indx,Pd,Th,Np,M);
        end
    end
end

if isempty(pks)
%     npmsgid = generatemsgid('noPeaks');
%     warning(npmsgid,'No peaks found.')
elseif(~strcmp(Str,'none'))
    [pks,s]  = sort(pks,Str); 
    if(~isempty(locs))
        locs = locs(s);
    end
end

%--------------------------------------------------------------------------
function [Pd,Np] = setvalues(Pd,Np,L)

if ~isempty(Pd) && (~isnumeric(Pd) || ~isscalar(Pd) ||any(rem(Pd,1)) || (Pd < 1))
    Nmsgid = generatemsgid('invalidMinPeakDistance');
    error(Nmsgid,'MinPeakDistance should be an integer greater than 0.');
end

if(isempty(Pd))
    Pd = 1;
end

if(isempty(Np))
    Np = L;
end

%--------------------------------------------------------------------------
function [pks,locs] = getpeaks(Data,Indx,Pd,Th,Np,M)
% This function finds peaks in data set Data whose index set Indx is
% disjoint. Some data points were removed from the original set through
% preprocessing

m = 0;                  % counter for peaks found
L = length(Indx);              

% Pre-allocate for speed
pks  = zeros(1,Np);
locs = zeros(1,Np);

endindx = Indx(L);      % last point in the index set

j = 0;             
% First, the "Pd" neighbors, on either side, of the current data point are
% found. Then the current data point is compared with these neighbors to
% determine whether it is a peak.

while (j < L) && (m < Np)
    j = j+1;

    % leftmost neighbor index
    endL = max(1,Indx(j) - Pd);

    % Update the leftmost neighbor index if there is a peak within "Pd"
    % neighbors of leftmost index
    if(m > 0) 
        x = min([locs(m)+ Pd  endindx-1]);
        if(Indx(j)<=x)                    
            k = find(Indx > x ,1,'first');
            j = k;              
            endL = Indx(j)- Pd;
        end
    end   

     % rightmost neighbor index
    endR = min(Indx(j) + Pd,endindx);

    % Find nearest points to leftmost and rightmost neighbor indices. This
    % is necessary because index set Indx may be disjoint.
    a =  find(endL<=Indx,1,'first');
    b =  find(endR>=Indx,1,'last');

    % create neighbor data set
    temp = Data(a:b);

    % set current data point to -Inf in the neighbor data set
    aa = find(Indx(j) == Indx(a:b));
    temp(aa) = -Inf;

    % Compare current data point with all neighbors
    if(all((Data(j) > temp+Th)) && (Indx(j) ~=1)&& (Indx(j)~=M))        
        m = m+1;
        pks(m)  = Data(j);  % peaks
        locs(m) = Indx(j);  % loctions of peaks     
    end    
end

% return all peaks found
if m~=0
    locs = locs(locs > 0);
    pks  = pks(1:length(locs));
else
    locs = [];
    pks = [];
end

% %--------------------------------------------------------------------------
function [pks,locs] = getpeaks_contindx(Data,Pd,Th,Np)
% This function finds peaks in data set Data whose index set is not
% disjoint. No data points were removed from the original set through
% preprocessing. Calling this function instead of getpeaks reduces
% execution time.

m = 0;                  % counter for peaks found
L = length(Data);

j = 0;

% Pre-allocate for speed
pks  = zeros(1,Np);
locs = zeros(1,Np);

% First, the "Pd" neighbors, on either side, of the current data point are
% found. Then the current data point is compared with these "Pd" neighbors
% to determine whether it is a peak.
while (j < L) && (m < Np)      
    j =j+1;  
    
    % leftmost neighbor index
    endL = max(1,j- Pd);  
    
    % Update the leftmost neighbor index if there is a peak within
    % "Pd" neighbors of leftmost index
    if(m > 0)      
        if (j < min([locs(m)+Pd  L-1]));  
            j = min([locs(m)+Pd  L-1]);   
            endL = j-Pd;
        end
    end
   
    % rightmost neighbor index
    endR = min(L,j+ Pd);   
    
    % create neighbor data set
    temp = Data(endL:endR); 
   
    % set current data point to -Inf in the neighbor data set
    aa = find(j == endL:endR);    
    temp(aa) = -Inf;
   
    % Compare current data point with all neighbors
    if(all((Data(j) > temp+Th)) && (j ~=1) && j~=L)
        m = m+1;
        pks(m)  = Data(j); 
        locs(m) = j;       
    end
end

% return all peaks found
if m~=0    
    pks  = pks(1:m);
    locs = locs(1:m);
else
    pks  = [];
    locs = [];
end


% [EOF]


% --- Executes on button press in rotateButton.
function rotateButton_Callback(hObject, eventdata, handles)
% hObject    handle to rotateButton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of rotateButton
fname = handles.fname;
iminfo = imfinfo(fname);
im = imread(fname,1);
if get(hObject,'Value'), im = im'; end

% remove existing distance line if it exists
if isfield(handles,'line1')
    try
        l1 = iptgetapi(handles.line1);
        l1.delete();
    catch
    end
    handles = rmfield(handles,'line1');
end
if isfield(handles,'line2')
    try
        l2 = iptgetapi(handles.line1);
        l2.delete();
    catch
    end
    handles = rmfield(handles,'line2');
end

% update image 
axes(handles.axes1);
himage = imagesc(im);
title('Frame: 1');
colormap gray; axis(handles.axes1,'equal','off');

sim = size(im);
line1 = imline(handles.axes1,[sim(2)/2-sim(2)/4 sim(2)/2+sim(2)/4],[sim(1)/2 sim(1)/2]);
l1 = iptgetapi(line1);
fcn = makeConstrainToRectFcn('imline',get(himage,'Xdata'),get(himage,'Ydata'));
l1.setDragConstraintFcn(fcn);
l1.addNewPositionCallback(@(positions)moveLine(positions,handles));
handles.line1pos = l1.getPosition();

[handles.lpt handles.rpt] = deal(ones(1,length(iminfo)));

handles.line1 = line1;
handles.himage = himage;
handles.distance = [];
moveLine(l1.getPosition(),handles);

guidata(hObject, handles);


% --- Executes on button press in stopButton.
function stopButton_Callback(hObject, eventdata, handles)
% hObject    handle to stopButton (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
setappdata(handles.playButton,'Playing',0);

