% This code has been used in the Figure 3-Supplement 2 of Shin et al (2026), 
% and estimates failure rate at the 1st and 2nd pulses of paired stimulation 
% at the interval of isi.
%
% Input: 
% To estimate failure rates, following data should be provided:
% N, the number of release sites
% isi, inter-spike interval 
% data = [p11, p10, p01, p00] 
% p11, double success
% p10, 2nd failure
% p01, 1st failure
% p00, double failure
%
% Output: 
% 1)  estimated dobule failure rates in the k1-pv plane
% , where k1 = forward rate and pv = vesicular fusion probability
% under the regime of the simple refilling model
% 2)  residual of estimates from data for double faiure rate 
% 3)  residual of estimates from data for all  faiure rates ( p11, p10, p01, p00)


global N isi pr data isi

N = 6;  % Nr of release sites
isi = 0.02;  % interspike interval

% data = [p11, p10, p01, p00]
data = [0.416, 0.478, 0.044, 0.062]; 

% failure rate at the 1st pulse
 pf1 = data(3)+data(4); % p01 + p00
 pr = 1 - pf1^(1/N);  %Since pf1 = (1-pr)^N

 
%prm = [k1, pv]
 prm = [5,  1];
 lb = [4,   0.8];
 ub = [8,  1];

f1w = 4:0.25:8;
pvw = 0.8:0.005:1;
nf = length(f1w);
np = length(pvw);

p00 = zeros(nf, np);
p0 = zeros(nf, np);
rsdwAll =  zeros(nf, np);
rsdwFF =  zeros(nf, np);

for x = 1:nf
    for y = 1:np
        prm = [f1w(x), pvw(y)];
        % pw = [p11, p10, p01, p00];
        pw = calcP1(prm);
        %[p0(x,y), p00(x,y)] = calcfail2(f1w(x), pvw(y), pr);
        p00(x,y) = pw(4);
        rsdwAll(x,y) = sum(abs(pw - data));
        rsdwFF(x,y) = sum(abs(pw(4) - data(4)));
    end
end

figure(1); clf; pffimg = surf(pvw, f1w, p00);view([0 90]); ylabel('k1'); xlabel('pv'); title('P(F1,F2)'); colorbar;
pffimg.EdgeColor = 'none'; 

figure(2); clf; rsdffimg = surf(pvw, f1w, rsdwFF);view([0 90]); ylabel('k1'); xlabel('pv'); title('residual of P(F1,F2)'); colorbar;
rsdffimg.EdgeColor = 'none'; 

figure(3); clf; rsdimg = surf(pvw, f1w, rsdwAll);view([0 90]); ylabel('k1'); xlabel('pv'); title('residual'); colorbar;
rsdimg.EdgeColor = 'none'; clim([0.01, 0.35]);


%figure(3); clf; surf(pvw, f1w, p00);view([0 90]); ylabel('k1'); xlabel('pv'); title('P(F1,F2)'); colorbar;

optx = fmincon(@calcrsd, prm, [], [], [], [], lb, ub);
rsd = calcrsd(optx);
optP = simp(optx);

%% obj function
function [err] = calcrsd(prm)
%prm = [k1, pv]
    global data % [p11, p10, p01, p00]    

    est = calcP1(prm);    
    err = sum((data-est).^2);
end

function est = simp(prm)
    est = calcP1(prm);
end

%%
function [pw] = calcP1(prm)
    global N isi pr  
  
    % prm = [6, 4.5, 1];
    % pr = 0.32;
    f1 = prm(1);  %  = forward rate const (1/s)
    pv = prm(2);  %  = vesicle fusion prob

    pocc = pr/pv;  % pr = pv pocc 
    %since pocc = f1 / (f1+b1)
    b1 = f1*(1-pocc)/pocc; %backward rate const (1/s)
   
    % F1 = fail at 1st pulse
    % F2 = fail at 2nd pulse
    % k = RRP at 1st pulse

    %%
    if pv==1
        pocc_ = pr;
        f1_ = f1;  %forward rate const (1/s)
        fail1_ = (1-pocc_)^N;
        fail2_ = exp(-N*f1_*isi); % prob for no refill
        p0 = fail1_;
        p1i = 1-p0;
        p00 = fail1_*fail2_; 
        p01 = fail1_*(1-fail2_);
        p10 = (1-fail1_)*fail2_;
        p11 = (1-fail1_)*(1-fail2_);

    else
        
        p0i = zeros(N+1,1); %P(F1| n1=k)*P(n1=k)
                
        pi = zeros(N+1,1); %prob for RRP = i at 1st pulse
        % pin = zeros(N+1,1); % prob for n inc by 1
        % pout = zeros(N+1,1); % prob for n dec by 1
        % pnull = zeros(N+1,1); % prob for no change in n 
        
        %Calc fail1w = P(F1|n1=k) P(n1=k)
        for idx = 1:N+1
            i = idx-1;
            pi(idx) = nchoosek(N, i)*pocc^i*(1-pocc)^(N-i);
            p0i(idx) =  pi(idx)*(1-pv)^i;            
        end
        p1i = pi - p0i;  %P(S1| n1=k)*P(n1=k)
       
        %% j -(refill)-> k 
        
        pjk = zeros(N+1, N+1);  % = p(k|j)
        
        for jdx = 1:N+1
            j = jdx-1; % n1 = k = RRP size at 1st  pulse 
            k = j;
            while k<=N
                kdx = k+1;
                pjk(jdx, kdx) = calcpn2_(j, k, f1, b1, N, isi); %=p(n2=k|n1=j)
                k = k+1;
            end
            k = j-1;
            while k>=0
                kdx = k+1;
                pjk(jdx, kdx) = calcpn2_(j, k, f1, b1, N, isi);
                k = k-1;
            end
        end
        
        %% i -(rls1)-> j -(refill)-> k -> (rls2)    
        % calc pij(i,j) = prob for j-1 remains outof i-1 SVs after 1st AP
        pij = zeros(N+1);
        for idx=1:N+1
            for jdx=1:N+1
                i = idx-1;
                j = jdx-1;
                if i>=j
                    pij(idx,jdx) = pi(idx)*nchoosek(i, j)*(1-pv)^j*pv^(i-j);
                else
                    pij(idx,jdx) = 0;
                end
            end
        end

       % p(i,j,k) = p(i,j) x p(k|i,j)   = p(i) x p(j|i) x p(k|i, j)
       %             = pi(i) *pij(i,j) * pjk(j,k)
       
       p00 = 0;
       p10 = 0;
        pijk = zeros(N+1, N+1, N+1);
        for idx=1:N+1
            for jdx=1:N+1
                for kdx=1:N+1
                    k = kdx - 1;
                    pijk(idx,jdx,kdx) = pij(idx,jdx)*pjk(jdx,kdx);
                    if idx==jdx
                        p00 = p00 + pijk(idx,jdx,kdx)*(1-pv)^k;
                    else
                        p10 = p10  + pijk(idx,jdx,kdx)*(1-pv)^k;
                    end
                end
            end
        end
    
        p01 = sum(p0i) - p00;
        p11 = sum(p1i) - p10; 

    end
     pw = [p11, p10, p01, p00];
end

function [pn2] = calcpn2_(n1, n2, k1, b1, N, dt)
%n1, SV num at 1st pulse
%n2, SV num at 2nd pulse
%k1,b1: forward and backward rate const
%N, docking sites
%dt, inter-spike interval
%Calc  P(n2|n1)

    Frw = 1-exp(-k1*dt);
    Bck = 1-exp(-b1*dt);
     
    o1 = N-n1; % empty sites
    k = n2 - n1; %nmv SVs are transferred during dt
    
    % Pn2 = Sum(j=0..n1) {C(n1,j) * C(o1, k+j) *B^j * (1-B)^(n1-j) * F^(k+j)* (1-F)^(o1-k-j)}
          
    pn2 = 0;    
        % let j = # of backward sites
        for j = 0:n1  
            if ((k+j)>=0) &&((k+j)<= o1)
                pn2 = pn2 + nchoosek(n1, j) * nchoosek(o1, k+j) * Bck^j *(1-Bck)^(n1-j)*Frw^(k+j)*(1-Frw)^(o1-k-j);
            end
        end
end