% This code replicates Figure 9 of Shin et al., (Elife, 2026)
% The simulation parameters for Figure 9 A-D are provided as B-E columns in param.xls.
% Initially this code reads one of these columns for simulation parameters.
% Cascade Ca2+ binding steps to syt7 is implemented in deriv() of ni7.m
% kon and koff for Ca-binidng to Syt7 are defined in setparam.m
% This code reads our measured data from stpwtee.csv and stpkdee.csv
% For Figure9A, set bKD = 0 and Nstep = 5
% For Figure9B, set bKD = 0 and Nstep = 4
% For Figure9C, set bKD = 0 and Nstep = 5
% For Figure9D, set bKD = 1

clear;

set(0, 'DefaultFigureWindowStyle', 'docked');
clrcode = ["#0072BD", "#D95319", "#EDB120", "#7E2F8E"];

global cb isi dt T bAP bSyt syt0 sytstat
global pnb Nsite Nmax g n0
global vinit kinit kstat

bKD = 0;  % if it is true, figure 9D

% Nstep should be one of {5, 4, 3}
% if Nstep == 5, figure 9A;   if Nstep ==4, figure9B;  if Nstep ==3, figure9C
Nstep = 3;  

pfname = "param.xls";
bAPw = [1 0];

if ~exist('stpdata', 'var')
    if bKD ==1
        stpdata = readtable('stpkdee.csv');
    else
        stpdata = readtable('stpwtee.csv');
    end
end

if ~exist('bPlot', 'var')
    bPlot = 1;
end

if ~exist('pset', 'var')
    pset = readtable(pfname);
end

if bKD == 1
    pw=pset.pw4;
else
    switch(Nstep)
        case 5
            pw = pset.pw1;
        case 4
            pw = pset.pw2;
        case 3
            pw = pset.pw3;
    end
end

setparam(pw);  % here kinit is set to [cb, cloc, knb, knglobal]

%% params 

dt = 1;
isiw = [200, 100, 50, 25];  

Nf = length(isiw);   %num of frq

Ntrial = 10;

Thead = -10;
Ttail = 10;
Npuls = 20; 
cb = 0.05;

rls = cell(Nf, 1); 
nz = zeros(Npuls, Nf);
z  = zeros(Npuls, Nf);
vrec = cell(Ntrial, Nf);
krec = cell(Ntrial, Nf);
v_kin = cell(Nf, 1);
k_kin = cell(Nf, 1);
c = cb;

% vinit = vdx by Nsite matrix
% kinit = [c, clocal, kn, ks];

%% Main
tic
for fdx = 1:Nf
    isi = isiw(fdx);
    T = 0;
    c = cb;
    rls{fdx} = zeros(Npuls, Ntrial);
    
    for ndx=1:Ntrial

        % initialize v -------------------------------------- row of vinit is [en, es, n,s, z1, z2, x]
        vinit = zeros(2, Nsite);

        for site = 1:Nsite
            for nn = 1:Nmax
                 if rand() < g     % g = ninf/Nmax
                    vinit(2, site) = vinit(2, site) + 1; %n
                 end
            end
        end
        vinit(1, :) = Nmax - vinit(2, :); % e
        % ____________________________________
        
        %Header
        vrec{ndx, fdx} = [vrec{ndx, fdx}; repmat(sum(vinit, 2)', abs(Thead), 1)];
        krec{ndx, fdx} = [krec{ndx, fdx}; repmat(kinit(1:3), abs(Thead), 1)];
        if bSyt
            
        end

        %Train --------------------------------------------
        bAP = bAPw(1); %boolean AP
        v = vinit;
        kstat = kinit;
        sytstat = syt0;

        for idx = 1:Npuls            
            for site=1:Nsite
                n = v(2, site);

                if bAP
                    zn = pnb*n;
                else
                    zn = 0;
                end

                v(1,site) = v(1,site) + zn;  % e
                v(2,site) = v(2,site) - zn;  % n
                    
                 rls{fdx}(idx, ndx) = rls{fdx}(idx, ndx) + zn;

            end %for site

            if bSyt
                [vout, vw, kw] = ni7(v, isi);  %Syt7
            else
                [vout, vw, kw] = ni(v, isi);  
            end
            vrec{ndx, fdx} = [vrec{ndx, fdx}; vw];
            krec{ndx, fdx} = [krec{ndx, fdx}; kw];        

            v = vout;
            %kstat = kw(end,:);
            T = T + dt;
            
        end %for idx = 1:Npuls __________________

        %Tail
            bAP = bAPw(2);
            if bSyt
                [vout, vw, kw] = ni7(v, Ttail);  % Syt7
            else
                [vout, vw, kw] = ni(v, Ttail);  % numerical integration
            end        
        
        vrec{ndx, fdx} = [vrec{ndx, fdx}; vw];
        krec{ndx, fdx} = [krec{ndx, fdx}; kw];

    end %for Ntrial
   
    v_kin{fdx} = cellmean_(vrec(:, fdx));
    k_kin{fdx} = cellmean_(krec(:, fdx));

     
     tx = Thead*dt:dt:T;    
     tx = tx(1:size(v_kin{fdx}, 1));
     
     if bPlot
         plotparams; 
     end    
    
    %rls{fdx} = Npuls by Ntrial
    z(:, fdx) = mean(rls{fdx}, 2);
    baseline = n0 * Nsite * pnb; 
    nz(:, fdx) = z(:, fdx)/baseline;
        
end %for Nf
toc

%% plot var

pulx = 1:Npuls;
pulx20 = 1:20;



%% Plot STP

figure(11); clf;
plot(pulx20, stpdata.f5, pulx20, stpdata.f10,  pulx20, stpdata.f20, pulx20, stpdata.f40);    
%plot(pulx20, stpdata.f5, pulx20, stpdata.f40);    
ylim([0 3]); hold on  
%title('nz, f5, f10, f20, f40'); 

if Nf == 1
    plot(pulx, nz(:,1), 'ok');     
else
    for idx = 1:Nf
        if mod(idx, 2) == 1
            plot(pulx, nz(:, idx), 'o', 'MarkerFaceColor', clrcode(idx)); hold on
        else
            plot(pulx, nz(:, idx), 'o',  'Color', clrcode(idx)); hold on        
        end
    end

end

%%
function txt = cursorinfo(~,info)
    idx = info.DataIndex;
    x = info.Position(1);
    y = info.Position(2);
    txt = [num2str(idx),  ',   ',  num2str(x) ',   ',  num2str(y)];    
end
