function setparam(pw)

global Aca Alocal cb  kcloc kc1 kc2 Clow 
global Nsite Nmax  bSyt fw bw
global  pnb k1b Knmx b1
global kinit  g n0  Vstep syt0;

    cb = 0.05;    

    idx = 1;
    Aca  = pw(idx); idx=idx+1;
    Alocal  = pw(idx); idx=idx+1;
    kcloc = pw(idx)*1e-3; idx=idx+1; 
    kc1 = pw(idx)*1e-3; idx=idx+1; %1/ms
    kc2 = pw(idx)*1e-3; idx=idx+1; %1/ms
    Clow = pw(idx); idx=idx+1;
    Nsite = pw(idx); idx=idx+1; %number of AZ
    Nmax = pw(idx); idx=idx+1; %number of SV docking site per AZ
    pnb  = pw(idx); idx=idx+1; % baseline fusion prob.

    idx=idx+1;
    k1b = pw(idx)*1e-3; idx=idx+1; %1/ms
    b1 = pw(idx)*1e-3; idx=idx+1;
    Knmx = pw(idx)*1e-3; idx=idx+1; %1/ms

    idx=idx+1; 
    bSyt = pw(idx); idx=idx+1;   % Cooperativity of calcium binding to Syt7
    Vstep = pw(idx); idx=idx+1;   % Nr of Ca2+ binding steps to Syt7

    n0 = Nmax*k1b/(k1b+b1);
    g = n0/Nmax;
    
    kinit = [cb, cb, k1b, k1b];    %[cb, clocal, knb, knglobal]
    fprintf('n0 = %1.1f \n', n0);
    
    if bSyt
        Syts = Knmx-k1b;
        %Syt7 (Table 3, Brandt, ACS, 2012)
        kon = 7*1e-3; %1/uM/ms
        koff = 10*1e-3; %1/ms
            %For Syt1
            %kon = 15*1e-3; %1/uM/ms
            %koff = 600*1e-3; %1/ms
        bs = bSyt;
        fw = [Vstep-1:-1:1].*kon;
        bw = ones(1, Vstep-1);
        for idx=1:Vstep-1
            bw(idx) = idx*bs^(idx-1);
        end
        bw = bw.*koff;
        %bw = [1, 2*bs, 3*bs^2, 4*bs^3].*koff; 
        syt0 = initSyt(cb, fw, bw).*Syts;
    else
        Vstep = 0;
    end
    
end