function plot_clusters(data, X, ind, cln, plot_median, norm_cl, plot_sub, lineProps, lbls)
% global plt 
%% Plot clusters 
%  plot_clusters(data, X, ind, cln, plot_median, norm_cl, plot_sub, lineProps, lbls)
%
% data - what was clustered 
% X - abscissa points 
% ind - cluster membership index 
% cln - total number of clusters 
% plot_median - 1 to plot medians for each cluster, 0 - all data 
% norm_cl - normalize by median of cluster # norm_cl or none iz 0 
% plot_sub - plot in subplots or all together 
% lineProps  - properties of each line (color, thikness, etc) 
% lbls - values to use as labels for each cluster 
%  For example :
%    plot_clusters(MS2.stand_data, MS2.stages, MS2.ind, MS2.cln, 1, 1, 1, [], [])
%
plt.dump = 0;
plt.Gray = [.4 .4 .4]; 
plt.GrayLight = [.6 .6 .6]; 
plt.Cyan = [.0 1. 1.]; 
plt.Blue = [.04 .14 .98];  % MATHEMATICA  blue 
plt.Green = [.16 1. .18];  % MATHEMATICA green
plt.GreenDark = [.26 .58 0.17];  %  Dark Green
plt.Magenta = [1. 0. 1.];  % Magenta 
plt.Khaki = [.52 .38 .12]; % Khaki 
if isempty(lineProps)
    if (plot_median == 1)
      for i = 1:cln
         lineProps{i}.Color = 'Blue'; lineProps{i}.LineStyle = '-'; lineProps{i}.LineWidth = 2;  
      end
    else, 
      for i = 1:cln
         lineProps{i}.Color = plt.Gray; lineProps{i}.LineStyle = '-'; lineProps{i}.LineWidth = 1;  
      end
    end
end  
 num_rows = max(1,ceil(sqrt(cln))-2); num_cols = ceil(cln/num_rows);
 if (norm_cl == 0) 
      trend = ones(1, length(X)); 
 else
      trend = median(data(ind==norm_cl, :)); 
 end 
 figure; 
 for i=1:cln; 
     if plot_sub 
        subplot(num_rows, num_cols, i);
     else 
        hold on 
     end 
    whichG = (ind==i);
    Y = data(whichG, :); 
    if (plot_median == 1), Y = median(Y)./trend; lw = 2; end 
    ttl = sprintf('%d: %d', i, sum(ind==i)); 
    if ~isempty(lbls),  ttl = [ttl '  ' sprintf('%.2f',lbls(i))];end
    if ~isempty(Y), 
        h1 = plot(X, Y'); 
        set(h1,'Color',lineProps{i}.Color)
        set(h1,'LineStyle',lineProps{i}.LineStyle,'LineWidth',lineProps{i}.LineWidth) 
        % hold on; plot(X, median(Y), 'Color', plt.Green)
        title(ttl,'FontSize',12, 'FontWeigh', 'Bold');
        set(gca,'xlim',[min(X), max(X)]); set(gca,'ylim',[0, max(0.9, quantile(Y(:),.995)+.5 )]);
        set(gca,'FontSize',12, 'FontWeigh', 'Bold'); 
    end 
    %pause
 end
end
