A = readtable('deaf_control_follow_no_cont.xlsx');
transist = A.numberOfPatches_transistor(A.numberOfPatches_transistor~=0|A.numberOfPatches_Speaker~=0);
Speaker = A.numberOfPatches_Speaker(A.numberOfPatches_transistor~=0|A.numberOfPatches_Speaker~=0);
figure;    
boxplot([Speaker,transist],'Colors',	[0 0 0],'labels',{'Drought sounds','Silence'},'Colors',	[0 0 0],'Symbol','o')
lines = findobj(gcf, 'type', 'line', 'Tag', 'Median');
set(lines,'linewidth',3);
set(lines,'linewidth',3);
h=findobj('LineStyle','--'); set(h, 'LineStyle','-');
set(gca,'FontSize',40)
set(gca,'linew',2)
set(findobj(gca,'Tag','Box'),'LineWidth',4)
ylabel(' Proportion of time','FontSize',40)
ylim([-0.1 1.2])
box off
hold on
med  = [median(Speaker),median(transist)];
plot(med,'rx-','MarkerSize',10,'Color','k','LineWidth',2)
    
droughtM =mean(Speaker);droughtsd =std(Speaker);
tranM =mean(transist);transd =std(transist);

model = fitglme(A, 'Clutches ~  right + (1 | NumberOfMoths)+(1 | right)+(1 | up_down_side)');
