clear
data = readtable('data.xlsx');

data.ObservationdateNum=datenum(data.ObservationDate);
dataDry = data(strcmp(data.SideExamined,'Dry') | strcmp(data.SideExamined,'Wet'),:);
dataDeaf = data(data.x_Experiment==3,:);
data = data(data.x_Experiment~=1&data.x_Experiment~=3,:);

data.Experiment = categorical(data.Experiment);
data.TypeOfControl = categorical(data.TypeOfControl);
data.SideOfSpeaker = categorical(data.SideOfSpeaker);

dataDry.Experiment = categorical(dataDry.Experiment);
dataDry.TypeOfControl = categorical(dataDry.TypeOfControl);
dataDry.SideOfSpeaker = categorical(dataDry.SideOfSpeaker);

dataDeaf.SideOfSpeaker = categorical(dataDeaf.SideOfSpeaker);


d=1;

%% check if season doesn't affect the result before combining them
% Drought sounds(Origami)
results_season = table;
find_num =data.x_Experiment==2;
Origami_60=data(data.x_Experiment==2,:);
cluster = fitglme(Origami_60,'ClustersOfEggs ~ 1 + SideExamined + Season + NumberOfFemales + (1|Month) + (1|Repetition) + (1|Arena) + (1|ObservationdateNum)','Distribution','poisson');

%N of repetitions and observations
results_season.experiment(1) = {'Drought sounds 60 per minute '};
results_season.observations(1) = length(find_num)./2;
results_season.repetitions(1) = length(unique(data.Repetition(find_num)));
results_season.NumberOfClusters(1) = sum(data.ClustersOfEggs(find_num));

% Plants
Plants_60=data(data.x_Experiment==5,:);
find_num = data.x_Experiment==5;
cluster = fitglme(Plants_60,'ClustersOfEggs ~ 1 + SideExamined + Season + NumberOfFemales + (1|Month) + (1|Repetition) + (1|Arena) + (1|ObservationdateNum)','Distribution','poisson');

results_season.experiment(2) = {'Plants_60 per minute'};
results_season.pValue_cluster(2) = cluster.Coefficients.pValue(2);
results_season.estimate_cluster(2) = cluster.Coefficients.Estimate(2);

%N of repetitions and observations
results_season.observations(2) = length(find_num)./2;
results_season.repetitions(2) = length(unique(data.Repetition(find_num)));
results_season.NumberOfClusters(2) = sum(data.ClustersOfEggs(find_num));
%% Stats
results = table;
experiments = categories(data.Experiment);

for i = 1:length(experiments)
    
    % GLME
    find_num=find(data.Experiment== experiments{i});
    cluster = fitglme(data(find_num,:),'ClustersOfEggs ~ 1 + SideExamined + (1|Season) + (1|Month) + (1|Repetition) + (1|Arena) + (1|ObservationdateNum)','Distribution','poisson');
    
    % GLME results
    results.treatment{d,1}=experiments{i};
    results.cluster_pValue(d) = cluster.Coefficients.pValue(size(cluster.Coefficients.Estimate,1));
    results.cluster_estimate(d) = cluster.Coefficients.Estimate(size(cluster.Coefficients.Estimate,1));
    
    % mean & std player
    cur = data(find_num,:);
    comp=unique(cur.SideExamined);
    find_num_mean=find(data.Experiment == experiments{i} & strcmp(data.SideExamined, comp{1}));
    results.meanClusterTreatment(d)= mean(data.ClustersOfEggs(find_num_mean));
    results.stdClusterTreatment(d)= std(data.ClustersOfEggs(find_num_mean));
    
    % mean & std control
    find_num_mean=find(data.Experiment == experiments{i} &  strcmp(data.SideExamined, comp{2}));
    results.meanClusterControl(d) = mean(data.ClustersOfEggs(find_num_mean));
    results.stdClusterControl(d) = std(data.ClustersOfEggs(find_num_mean));
    
    %N of repetitions and observations
    results.observations(d) = length(find_num)./2;
    results.repetitions(d) = length(unique(data.Repetition(find_num)));
    results.NumberOfClusters(d) = sum(data.ClustersOfEggs(find_num));
    
    d = d+1;
end

%% Stats Wet-dry

cluster = fitglme(dataDry,'ClustersOfEggs ~ 1 + SideExamined + (1|Month) + (1|Repetition) + (1|Arena) + (1|ObservationdateNum)','Distribution','poisson');

% GLME results
results.treatment{d,1} = 'Wet-dry plant (control=wet)';
results.cluster_pValue(d) = cluster.Coefficients.pValue(size(cluster.Coefficients.Estimate,1));
results.cluster_estimate(d) = cluster.Coefficients.Estimate(size(cluster.Coefficients.Estimate,1));

% mean & std player
find_num_mean=strcmp(dataDry.SideExamined, 'Dry');
results.meanClusterTreatment(d)= mean(dataDry.ClustersOfEggs(find_num_mean));
results.stdClusterTreatment(d)= std(dataDry.ClustersOfEggs(find_num_mean));

% mean & std control
find_num_mean=strcmp(dataDry.SideExamined, 'Wet');
results.meanClusterControl(d) = mean(dataDry.ClustersOfEggs(find_num_mean));
results.stdClusterControl(d) = std(dataDry.ClustersOfEggs(find_num_mean));

%N of repetitions and observations
results.observations(d) = height(dataDry)./2;
results.repetitions(d) = length(unique(dataDry.Repetition));
results.NumberOfClusters(d) = sum(dataDry.ClustersOfEggs);

d = d+1;
%% Stats for 2 repetitions - Origami and plants
experiments = categories(data.Experiment);

for i = [3,5]
    for j = 1:2
        % GLME
        find_num=find(data.Experiment== experiments{i} & data.Season == j);
        cluster = fitglme(data(find_num,:),'ClustersOfEggs ~ 1 + SideExamined + (1|Month) + (1|Repetition) + (1|Arena) + (1|ObservationdateNum)','Distribution','poisson');
        
        % GLME results
        results.treatment{d,1}=sprintf('%s_%d',experiments{i},j);
        results.cluster_pValue(d) = cluster.Coefficients.pValue(size(cluster.Coefficients.Estimate,1));
        results.cluster_estimate(d) = cluster.Coefficients.Estimate(size(cluster.Coefficients.Estimate,1));
        
        % mean & std player
        comp = unique(data.SideExamined(data.Experiment == experiments{i}));
        find_num_mean=find(data.Experiment == experiments{i} & data.Season == j & strcmp(data.SideExamined,comp{1}));
        results.meanClusterTreatment(d)= mean(data.ClustersOfEggs(find_num_mean));
        results.stdClusterTreatment(d)= std(data.ClustersOfEggs(find_num_mean));
        
        % mean & std control
        find_num_mean=find(data.Experiment == experiments{i} & data.Season == j & strcmp(data.SideExamined,comp{2}));
        results.meanClusterControl(d) = mean(data.ClustersOfEggs(find_num_mean));
        results.stdClusterControl(d) = std(data.ClustersOfEggs(find_num_mean));
        
        %N of repetitions and observations
        results.observations(d) = length(find_num)./2;
        results.repetitions(d) = length(unique(data.Repetition(find_num)));
        results.NumberOfClusters(d) = sum(data.ClustersOfEggs(find_num));
    
        d = d+1;
    end
end 

%% Deaf moths experiments
dataDeaf.Arena = categorical(dataDeaf.Arena); 
cluster = fitglme(dataDeaf,'ClustersOfEggs ~ SideOfSpeaker +( 1 |NumberOfFemales)+(1 | SideOfSpeaker ) +( 1 | Arena)');
% GLME results
results.treatment{end+1}='Deaf females drought sounds_60 per minute';
results.cluster_pValue(end) = cluster.Coefficients.pValue(size(cluster.Coefficients.Estimate,1));
results.cluster_estimate(end) = cluster.Coefficients.Estimate(size(cluster.Coefficients.Estimate,1));

% mean & std player
results.meanClusterTreatment(end)= mean(dataDeaf.ClustersOfEggs(strcmp(dataDeaf.SideExamined,'Drought sounds')));
results.stdClusterTreatment(end)= std(dataDeaf.ClustersOfEggs(strcmp(dataDeaf.SideExamined,'Drought sounds')));

% mean & std control
results.meanClusterControl(end)= mean(dataDeaf.ClustersOfEggs(strcmp(dataDeaf.SideExamined,'Silence')));
results.stdClusterControl(end)= std(dataDeaf.ClustersOfEggs(strcmp(dataDeaf.SideExamined,'Silence')));

%N of repetitions and observations
results.observations(end) = height(dataDeaf)./2;
results.repetitions(end) = length(unique(dataDeaf.Repetition));
results.NumberOfClusters(end) = sum(dataDeaf.ClustersOfEggs);

%% Export to excel tables
writetable(results,'results_New.xlsx')
writetable(results_season,'results_season_New.xlsx')