%plotting scatter over image over time
close;clear;clc
file_names = dir('*310_*.csv');
file =  {file_names.name}'; 
tracking_f = cell(1,length(file));
moth_01 = [];moth_02 =moth_01;moth_03 =moth_01;moth_04 =moth_01;
for idx = 1:length(file)
    tracking_f(idx) =  {readmatrix(file{idx})}; %all of the dir files
    moth_01 = [moth_01;tracking_f{idx}(:,1),tracking_f{idx}(:,2)];
    moth_02 = [moth_02;tracking_f{idx}(:,3),tracking_f{idx}(:,4)];
    moth_03 = [moth_03;tracking_f{idx}(:,5),tracking_f{idx}(:,6)];
    moth_04 = [moth_04;tracking_f{idx}(:,7),tracking_f{idx}(:,8)];
end
c1 = linspace(0,360,length(moth_01(:,2)));
c2 = linspace(0,360,length(moth_02(:,2)));
c3 = linspace(0,360,length(moth_03(:,2)));
c4 = linspace(0,360,length(moth_04(:,2)));

v = VideoReader('first_night.mp4');
V = readFrame(v);
% %%
% figure;
% imagesc(V);
% hold on
% scatter(moth_01(:,1),moth_01(:,2),[],c1,'filled')
% colorbar
% set(gca,'FontSize',15)
% 
% figure;
% imagesc(V);
% hold on
% scatter(moth_02(:,1),moth_02(:,2),[],c2,'filled')
% colorbar
% set(gca,'FontSize',15)
% 
% figure;
% 
% imagesc(V);
% hold on
% scatter(moth_03(:,1),moth_03(:,2),[],c3,'filled')
% colorbar
% set(gca,'FontSize',15)
% 
% figure;
% imagesc(V);
% hold on
% scatter(moth_04(:,1),moth_04(:,2),[],c4,'filled')
% colorbar
% set(gca,'FontSize',15)

%% load the other data set
clearvars -except moth_01 moth_02 moth_03 moth_04 V
file_names = dir('*314_*.csv');
file =  {file_names.name}'; 
tracking_f = cell(1,length(file));
moth_05 = [];moth_06 =moth_05;moth_07 =moth_05;moth_08 =moth_05;

for idx = 1:length(file)
    tracking_f(idx) =  {readmatrix(file{idx})}; %all of the dir files
    moth_05 = [moth_01;tracking_f{idx}(:,1),tracking_f{idx}(:,2)];
    moth_06 = [moth_02;tracking_f{idx}(:,3),tracking_f{idx}(:,4)];
    moth_07 = [moth_03;tracking_f{idx}(:,5),tracking_f{idx}(:,6)];
    moth_08 = [moth_04;tracking_f{idx}(:,7),tracking_f{idx}(:,8)];
end

c5 = linspace(0,360,length(moth_05(:,2)));
c6 = linspace(0,360,length(moth_06(:,2)));
c7 = linspace(0,360,length(moth_07(:,2)));
c8 = linspace(0,360,length(moth_08(:,2)));


%%
file_names_3 = dir('*2306*_xypts.csv');
file3 =  {file_names_3.name}'; 
tracking_f3 = cell(1,length(file3));
moth_09 = [];moth_10 =moth_09;moth_11 =moth_10;moth_12 =moth_10;
moth_13 =moth_11;
for idx = 1:length(file3)
    tracking_f3(idx) =  {readmatrix(file3{idx})}; %all of the dir files
    moth_09 = [moth_09;tracking_f3{idx}(:,1),tracking_f3{idx}(:,2)];
    moth_10 = [moth_10;tracking_f3{idx}(:,3),tracking_f3{idx}(:,4)];
    moth_11 = [moth_11;tracking_f3{idx}(:,5),tracking_f3{idx}(:,6)];
    moth_12 = [moth_12;tracking_f3{idx}(:,7),tracking_f3{idx}(:,8)];
    moth_13 = [moth_13;tracking_f3{idx}(:,9),tracking_f3{idx}(:,10)];
end


c9 = linspace(0,480,length(moth_09(:,2)));
c10 = linspace(0,480,length(moth_10(:,2)));
c11 = linspace(0,480,length(moth_11(:,2)));
c12= linspace(0,480,length(moth_12(:,2)));
c13 = linspace(0,480,length(moth_13(:,2)));

%%
v2 = VideoReader('second_night.mp4');
V2 = readFrame(v2);
figure;
imagesc(V2);
hold on
scatter(moth_06(:,1),moth_06(:,2),[],c6,'filled')
colorbar
set(gca,'FontSize',15)

% figure;
% imagesc(V);
% hold on
% scatter(moth_07(:,1),moth_07(:,2),[],c7,'filled')
% colorbar
% set(gca,'FontSize',15)
% 
% figure;
% 
% imagesc(V);
% hold on
% scatter(moth_08(:,1),moth_08(:,2),[],c8,'filled')
% colorbar
% set(gca,'FontSize',15)
% 
% figure;
% imagesc(V);
% hold on
% scatter(moth_09(:,1),moth_09(:,2),[],c9,'filled')
% colorbar
% set(gca,'FontSize',15)
% %%
%the border between the sides
septum = ([400.0269,315.9548;403.6398  485.4529]);
septum_2 = ([385.5753 ,256.0312 ;390.3925, 429.8096]);
septum_3 = ([340,0,319,0 ]);
moth_01_plus = sum(septum(1)<moth_01(:,1))/sum(~isnan(moth_01(:,1)));
moth_02_plus = sum(septum(1)<moth_02(:,1))/sum(~isnan(moth_02(:,1)));
moth_03_plus = sum(septum(1)<moth_03(:,1))/sum(~isnan(moth_03(:,1)));
moth_04_plus = sum(septum(1)<moth_04(:,1))/sum(~isnan(moth_04(:,1)));
moth_05_plus = sum(septum_2(1)>moth_05(:,1))/sum(~isnan(moth_05(:,1)));
moth_06_plus = sum(septum_2(1)>moth_06(:,1))/sum(~isnan(moth_06(:,1)));
moth_07_plus = sum(septum_2(1)>moth_07(:,1))/sum(~isnan(moth_07(:,1)));
moth_08_plus = sum(septum_2(1)>moth_08(:,1))/sum(~isnan(moth_08(:,1)));
moth_09_plus = sum(septum_3(1)>moth_09(:,1))/sum(~isnan(moth_09(:,1)));
moth_10_plus = sum(septum_3(1)>moth_10(:,1))/sum(~isnan(moth_10(:,1)));
moth_11_plus = sum(septum_3(1)>moth_11(:,1))/sum(~isnan(moth_11(:,1)));
moth_12_plus = sum(septum_3(1)>moth_12(:,1))/sum(~isnan(moth_12(:,1)));
moth_13_plus = sum(septum_3(1)>moth_13(:,1))/sum(~isnan(moth_13(:,1)));

plus_sum = [moth_01_plus(end/2:end),moth_02_plus(end/2:end),moth_03_plus(end/2:end),moth_04_plus(end/2:end),moth_05_plus(end/2:end),moth_06_plus(end/2:end),moth_07_plus(end/2:end),moth_08_plus(end/2:end)...
    ,moth_09_plus(end/2:end),moth_10_plus(end/2:end),moth_11_plus(end/2:end),moth_12_plus(end/2:end),moth_13_plus(end/2:end)]';

moth_01_minus = sum(septum(1)>moth_01(:,1))/sum(~isnan(moth_01(:,1)));
moth_02_minus = sum(septum(1)>moth_02(:,1))/sum(~isnan(moth_02(:,1)));
moth_03_minus = sum(septum(1)>moth_03(:,1))/sum(~isnan(moth_03(:,1)));
moth_04_minus = sum(septum(1)>moth_04(:,1))/sum(~isnan(moth_04(:,1)));
moth_05_minus = sum(septum_2(1)<moth_05(:,1))/sum(~isnan(moth_05(:,1)));
moth_06_minus = sum(septum_2(1)<moth_06(:,1))/sum(~isnan(moth_06(:,1)));
moth_07_minus = sum(septum_2(1)<moth_07(:,1))/sum(~isnan(moth_07(:,1)));
moth_08_minus = sum(septum_2(1)<moth_08(:,1))/sum(~isnan(moth_08(:,1)));
moth_09_minus = sum(septum_3(3)>moth_09(:,1))/sum(~isnan(moth_09(:,1)));
moth_10_minus = sum(septum_3(3)>moth_10(:,1))/sum(~isnan(moth_10(:,1)));
moth_11_minus = sum(septum_3(3)>moth_11(:,1))/sum(~isnan(moth_11(:,1)));
moth_12_minus = sum(septum_3(3)>moth_12(:,1))/sum(~isnan(moth_12(:,1)));
moth_13_minus = sum(septum_3(3)>moth_13(:,1))/sum(~isnan(moth_13(:,1)));

minus_sum = [moth_01_minus(end/2:end),moth_02_minus(end/2:end),moth_03_minus(end/2:end),moth_04_minus(end/2:end),moth_05_minus(end/2:end),moth_06_minus(end/2:end),moth_07_minus(end/2:end),moth_08_minus(end/2:end)...
   ,moth_09_minus(end/2:end),moth_10_minus(end/2:end),moth_11_minus(end/2:end),moth_12_minus(end/2:end),moth_13_minus(end/2:end) ]';

figure;    
boxplot([plus_sum,minus_sum],'Colors',	[0 0 0],'labels',{'Drought sounds','Silence'},'Colors',	[0 0 0])
set(gca,'FontSize',40)
set(gca,'linew',4)
set(findobj(gca,'Tag','Box'),'LineWidth',3)
ylabel('Relative time','FontSize',40)
ylim([-0.1 1.2])
box off
hold on
plot([median(plus_sum),median(minus_sum)],'k','Marker','x')
mean(plus_sum)
std(plus_sum)

 %% table for stats
mo1 = double(septum(1)>moth_01(:,1));mo_num1 = ones(length(mo1),1);mo_time1 = [1:length(mo1)]';
mo1(isnan(moth_01(:,1))) = nan;
mo2 = double(septum(1)>moth_02(:,1));mo_num2 = ones(length(mo2),1)*2;mo_time2 = [1:length(mo2)]';
mo2(isnan(moth_02(:,1))) = nan;
mo3 = double(septum(1)>moth_03(:,1));mo_num3 = ones(length(mo3),1)*3;mo_time3 = [1:length(mo3)]';
mo3(isnan(moth_03(:,1))) = nan;
mo4 = double(septum(1)>moth_04(:,1));mo_num4 = ones(length(mo4),1)*4;mo_time4 = [1:length(mo4)]';
mo4(isnan(moth_04(:,1))) = nan;
mo5 = double(septum_2(1)>moth_05(:,1));mo_num5 = ones(length(mo5),1)*5;mo_time5 = [1:length(mo5)]';
mo5(isnan(moth_05(:,1))) = nan;
mo6 = double(septum_2(1)>moth_06(:,1));mo_num6 = ones(length(mo6),1)*6;mo_time6 = [1:length(mo6)]';
mo6(isnan(moth_06(:,1))) = nan;
mo7 = double(septum_2(1)>moth_07(:,1));mo_num7 = ones(length(mo7),1)*7;mo_time7 = [1:length(mo7)]';
mo7(isnan(moth_07(:,1))) = nan;
mo8 = double(septum_2(1)>moth_08(:,1));mo_num8 = ones(length(mo8),1)*8;mo_time8 = [1:length(mo8)]';
mo8(isnan(moth_08(:,1))) = nan;
mo9 = double(septum_3(1)>moth_09(:,1));mo_num9 = ones(length(mo9),1)*9;mo_time9 = [1:length(mo9)]';
mo9(isnan(moth_09(:,1))) = nan;
mo10 = double(septum_3(1)>moth_10(:,1));mo_num10 = ones(length(mo10),1)*10;mo_time10 = [1:length(mo10)]';
mo10(isnan(moth_10(:,1))) = nan;
mo11 = double(septum_3(1)>moth_11(:,1));mo_num11 = ones(length(mo11),1)*11;mo_time11 = [1:length(mo11)]';
mo11(isnan(moth_11(:,1))) = nan;
mo12 = double(septum_3(1)>moth_12(:,1));mo_num12 = ones(length(mo12),1)*12;mo_time12 = [1:length(mo12)]';
mo12(isnan(moth_12(:,1))) = nan;
mo13 = double(septum_3(1)>moth_13(:,1));mo_num13 = ones(length(mo13),1)*13;mo_time13 = [1:length(mo13)]';
mo13(isnan(moth_13(:,1))) = nan;

mos = [mo1;mo2;mo3;mo4;mo5;mo6;mo7;mo8;mo9;mo10;mo11;mo12;mo13];
mos_num = [mo_num1;mo_num2;mo_num3;mo_num4;mo_num5;mo_num6;mo_num7;mo_num8;mo_num9;mo_num10;mo_num11;mo_num12;mo_num13];
mos_side = mos_num<5|mos_num>8;
mo_times = [mo_time1;mo_time2;mo_time3;mo_time4;mo_time5;mo_time6;mo_time7;mo_time8;mo_time9;mo_time10;mo_time11;mo_time12;mo_time13];
LR_1 = length(mo1)+length(mo2)+length(mo3)+length(mo4);
LR_2 = length(mo1)+length(mo2)+length(mo3)+length(mo4)+length(mo5)+length(mo6)+length(mo7)+length(mo8);
LR = [mos(1:LR_1)==1;mos(LR_1+1:LR_2)==0;mos(LR_2+1:end)==1];
T  = table(mos,mos_num,mos_side,mo_times,LR); 
%% crosses from one side to the other
moth_01_x = moth_01(:,1);moth_01_x = moth_01_x(~isnan(moth_01_x));
moth_01_x_before = moth_01(:,1);moth_01_x = moth_01_x(~isnan(moth_01_x));

moth_02_x = moth_02(:,1);moth_02_x = moth_02_x(~isnan(moth_02_x));
moth_02_x_before = moth_02(:,1);moth_02_x = moth_02_x(~isnan(moth_02_x));

moth_03_x = moth_03(:,1);moth_03_x = moth_03_x(~isnan(moth_03_x));
moth_04_x = moth_04(:,1);moth_04_x = moth_04_x(~isnan(moth_04_x));
moth_04_x_before = moth_04(:,1);moth_04_x = moth_04_x(~isnan(moth_04_x));


moth_05_x = moth_05(:,1);moth_05_x = moth_05_x(~isnan(moth_05_x));
moth_06_x = moth_06(:,1);moth_06_x = moth_06_x(~isnan(moth_06_x));
moth_06_x_before = moth_06(:,1);moth_06_x = moth_06_x(~isnan(moth_06_x));


moth_07_x = moth_07(:,1);moth_07_x = moth_07_x(~isnan(moth_07_x));
moth_08_x = moth_08(:,1);moth_08_x = moth_08_x(~isnan(moth_08_x));


moth_09_x = moth_09(:,1);moth_09_x = moth_09_x(~isnan(moth_09_x));
moth_10_x = moth_10(:,1);moth_10_x = moth_10_x(~isnan(moth_10_x));
moth_11_x = moth_11(:,1);moth_11_x = moth_11_x(~isnan(moth_11_x));
moth_12_x = moth_12(:,1);moth_12_x = moth_12_x(~isnan(moth_12_x));
moth_13_x = moth_13(:,1);moth_13_x = moth_13_x(~isnan(moth_13_x));

cross_num_1=sum(abs((diff(septum(1)<moth_01_x))));
cross_num_2=sum(abs((diff(septum(1)<moth_02_x))));
cross_num_3=sum(abs((diff(septum(1)<moth_03_x))));
cross_num_4=sum(abs((diff(septum(1)<moth_04_x))));
cross_num_5=sum(abs((diff(septum_2(1)<moth_05_x))));
cross_num_6=sum(abs((diff(septum_2(1)<moth_06_x))));
cross_num_7=sum(abs((diff(septum_2(1)<moth_07_x))));
cross_num_8=sum(abs((diff(septum_2(1)<moth_08_x))));
cross_num_9=sum(abs((diff(septum_3(1)>moth_09_x))));
cross_num_10=sum(abs((diff(septum_3(1)>moth_10_x))));
cross_num_11=sum(abs((diff(septum_3(1)>moth_11_x))));
cross_num_12=sum(abs((diff(septum_3(1)>moth_12_x))));
cross_num_13=sum(abs((diff(septum_3(1)>moth_13_x))));

cross_vec =[cross_num_1,cross_num_2,cross_num_3,cross_num_4,cross_num_5,cross_num_6,cross_num_7,cross_num_8,cross_num_9,cross_num_10,cross_num_12,cross_num_13];
crossnum  = sum(cross_vec);
crossnum_avg  = mean(cross_vec(cross_vec~=0));
crossnum_std  = std(cross_vec(cross_vec~=0));
num_zero_cross = sum(cross_vec==0)/length(cross_vec);
%%
delta_01 = 100;%length(mo1(:,1))/12
delta_02 = 128;
delta_03 = 12698;
%how to calc this?
moth_01_location=(binerize(mo1(:,1),delta_01)')./delta_01.*100;
moth_02_location=(binerize(mo2(:,1),delta_01)')./delta_01.*100;
moth_03_location=(binerize(mo3(:,1),delta_01)')./delta_01.*100;
moth_04_location=(binerize(mo4(:,1),delta_01)')./delta_01.*100;
moth_05_location=(binerize(mo5(:,1),delta_02)')./delta_02.*100;
moth_06_location=(binerize(mo6(:,1),delta_02)')./delta_02.*100;
moth_07_location=(binerize(mo7(:,1),delta_02)')./delta_02.*100;
moth_08_location=(binerize(mo8(:,1),delta_02)')./delta_02.*100;
moth_09_location=(binerize(mo9(:,1),delta_03)')./delta_03.*100;
moth_10_location=(binerize(mo10(:,1),delta_03)')./delta_03.*100;
moth_11_location=(binerize(mo11(:,1),delta_03)')./delta_03.*100;
moth_12_location=(binerize(mo12(:,1),delta_03)')./delta_03.*100;
moth_13_location=(binerize(mo13(:,1),delta_03)')./delta_03.*100;

%%
%the time devided to 30 min parts (relative)
time_01 = linspace(1,6,length(moth_01_location))./6;
time_02 = linspace(1,6,length(moth_05_location))./6;
time_03 = linspace(1,6,length(moth_09_location))./6;
moths_loc_01 = [moth_01_location;moth_02_location;moth_03_location;moth_04_location];
moths_loc_02=[moth_05_location;moth_06_location;moth_07_location;moth_08_location];
moths_loc_03=[moth_09_location;moth_10_location;moth_11_location;moth_12_location;moth_13_location;];

moths_loc_mat = [moth_01_location,moth_02_location,moth_03_location,moth_04_location,moth_05_location,moth_06_location,moth_07_location,moth_08_location...
    ,moth_09_location,moth_10_location,moth_11_location,moth_12_location,moth_13_location];

avg_loc = nanmean(moths_loc_mat,2);
sd_loc =  nanstd(moths_loc_mat,0,2);
times_moth_01 = repmat(time_01,1,4);
times_moth_02 = repmat(time_02,1,4);
times_moth_03 = repmat(time_03,1,4);


figure;
scatter(time_01.*6,avg_loc,200,[.7 .7 .7],'filled');
hold on
e = errorbar(time_01.*6,avg_loc,sd_loc,'LineWidth',7);
e.Color = 'k';
set(gca,'FontSize',20)
    set(gca,'linew',5)
    set(findobj(gca,'Tag','Box'),'LineWidth',40)
    box off
    xlim([1 6.5])
    ylim([0 120])
ylabel({'Percentage of time spent in';'the playback side'},'Fontsize',33)
xlabel('Time from the beginning of the trial (hours)','Fontsize',33)

%% stats
m1 = fitglme(T,'mos~mo_times+(1|mos_num)+(1|mos_side)','Distribution','Binomial','link','logit');
m2 = fitglme(T,'LR~mos+(1|mos_num)+(1|mos_side)','Distribution','Binomial');
m1.Coefficients.pValue
m2.Coefficients.pValue
