rm(list = ls())
#Exploring moths data set
#### libraries ----
library("brms")
library("bayestestR")
library("dplyr")
library("ggplot2")
### functions ----
model_brm <- function(myFormula,myData,specifing_experiment,myPrior){
  model <- brm(
    formula = myFormula,
    data = myData |> filter(experiment == specifing_experiment),
    family = gaussian(),
    prior = myPrior,
    chains = 4,
    warmup = 1000, 
    iter = 8000,
    #  sample_prior = "only",
    cores = 8,
    backend = "cmdstanr",
    silent = 0
  )
  return(model)
}


model_brm_prior <- function(myFormula,myData,specifing_experiment,myPrior){
  model <- brm(
    formula = myFormula,
    data = myData |> filter(experiment == specifing_experiment),
    family = gaussian(),
    prior = myPrior,
    chains = 4,
    warmup = 1000, 
    iter = 8000,
    sample_prior = "only",
    cores = 8,
    backend = "cmdstanr",
    silent = 0
  )
  return(model)
}

#### load data ----
df <- read.csv("data_table_logistic.csv")

df = data.frame(experiment = factor(df$Experiment),
                female_count = df$ Number_of_females,
                side = df$Side_of_speaker,
                y = df$Logistic_count)

#### brms linear ----
formula_01 <- bf(y ~  1 + (1 | female_count))
prior_01 <- prior(normal(0.5, 0.1), class = "Intercept")
experiments_names <- unique(df$experiment)
models_list <- list()

for (experiment_temp in experiments_names){
  model <- model_brm(formula_01,df,experiment_temp,prior_01)
  params <- insight::get_parameters(model) |> select(b_Intercept)
  probability_of_choosing <- sum(params$b_Intercept>=0.5) / length(params$b_Intercept)
  
  models_list[[experiment_temp]] <- list(
    "model" = model,
    "parameters" = params,
    "summary" = probability_of_choosing
  )  
  
}

# prior_summary(model)
# describe_posterior(model, ci = 0.95)
#plot(model)
#params <- insight::get_parameters(model) |> select(b_Intercept)
#sum(params$b_Intercept>=0.5) / length(params$b_Intercept)

#> we found a 99.5 percent chance that the probability of choosing the wet plant is higher then 50%








#### inverted df ----
df$y_tag <- 1-df$y
# the model
formula_02 <- bf(y_tag ~  1 + (1 | female_count))
models_list_tag <- list()

for (experiment_temp in experiments_names){
  model_tag <- model_brm_prior(formula_02,df,experiment_temp,prior_01)
  params_tag <- insight::get_parameters(model_tag) |> select(b_Intercept)
  probability_of_choosing_tag <- sum(params_tag$b_Intercept>=0.5) / length(params$b_Intercept)
  
  models_list_tag[[experiment_temp]] <- list(
    "model" = model_tag,
    "parameters" = params_tag,
    "summary" = probability_of_choosing_tag
  )  
  
}
for (fig in experiments_names) {
  # Filter out non-finite values in the b_Intercept column
  filtered_data <- models_list[[fig]]$parameters[is.finite(models_list[[fig]]$parameters$b_Intercept), "b_Intercept"]
  filtered_data_tag <- models_list_tag[[fig]]$parameters[is.finite(models_list_tag[[fig]]$parameters$b_Intercept), "b_Intercept"]
  
  # Create new data frames with filtered b_Intercept values
  filtered_data <- data.frame(b_Intercept = filtered_data)
  filtered_data_tag <- data.frame(b_Intercept = filtered_data_tag)
  
  # Calculate mean and standard deviation for the filtered data
  #mean_value <- mean(df[df$experiment==fig,]$y)
  #std_value <- sd(df[df$experiment==fig,]$y)
  
  stats_text <- paste0(round(mean_value, 2), " ± ", round(std_value, 2))
  
  pl <- ggplot() +
    geom_density(data = filtered_data, aes(x = b_Intercept), size = 3) + # Original density plot
    geom_density(data = filtered_data_tag, aes(x = b_Intercept), size = 3, linetype = "dashed") + # Dashed density plot for filtered_data_tag
    xlim(0, 1) +
    ylim(0, 6) +
    theme_bw() +
    theme(
      text = element_text(size = 45), 
      plot.title = element_blank(), 
      panel.background = element_blank(),
      panel.border = element_blank(),
      axis.line = element_line(size = 1.5), 
      axis.title = element_text(size = 55)
    ) +
    labs(title = fig) +
    xlab("Probability") + 
    ylab("Density") +     

  filename <- paste0(fig, "_density_plot.png")
  # ggsave(filename, plot = pl, width = 10, height = 6, dpi = 300)
  #print(pl)  
}
