setwd("C:/Users/guyze/OneDrive/Documents/moths/T_maze_experiment") 
# Original dataframe
df <- read.csv("Coridor_experiment_notebook.csv")

# Create the expanded dataframe
expanded_df <- df[rep(1:nrow(df), df$Number.of.eggs.in.the.cluster), ]
expanded_df$egg_count <- 1  # Each row now represents a single egg

# Recalculate distance and speaker side
expanded_df$distance <- expanded_df$Cluster.s.location - 75  # Center distance around 0

# randomization
expanded_df$random_sample = sample(c(1,-1),size = 1563,replace = TRUE)
expanded_df$random_location = expanded_df$distance*expanded_df$random_sample

ks_test_result <- ks.test(expanded_df$random_location, expanded_df$distance)
print(ks_test_result)


ggplot() +
  geom_density(data = df, aes(x = Cluster.s.location - 75), size = 2) + # Original density plot
  geom_density(data = expanded_df, aes(x = random_location), size = 2, linetype = "dashed") +
  labs(x = "Distance (cm)",
       y = "Clusters density") +
  scale_x_continuous(breaks = c(-75, 0, 75), limits = c(-80, 80)) +
  theme_minimal()+
  theme(
    text = element_text(size = 45),  # Enhance the size of the numbers (tick labels)
    plot.title = element_blank(),    # Remove the title
    panel.background = element_blank(), # Remove the panel background
    panel.border = element_blank(),   # Remove the panel border
    axis.line = element_line(size = 1.5), # Keep the axes lines
    axis.title = element_text(size = 55),  # Enhance and bold the axis titles
    plot.margin = margin(20, 10, 10, 10)  # Increase top margin for more space
    
  )  




# randomization
df_rep <- df[rep(1:nrow(df), 1:nrow(df)), ]

df_rep$distance  = df_rep$Cluster.s.location - 75  # Center distance around 0
df_rep$random_sample_clusters = sample(c(1,-1),size = nrow(df_rep),replace = TRUE)
df_rep$random_location_clusters = df_rep$distance*df_rep$random_sample_clusters

ks_test_result_eggs <- ks.test(df_rep$random_location_clusters, df_rep$distance)
print(ks_test_result_eggs)


ggplot() +
  geom_density(data = df, aes(x = Cluster.s.location-75,weight = Number.of.eggs.in.the.cluster), size = 2) + # Original density plot
  geom_density(data = df_rep, aes(x = random_location_clusters,weight =Number.of.eggs.in.the.cluster ), size = 2, linetype = "dashed") +
  labs(x = "Distance (cm)",
       y = "Eggs density") +
  scale_x_continuous(breaks = c(-75, 0, 75), limits = c(-80, 80)) +
  
    theme_minimal()+
  theme(
    text = element_text(size = 45),  # Enhance the size of the numbers (tick labels)
    plot.title = element_blank(),    # Remove the title
    panel.background = element_blank(), # Remove the panel background
    panel.border = element_blank(),   # Remove the panel border
    axis.line = element_line(size = 1.5), # Keep the axes lines
    axis.title = element_text(size = 55),  # Enhance and bold the axis titles
    plot.margin = margin(20, 10, 10, 10)  # Increase top margin for more space
    
    )
  




