#pragma rtGlobals=3		// Use modern global access method and strict wave access.
#include <FilterDialog> menus=0
#include <AxisSlider>

Menu "Macros"
	"LoadEPGs"
	"GetSpikes"
	"Analyze", AnalyzeData()
End

//////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////
Function/S LoadEPGs()
	
	variable SampleRate=500
	variable gain=12
	variable ADC=24
	
	string WName
	string FileNote
	
	Variable refNum
	String message = "Select one or more files"
	String outputPaths
	String fileFilters = "Data Files (*.txt,*.dat,*.csv):.txt,.dat,.csv;"
	fileFilters += "All Files:.*;"
 
	Open /D /R /MULT=1 /F=fileFilters /M=message refNum
	outputPaths = S_fileName
 
	if (strlen(outputPaths) == 0)
		Print "Cancelled"
	else
		Variable numFilesSelected = ItemsInList(outputPaths, "\r")
		Variable i
		for(i=0; i<numFilesSelected; i+=1)
			String path = StringFromList(i, outputPaths, "\r")
			WName= "w"+path[strlen(path)-23,strlen(path)-5]
			LoadWave/Q/O/A=$WName/N/J/L={1,2,0,0,0} path
			
			wave NewWave=$(WName+"0")
			
			Open/R refNum as path
			
			FReadLine refNum, FileNote
			note NewWave, FileNote
	
			///////////

			NewWave/=2^24
			NewWave[]*=.75

			SetScale/P x 0,1/SampleRate,"", NewWave
	
			FilterIIR/CASC/HI=0.002/N={0.12,3} NewWave
			
			// replace dashes with underscores in wave name
			wname=ReplaceString("-", WName, "_")
			Rename NewWave, $wname

		endfor
	endif
 
	return outputPaths		// Will be empty if user canceled
End
//////////////////////////////////////////////////////////////////
//
/////////////////////////////////////////////////////////////////
function GetSpikes()
	
	String/G ListofWaves=wavelist("w*_*",";","")
	
	variable i
	
	for (i=0;i<itemsinlist(ListofWaves);i+=1)
		
		if (stringmatch(stringfromlist(i,ListofWaves), "W_spikes*")==1)
			ListofWaves=removefromlist(stringfromlist(i,ListofWaves),ListofWaves)
			i-=1
		endif
	
	endfor
	
	wave w4display=$stringfromlist(0,ListofWaves)
	
	if(itemsinlist(WinList("Analysis", "","WIN:1 "))==0)
		Display/K=1/W=(917,93,2243,1049) w4display
		DoWindow/C Analysis
	else
		DoWindow/F Analysis
	endif
	
	SetAxis left -0.002,0.002
	ShowInfo
	ShowTools/A
	ControlBar 146
	GroupBox CBSeparator0,pos={0,100},size={1326,4}
	
	Slider WMAxSlSl,pos={50,109},size={1256,13},proc=WMAxisSliderProc
	Slider WMAxSlSl,limits={0,1,0},value= 0.512116316639742,side= 0,vert= 0,ticks= 0
	
	PopupMenu ListOfWave,pos={36,11},size={186,20},proc=PopMenuProc
	PopupMenu ListOfWave,mode=32,value=#"ListofWaves"
	
	Button GetSpikes title="Get Spikes",proc=GetPumps, size={120,22}
	SetVariable Threshold value=K0,  size={120,15}, limits={-inf,inf,1e-6 }
	
	Button RemovePoint pos={492,10}
	Button AddButton pos={589,10}
	Button RemovePoint title="Remove",proc=RemoveButtonProc
	Button AddButton title="Add",proc=AddButtonProc
	
EndMacro
//////////////////////////////////////////////////////////////////////////////////////////////////
//
//////////////////////////////////////////////////////////////////////////////////////////////////
function GetPumps(ba) : ButtonControl
	STRUCT WMButtonAction &ba

	switch( ba.eventCode )
		case 2: // mouse up

			controlInfo ListOfWave
			wave W_input=$S_Value


			duplicate/O W_input, w00

			variable i
			variable threshold_R=k0
			//variable threshold_E=-threshold_R/2

			variable start_time=1 // in sec
			variable end_time=301 // in sec

			variable pumpDuration_min=0.05, pumpDuration_max=.4 // in sec
			variable delta_x=0.002// in sec
			variable IPI_min= 0.1// in sec

			variable lastSpikePosition=-1

			pumpDuration_min/=delta_x //in points
			pumpDuration_max/=delta_x //in points
			IPI_min/=delta_x //in points
			start_time/=delta_x // in points
			end_time/=delta_x // in points

			make/O/N=(Dimsize(w00,0),2) $("W_Spikes_"+nameOfWave(W_input))
			wave w_output=$("W_Spikes_"+nameOfWave(W_input))
			SetScale/P x 0,delta_x,"", w_output
			w_output=nan

			for (i=start_time;i<end_time;i+=1)

				if (k0<0)

					if (((w00[i]-min(0,w00[i-3]))<threshold_R) && ((w00[i]-min(0,w00[i+3]))<threshold_R)==1)
						if ((w00[i]<w00[i-1]) && (w00[i]<w00[i+1])==1)
							w_output[i][1]=1

							wavestats/Q/R=[max(i-pumpDuration_max,lastSpikePosition+IPI_min),i-pumpDuration_min] w00
							w_output[V_maxRowLoc][0]=1

							lastSpikePosition=i
							i+=IPI_min
						endif

					endif
				else 
					if (((w00[i]-max(0,w00[i-3]))>threshold_R) && ((w00[i]-max(0,w00[i+3]))>threshold_R)==1)
						if ((w00[i]>w00[i-1]) && (w00[i]>w00[i+1])==1)
							w_output[i][1]=1

							wavestats/Q/R=[max(i-pumpDuration_max,lastSpikePosition+IPI_min),i-pumpDuration_min] w00
							w_output[V_minRowLoc][0]=1

							lastSpikePosition=i
							i+=IPI_min
						endif

					endif
				
				endif
			endfor

			w_output[][0]*=w00[p]
			w_output[][1]*=w00[p]

			killwaves/Z w00
		case -1: // control being killed
			break
	endswitch

	return 0

end
//////////////////////////////////////////////////////////////////
//
/////////////////////////////////////////////////////////////////
Function PopMenuProc(pa) : PopupMenuControl
	STRUCT WMPopupAction &pa

	string Traces, traceName
	variable i

	switch( pa.eventCode )
		case 2: // mouse up
			Variable popNum = pa.popNum
			String popStr = pa.popStr
			
			wave W_input=$popStr
			
			traces=TraceNameList("", ";", 1 )
			
			for (i=0;i<itemsinlist(Traces);i+=0)
				traceName=stringfromlist(i,Traces)
				
				RemoveFromGraph $(traceName)
				 traces=TraceNameList("", ";", 1 )
			endfor
			appendtograph $popStr
			
			if (exists(("W_Spikes_"+popStr))!=1)
				
				make/O/N=(Dimsize(W_input,0),2) $("W_Spikes_"+popStr)
				
			endif
			
			wave wSpikes=$("W_Spikes_"+popStr)
			SetScale/P x 0,0.002,"", wSpikes
			
			appendtograph wSpikes[][1]
			appendtograph wSpikes[][0]
			ModifyGraph mode($("W_Spikes_"+popStr))=3,marker($("W_Spikes_"+popStr))=19,rgb($("W_Spikes_"+popStr))=(0,0,0), msize($("W_Spikes_"+popStr))=5
			ModifyGraph mode($("W_Spikes_"+popStr+"#1"))=3,marker($("W_Spikes_"+popStr+"#1"))=19,rgb($("W_Spikes_"+popStr+"#1"))=(0,0,65535), msize($("W_Spikes_"+popStr+"#1"))=5
			
			SetAxis left -20e-06,20e-06
			break
		case -1: // control being killed
			break
	endswitch

	return 0
End
//////////////////////////////////////////////////////////////////
//
/////////////////////////////////////////////////////////////////
Function RemoveButtonProc(ba) : ButtonControl
	STRUCT WMButtonAction &ba

	switch( ba.eventCode )
		case 2: // mouse up
			  
			  
			if (strsearch(CsrWave(A),"W_Spikes",0)>=0)  
				wave WSpike=CsrWaveRef(A)
				WSpike[pcsr(A)]=nan
			endif

			break
		case -1: // control being killed
			break
	endswitch

	return 0
End
//////////////////////////////////////////////////////////////////
//
/////////////////////////////////////////////////////////////////
Function AddButtonProc(ba) : ButtonControl
	STRUCT WMButtonAction &ba

	switch( ba.eventCode )
		case 2: // mouse up
			wave w00=$(CsrWave(A))
			wave wSpike=$("W_Spikes_"+CsrWave(A))
			
			
			
			
			if ((k0<0) && (w00[pcsr(A)]<0)==1)
				wSpike[pcsr(A)][1]=w00[pcsr(A)]
				
			elseif ((k0<0) && (w00[pcsr(A)]>0)==1)
				wSpike[pcsr(A)][0]=w00[pcsr(A)]
			elseif ((k0>0) && (w00[pcsr(A)]<0)==1)
				wSpike[pcsr(A)][0]=w00[pcsr(A)]
			elseif ((k0>0) && (w00[pcsr(A)]>0)==1)
				wSpike[pcsr(A)][1]=w00[pcsr(A)]
			endif			
			break
		case -1: // control being killed
			break
	endswitch

	return 0
End
//////////////////////////////////////////////////////////////////
//
/////////////////////////////////////////////////////////////////
function AnalyzeData()

	string wlist=wavelist("W_Spikes_*",";","")
	string wname
	string EPGNAme
	string EPG_note
	string tmpString
	
	variable i
	variable time_0=0
	variable timeCurrent
	variable expNb

	make/O/N=(itemsinlist(wlist)) frequency, Treatment, timing, wormNumber, ExpNumber
	make/T/O/N=(itemsinlist(wlist)) WormName, Orientation

	for (i=0;i<itemsinlist(wlist);i+=1)
		wname=stringfromlist(i,wlist)
		wave w00=$WName

		EPGNAme= ReplaceString("W_Spikes_", WName, "")
		wave wEPG=$EPGNAme
		WormName[i]=WName
		
		EPG_note=note(wEPG)
		
		duplicate/O/R=[][1] w00, tmpwave
		
		wavestats/Q tmpwave
		
		frequency[i]=V_npnts/300
		
		Treatment[i]=sign( strsearch(note(wEPG),  "cephalexin",0,2)) //1 for cephalexin, -1 for control
		
		timeCurrent= str2num(WName[21,22])*3600 + str2num(WName[24,25])*60+str2num( WName[27,28])
		timing[i]=timeCurrent
		
		tmpString= EPG_note[strsearch(EPG_note,"[\"Experiment Number\", true, \"",0)+28,strsearch(EPG_note,"[\"Experiment Number\", true, \"",0)+32]
		tmpString=ReplaceString("]", tmpString, "")
		tmpString=ReplaceString(",", tmpString, "")
		tmpString=ReplaceString("\"", tmpString, "")
		expNumber[i]=str2num(tmpString)
		
		tmpString= EPG_note[strsearch(EPG_note,"Worm Number\", true, \"",0)+19,strsearch(EPG_note,"Worm Number\", true, \"",0)+32]
		tmpString=ReplaceString("]", tmpString, "")
		tmpString=ReplaceString(",", tmpString, "")
		tmpString=ReplaceString("\"", tmpString, "")
		WormNumber[i]=str2num(tmpString)
		
		
		tmpString=EPG_note[strsearch(EPG_note,"Worm Orientation",0)+26,strsearch(EPG_note,"pumping_stimulus",0)-6]
		tmpString=ReplaceString(" ", tmpString, "")
		tmpString=ReplaceString("First", tmpString, "")
		Orientation[i]=tmpString
		 
	endfor
	
	duplicate/O frequency, frequency_CEPH, frequencyControl	
	frequency_CEPH[]*=(Treatment[p]>0)/(Treatment[p]>0)
	frequencyControl[]*=(Treatment[p]<0)/(Treatment[p]<0)

	make/O/N=(2) Treatment4avg, Freq_avg, Freq_sem, Freq_CI

	wavestats/Q/W frequencyControl
	wave M_WaveStats
	Treatment4avg[0]=-1
	Freq_avg[0]=V_avg
	Freq_sem[0]= V_sem
	Freq_CI[0]=M_WaveStats[25]-M_WaveStats[3]

	wavestats/Q/W frequency_CEPH
	wave M_WaveStats
	Treatment4avg[1]=1
	Freq_avg[1]=V_avg
	Freq_sem[1]= V_sem
 	Freq_CI[1]=M_WaveStats[25]-M_WaveStats[3]

	
	killwaves/Z M_WaveStats
end

//////////////////////////////////////////////////////////////////
//
/////////////////////////////////////////////////////////////////
Function ButtonProc(ba) : ButtonControl
	STRUCT WMButtonAction &ba

	switch( ba.eventCode )
		case 2: // mouse up
		
			controlInfo ListOfWave
			
			wave w00=$S_Value

			variable i=0
			variable PeakAmp=k0
			variable Polarity=(sign(k0)==-1)+1 // 1 for positive or 2 for negative
			variable MinTimeBetweenSpikes=0.1


			make/O/N=(0,2) $(S_Value+"_XY")=nan
			wave wSpikes = $(S_Value+"_XY")
			
			for (i=1;i<301;i+=0)

			if (PeakAmp>0)
				findPeak/B=1/Q/R=(i,inf ) w00
			else
				findPeak/N/B=1/Q/R=(i,inf ) w00
			endif

				if (V_Flag!=0)
					break
				endif
				
				if (V_PeakLoc>301)
					break
				endif
			
					if (abs(w00(V_PeakLoc)-w00(V_PeakLoc-0.004))>abs(PeakAmp))
					
						if (abs(w00(V_PeakLoc)-w00(V_PeakLoc+0.04))>abs(PeakAmp))
							if (DimSize(wSpikes,0)>=1)
								if (V_PeakLoc-wSpikes[DimSize(wSpikes,0)-1][0]>MinTimeBetweenSpikes)
									InsertPoints/M=0 DimSize(wSpikes,0), 1, wSpikes
									wSpikes[DimSize(wSpikes,0)-1][0]=V_PeakLoc
									wSpikes[DimSize(wSpikes,0)-1][1]=V_PeakVal

								endif
							else
							
								InsertPoints/M=0 DimSize(wSpikes,0), 1, wSpikes
								wSpikes[DimSize(wSpikes,0)-1][0]=V_PeakLoc
								wSpikes[DimSize(wSpikes,0)-1][1]=V_PeakVal
						
							endif
						endif
					
					endif
				
					i=V_PeakLoc+.002
			endfor
			
			break
		case -1: // control being killed
			break
	endswitch

	return 0
End

