import cv2
import numpy as np
import os
import pandas as pd

folder_path = 'images_file_path'

color_values = [
    (255, 255, 255),  
    (255, 170, 0),  
    (255, 170, 255),   
    (0, 255, 170),   
    (127, 170, 170),  
    
]

tolerance = 10

results = []

for filename in os.listdir(folder_path):

    if filename.endswith(('.jpg', '.png', '.jpeg')):
        file_path = os.path.join(folder_path, filename)
        
        image = cv2.imread(file_path, cv2.IMREAD_COLOR)
        
        if image is None:
            print(f"{filename} skipped")
            continue
        
        center = image.shape[1] // 2

        left_side = image[:, :center]
        right_side = np.fliplr(image[:, center:])

        if left_side.shape[1] != right_side.shape[1]:
            right_side = right_side[:, :left_side.shape[1]]

        symmetry_scores = {'Filename': filename}
        for i, color in enumerate(color_values):
            left_color_mask = np.all(np.abs(left_side - color) <= tolerance, axis=2)
            right_color_mask = np.all(np.abs(right_side - color) <= tolerance, axis=2)

            matching_color_pixels = np.sum(left_color_mask & right_color_mask)
            total_color_pixels = np.sum(left_color_mask | right_color_mask)

            if total_color_pixels == 0:
                symmetry_score = 1.0
            else:
                symmetry_score = matching_color_pixels / total_color_pixels

            symmetry_scores[f'Color {i + 1} (BGR: {color})'] = symmetry_score

        results.append(symmetry_scores)

df = pd.DataFrame(results)

output_file = 'symmetry_scores.xlsx'
df.to_excel(output_file, index=False)

print(f"saved as '{output_file}' ")

