
function [P]= dartquant(infile,outfile,postshockdel,postshockdur,dartthresh)

load(infile)

%%%%%%%%%fear conditioning trials females 

FCfem_vel = FCfem;

for i= 1:58
[FCfpamp,FCfpidx]=findpeaks(FCfem_vel(:,i),'minpeakheight',dartthresh,'minpeakdist',3);
FCfdart_total(i)=length(FCfpidx);
FCfmax_vel(i)=max(FCfem_vel(:,i));

    for j= 1:12
        temp=FCfpidx;temp2=FCfem_vel(:,i);
        FCfrast{i}{j} = temp(find(temp>(FCtoneidx(j)-3.75*60) & temp<(FCtoneidx(j)+3.75*120)))-FCtoneidx(j);
        FCfamprast{i}{j} = temp2(find(temp>(FCtoneidx(j)-3.75*60) & temp<(FCtoneidx(j)+3.75*120)))-FCtoneidx(j);
        FCfdartcnttone(i,j) = length(find(temp>(FCtoneidx(j)) & temp<(FCtoneidx(j)+30*3.75)));
        FCfdartcntshock(i,j) = length(find(temp>[(FCtoneidx(j)+30*3.75+(postshockdel*3.75))] & temp<[(FCtoneidx(j))+30*3.75+(postshockdel*3.75)+(postshockdur*3.75)]));
        FCfdartveltone(i,j) = max(temp2((FCtoneidx(j)):(FCtoneidx(j)+112)));
        FCfdartvelshock(i,j) = max(temp2(ceil((FCtoneidx(j)+112)):ceil((FCtoneidx(j))+112+(postshockdel*3.75)+(postshockdur*3.75))));
    end
end

h1=figure;h1_1=subplot('Position',[0.12 0.1 0.35 0.8]);
n=12*58;hold

FCfhist=zeros(12,45);

for j= 1:12
    temp=[];
    for i= 1:58
        scatter(FCfrast{i}{j},n*ones(length(FCfrast{i}{j}),1),'k','.');n=n-1;
        temp=cat(1,temp,FCfrast{i}{j});
    end
    FCfhist(j,:)=hist((temp),[-224.5:15:449.5] );
end

ylim([0 58*12]);xlim([-225 450]);
set(gca,'XTick',[-225:112.5:450])
set(gca,'XTickLabel',[-60:30:120])
title('FC females dart raster','FontSize',14);xlabel('Time (s)','FontSize',14);ylabel('Trial','FontSize',14);

h1_2=subplot('Position',[0.6 0.1 0.35 0.8]);; image((FCfhist./prctile(FCfhist(:),98))*256); colormap(hot(256));

set(gca,'XTick',[0.5:7.5:45.5])
set(gca,'XTickLabel',[-60:30:120])
title('FC females dart histogram','FontSize',14);xlabel('Time (s)','FontSize',14);ylabel('Trial','FontSize',14);


%%%%%%%%%fear conditioning trials males 

FCmales_vel = FCmales;

for i= 1:56
[FCmpamp,FCmpidx]=findpeaks(FCmales_vel(:,i),'minpeakheight',dartthresh,'minpeakdist',3);
FCmdart_total(i)=length(FCmpidx);
FCmmax_vel(i)=max(FCmales_vel(:,i));
    for j= 1:12
        temp=FCmpidx;temp2=FCmales_vel(:,i);
        FCmrast{i}{j} = temp(find(temp>(FCtoneidx(j)-3.75*60) & temp<(FCtoneidx(j)+3.75*120)))-FCtoneidx(j);
        FCmamprast{i}{j} = temp2(find(temp>(FCtoneidx(j)-3.75*60) & temp<(FCtoneidx(j)+3.75*120)))-FCtoneidx(j);
        FCmdartcnttone(i,j) = length(find(temp>(FCtoneidx(j)) & temp<(FCtoneidx(j)+30*3.75)));
        FCmdartcntshock(i,j) = length(find(temp>[(FCtoneidx(j)+30*3.75+(postshockdel*3.75))] & temp<[(FCtoneidx(j))+30*3.75+(postshockdel*3.75)+(postshockdur*3.75)]));
        FCmdartveltone(i,j) = max(temp2((FCtoneidx(j)):(FCtoneidx(j)+112)));
        FCmdartvelshock(i,j) = max(temp2(ceil((FCtoneidx(j)+112)):ceil((FCtoneidx(j))+112+(postshockdel*3.75)+(postshockdur*3.75))));
    end
end

h2=figure;h2_1=subplot('Position',[0.12 0.1 0.35 0.8]);
n=12*56;hold

FCmhist=zeros(12,45);

for j= 1:12
    temp=[];
    for i= 1:56
        scatter(FCmrast{i}{j},n*ones(length(FCmrast{i}{j}),1),'k','.');n=n-1;
        temp=cat(1,temp,FCmrast{i}{j});
    end
    FCmhist(j,:)=hist((temp),[-224.5:15:449.5] );
end

ylim([0 56*12]);xlim([-225 450]);
set(gca,'XTick',[-225:112.5:450])
set(gca,'XTickLabel',[-60:30:120])
title('FC males dart raster','FontSize',14);xlabel('Time (s)','FontSize',14);ylabel('Trial','FontSize',14);

h2_2=subplot('Position',[0.6 0.1 0.35 0.8]);; image((FCmhist./prctile(FCmhist(:),98))*256); colormap(hot(256));

set(gca,'XTick',[0.5:7.5:45.5])
set(gca,'XTickLabel',[-60:30:120])
title('FC males dart histogram','FontSize',14);xlabel('Time (s)','FontSize',14);ylabel('Trial','FontSize',14);


%%%%%%%%%

%%%%%%%%%

h3=figure;h3_1=subplot('Position',[0.1 0.6 0.8 0.32]);
bar(mean(FCfhist(10:12,:))*(15/58));ylim([0 3])
set(gca,'XTick',[0.5:7.5:45.5])
set(gca,'XTickLabel',[-60:30:120])
title('trials 10-12 FC females dart histogram','FontSize',14);xlabel('Time (s)','FontSize',14);ylabel('darts/min','FontSize',14);

h3_2=subplot('Position',[0.1 0.1 0.8 0.32]);
bar(mean(FCmhist(10:12,:))*(15/56));ylim([0 3])
set(gca,'XTick',[0.5:7.5:45.5])
set(gca,'XTickLabel',[-60:30:120])
title('trials 10-12 FC males dart histogram','FontSize',14);xlabel('Time (s)','FontSize',14);ylabel('darts/min','FontSize',14);

FCmdartcnttone_mean=mean(FCmdartcnttone);
FCmdartcnttone_SEM=std(FCmdartcnttone)./sqrt(56);
FCfdartcnttone_mean=mean(FCfdartcnttone);
FCfdartcnttone_SEM=std(FCfdartcnttone)./sqrt(58);


h4=figure;h4_1=subplot('Position',[0.12 0.1 0.35 0.8]);
plot(mean(FCmdartcnttone),'k'); hold
plot(mean(FCfdartcnttone),'r');
for i = 1:12
    plot([i i],[FCmdartcnttone_mean(i)-FCmdartcnttone_SEM(i) FCmdartcnttone_mean(i)+FCmdartcnttone_SEM(i)],'k');
    plot([i i],[FCfdartcnttone_mean(i)-FCfdartcnttone_SEM(i) FCfdartcnttone_mean(i)+FCfdartcnttone_SEM(i)],'r');
end

xlim([0 13]);
title('dart rate during fear conditiong tone','FontSize',14);xlabel('trial','FontSize',14);ylabel('darts/trial','FontSize',14);

FCmdartcntshock_mean=mean(FCmdartcntshock);
FCmdartcntshock_SEM=std(FCmdartcntshock)./sqrt(56);
FCfdartcntshock_mean=mean(FCfdartcntshock);
FCfdartcntshock_SEM=std(FCfdartcntshock)./sqrt(58);

h4_2=subplot('Position',[0.6 0.1 0.35 0.8]);
plot(mean(FCmdartcntshock),'k'); hold
plot(mean(FCfdartcntshock),'r')

for i = 1:12
    plot([i i],[FCmdartcntshock_mean(i)-FCmdartcntshock_SEM(i) FCmdartcntshock_mean(i)+FCmdartcntshock_SEM(i)],'k');
    plot([i i],[FCfdartcntshock_mean(i)-FCfdartcntshock_SEM(i) FCfdartcntshock_mean(i)+FCfdartcntshock_SEM(i)],'r');
end

xlim([0 13]);
title('dart rate after fear conditiong shock','FontSize',14);xlabel('trial','FontSize',14);ylabel('darts/trial','FontSize',14);


%%%%%%%%%
%%%%%%%%%extinction 1 trials females 

ext1fem_vel = ext1fem;

for i= 1:58
[ext1fpamp,ext1fpidx]=findpeaks(ext1fem_vel(:,i),'minpeakheight',dartthresh,'minpeakdist',3);
ext1fdart_total(i)=length(ext1fpidx);
    for j= 1:20
        temp=ext1fpidx;temp2=ext1fem_vel(:,i);
        ext1frast{i}{j} = temp(find(temp>(ext1toneidx(j)-3.75*60) & temp<(ext1toneidx(j)+3.75*120)))-ext1toneidx(j);
        ext1famprast{i}{j} = temp2(find(temp>(ext1toneidx(j)-3.75*60) & temp<(ext1toneidx(j)+3.75*120)))-ext1toneidx(j);
        ext1fdartcnttone(i,j) = length(find(temp>(ext1toneidx(j)) & temp<(ext1toneidx(j)+30*3.75)));
        ext1fdartcntshock(i,j) = length(find(temp>[(ext1toneidx(j)+30*3.75+(postshockdel*3.75))] & temp<[(ext1toneidx(j))+30*3.75+(postshockdel*3.75)+(postshockdur*3.75)]));
        ext1fdartveltone(i,j) = max(temp2((ext1toneidx(j)):(ext1toneidx(j)+112)));
        ext1fdartvelshock(i,j) = max(temp2(ceil((ext1toneidx(j)+112)):ceil((ext1toneidx(j))+112+(postshockdel*3.75)+(postshockdur*3.75))));
    end
end

h5=figure;h5_1=subplot('Position',[0.12 0.1 0.35 0.8]);
n=20*58;hold

ext1fhist=zeros(20,45);

for j= 1:20
    temp=[];
    for i= 1:58
        scatter(ext1frast{i}{j},n*ones(length(ext1frast{i}{j}),1),'k','.');n=n-1;
        temp=cat(1,temp,ext1frast{i}{j});
    end
    ext1fhist(j,:)=hist((temp),[-224.5:15:449.5] );
end

ylim([0 58*20]);xlim([-225 450]);
set(gca,'XTick',[-225:112.5:450])
set(gca,'XTickLabel',[-60:30:120])
title('ext1 females dart raster','FontSize',14);xlabel('Time (s)','FontSize',14);ylabel('Trial','FontSize',14);

h5_2=subplot('Position',[0.6 0.1 0.35 0.8]);; image((ext1fhist./prctile(ext1fhist(:),98))*256); colormap(hot(256));

set(gca,'XTick',[0.5:7.5:45.5])
set(gca,'XTickLabel',[-60:30:120])
title('ext1 females dart histogram','FontSize',14);xlabel('Time (s)','FontSize',14);ylabel('Trial','FontSize',14);

%%%%%%%%%extinction 1 trials males 

ext1males_vel = ext1males;

for i= 1:56
[ext1mpamp,ext1mpidx]=findpeaks(ext1males_vel(:,i),'minpeakheight',dartthresh,'minpeakdist',3);
ext1mdart_total(i)=length(ext1mpidx);
    for j= 1:20
        temp=ext1mpidx;temp2=ext1males_vel(:,i);
        ext1mrast{i}{j} = temp(find(temp>(ext1toneidx(j)-3.75*60) & temp<(ext1toneidx(j)+3.75*120)))-ext1toneidx(j);
        ext1mamprast{i}{j} = temp2(find(temp>(ext1toneidx(j)-3.75*60) & temp<(ext1toneidx(j)+3.75*120)))-ext1toneidx(j);
        ext1mdartcnttone(i,j) = length(find(temp>(ext1toneidx(j)) & temp<(ext1toneidx(j)+30*3.75)));
        ext1mdartcntshock(i,j) = length(find(temp>[(ext1toneidx(j)+30*3.75+(postshockdel*3.75))] & temp<[(ext1toneidx(j))+30*3.75+(postshockdel*3.75)+(postshockdur*3.75)]));
        ext1mdartveltone(i,j) = max(temp2((ext1toneidx(j)):(ext1toneidx(j)+112)));
        ext1mdartvelshock(i,j) = max(temp2(ceil((ext1toneidx(j)+112)):ceil((ext1toneidx(j))+112+(postshockdel*3.75)+(postshockdur*3.75))));
    end
end

h6=figure;h6_1=subplot('Position',[0.12 0.1 0.35 0.8]);
n=20*56;hold

ext1mhist=zeros(20,45);

for j= 1:20
    temp=[];
    for i= 1:56
        scatter(ext1mrast{i}{j},n*ones(length(ext1mrast{i}{j}),1),'k','.');n=n-1;
        temp=cat(1,temp,ext1mrast{i}{j});
    end
    ext1mhist(j,:)=hist((temp),[-224.5:15:449.5] );
end

ylim([0 56*20]);xlim([-225 450]);
set(gca,'XTick',[-225:112.5:450])
set(gca,'XTickLabel',[-60:30:120])
title('ext1 males dart raster','FontSize',14);xlabel('Time (s)','FontSize',14);ylabel('Trial','FontSize',14);

h6_2=subplot('Position',[0.6 0.1 0.35 0.8]);; image((ext1mhist./prctile(ext1mhist(:),98))*256); colormap(hot(256));

set(gca,'XTick',[0.5:7.5:45.5])
set(gca,'XTickLabel',[-60:30:120])
title('ext1 males dart histogram','FontSize',14);xlabel('Time (s)','FontSize',14);ylabel('Trial','FontSize',14);



%%%%%%%%%

%%%%%%%%%
h7=figure;h7_1=subplot('Position',[0.1 0.6 0.8 0.32]);
bar(mean(ext1fhist(1:3,:))*(15/58));ylim([0 3])
set(gca,'XTick',[0.5:7.5:45.5])
set(gca,'XTickLabel',[-60:30:120])
title('trials 1-3 ext1 females dart histogram','FontSize',14);xlabel('Time (s)','FontSize',14);ylabel('darts/min','FontSize',14);

h7_2=subplot('Position',[0.1 0.1 0.8 0.32]);
bar(mean(ext1mhist(1:3,:))*(15/56));ylim([0 3])
set(gca,'XTick',[0.5:7.5:45.5])
set(gca,'XTickLabel',[-60:30:120])
title('trials 1-3 ext1 males dart histogram','FontSize',14);xlabel('Time (s)','FontSize',14);ylabel('darts/min','FontSize',14);

ext1mdartcnttone_mean=mean(ext1mdartcnttone);
ext1mdartcnttone_SEM=std(ext1mdartcnttone)./sqrt(56);
ext1fdartcnttone_mean=mean(ext1fdartcnttone);
ext1fdartcnttone_SEM=std(ext1fdartcnttone)./sqrt(58);


h8=figure;h8_1=subplot('Position',[0.12 0.1 0.35 0.8]);
plot(mean(ext1mdartcnttone),'k'); hold
plot(mean(ext1fdartcnttone),'r');
for i = 1:20
    plot([i i],[ext1mdartcnttone_mean(i)-ext1mdartcnttone_SEM(i) ext1mdartcnttone_mean(i)+ext1mdartcnttone_SEM(i)],'k');
    plot([i i],[ext1fdartcnttone_mean(i)-ext1fdartcnttone_SEM(i) ext1fdartcnttone_mean(i)+ext1fdartcnttone_SEM(i)],'r');
end

xlim([0 21]);
title('dart rate during extinction 1 tone','FontSize',14);xlabel('trial','FontSize',14);ylabel('darts/trial','FontSize',14);

ext1mdartcntshock_mean=mean(ext1mdartcntshock);
ext1mdartcntshock_SEM=std(ext1mdartcntshock)./sqrt(56);
ext1fdartcntshock_mean=mean(ext1fdartcntshock);
ext1fdartcntshock_SEM=std(ext1fdartcntshock)./sqrt(58);

h8_2=subplot('Position',[0.58 0.1 0.4 0.8]);
plot(mean(ext1mdartcntshock),'k'); hold
plot(mean(ext1fdartcntshock),'r')

for i = 1:20
    plot([i i],[ext1mdartcntshock_mean(i)-ext1mdartcntshock_SEM(i) ext1mdartcntshock_mean(i)+ext1mdartcntshock_SEM(i)],'k');
    plot([i i],[ext1fdartcntshock_mean(i)-ext1fdartcntshock_SEM(i) ext1fdartcntshock_mean(i)+ext1fdartcntshock_SEM(i)],'r');
end

xlim([0 20]);
title('dart rate after extinction 1 shock','FontSize',14);xlabel('trial','FontSize',14);ylabel('darts/trial','FontSize',14);

%%%%%%%%%%%%%%%
figure
scatter(FCfdart_total,FCfmax_vel,'r','filled');
hold
scatter(FCmdart_total,FCmmax_vel,'k','filled');

title('segregating darters','FontSize',14);xlabel('total number of darts','FontSize',14);ylabel('max velocity','FontSize',14);

figure
hist(cat(2,FCfdart_total,FCmdart_total),[0:2:120]);
title('segregating darters by dart count','FontSize',14);xlabel('total number of darts','FontSize',14);ylabel('count','FontSize',14);

figure
hist(cat(2,FCfmax_vel,FCmmax_vel),[10:2:80]);
title('segregating darters by top speed','FontSize',14);xlabel('max velocity','FontSize',14);ylabel('count','FontSize',14);

figure
scatter(FCfdart_total,ext1fdart_total,'r','filled');
hold
scatter(FCmdart_total,ext1mdart_total,'k','filled');
title('correlating dart count','FontSize',14);xlabel('total number of FC darts','FontSize',14);ylabel('total number of ext1 darts','FontSize',14);

[r,p]=corrcoef(FCfdart_total,ext1fdart_total)
[r,p]=corrcoef(FCmdart_total,ext1mdart_total)

save (outfile)


