/*
 *  Energy_fit.h
 *  SimAnn
 *
 *  Created by Patrick Hillenbrand on 5/3/12.
 *  Copyright 2012 __MyCompanyName__. All rights reserved.
 *
 */

#include <vector>

#include "LamSimAnn.h"


class Energy_fit: public Energy_base
{
	
public:
	// contructor / destructor
	explicit Energy_fit(int logic, std::vector<double> trg_syn, std::vector<double> LB, std::vector<double> UB, std::vector< std::vector<double> > p_t1);
	explicit Energy_fit(int logic, std::vector<double> trg_syn, std::vector<double> LB, std::vector<double> UB, std::vector< std::vector<double> > p_t1, std::vector< std::vector<double> > p_t2);
	explicit Energy_fit(int logic, std::vector<double> trg_syn, std::vector<double> LB, std::vector<double> UB, std::vector< std::vector<double> > p_t1, std::vector< std::vector<double> > p_t2, std::vector< std::vector<double> > p_t3);
	~Energy_fit();
	
	// interace
	virtual double Energy (double *par);
	virtual unsigned int GetN ();
	virtual double* GetLB ();
	virtual double* GetUB ();
	
	//data
private:
	unsigned int m_N;
	int m_logic;
	std::vector<double> m_LB;
	std::vector<double> m_UB;
	
	std::vector<double> trgs;
		
	std::vector< std::vector<double> > pt1;
	std::vector< std::vector<double> > pt2;
	std::vector< std::vector<double> > pt3;
	
	int i;
	int ind1,ind2,ind3;
	double fac1,fac2,fac3;
	std::vector<double>::iterator pit1,pit2,pit3,sit;
	double a,b,K1,K2,K3,n1,n2,n3;
	double tmp,tmp1,tmp2,tmp3;
	
	// auxiliary functions
	
};